<?php 
namespace Sesion\Configuracion;
class Config {

	public static function parseIni($section,$value) {
		$file = '.ini.php';
		$content = parse_ini_file($file,true);
		return $content[$section][$value];
	}
	public static function jsonFile() {
		$rt = self::parseIni('File','Json_File');
		if(file_exists($rt)) {
			$file = $rt;
		} else {
			$file = '../../../'.$rt;
		}
		return $file;
	}

	public static function txtFile() {
		$rt = self::parseIni('File','Txt_File');
		if(file_exists($rt)) {
			$file = $rt;
		} else {
			$file = '../../../'.$rt;
		}
		return $file;
	}

	public static function messageSesion() {
		return self::parseIni('Msg','Sesion');
	}

	public static function fileNoExist() {
		return self::parseIni('Msg','File_No_Exist');
	}

	public static function CaptureData() {
		return $_SERVER[self::parseIni('File','Mode_Detection')];
		// return $_SERVER['REMOTE_ADDR'];
	}

	public static function SessionStarted() {
		$fecha = date('m-d-Y H:i:s');
		$cad_1 = ['{{DATE}}','{{IP_LAN}}'];
		$cad_2 = [$fecha,self::CaptureData()];
		$txt = str_replace($cad_1,$cad_2,self::parseIni('Msg','Sesion_Started'));
		return $txt;
	}

	public static function SessionCreated($user,$name_user) {
		$fecha = date('m-d-Y H:i:s');
		$cad_1 = ['{{DATE}}','{{USER}}','{{IP_LAN}}'];
		$cad_2 = [$fecha,$user.' ('.$name_user.')',self::CaptureData()];
		$txt = str_replace($cad_1,$cad_2,self::parseIni('Msg','Sesion_Created'));
		return $txt;
	}

	public static function CaptureUserAgent() {
       return $_SERVER[self::parseIni('File','User_Agent')];
    }

    public static function CaptureUserId() {
       return $_SESSION['usr'];
    }
}