function renderCanvas(canvas, ctx) {
  var drawing = false;
	var mousePos = { x:0, y:0 };
	var lastPos = mousePos;

	// Activamos MouseEvent para nuestra pagina
	canvas.addEventListener("mousedown", function (e)
	{
		var tint = 'black';
		var punta = 2;
		drawing = true;
		lastPos = getMousePos(canvas, e);
	}, false);

	canvas.addEventListener("mouseup", function (e)
	{
		drawing = false;
	}, false);

	canvas.addEventListener("mousemove", function (e)
	{
		mousePos = getMousePos(canvas, e);
	}, false);

	// Activamos touchEvent para nuestra pagina
	canvas.addEventListener("touchstart", function (e) {
		mousePos = getTouchPos(canvas, e);
		e.preventDefault(); // Prevent scrolling when touching the canvas
		var touch = e.touches[0];
		var mouseEvent = new MouseEvent("mousedown", {
			clientX: touch.clientX,
			clientY: touch.clientY
		});
		canvas.dispatchEvent(mouseEvent);
	}, false);

	canvas.addEventListener("touchend", function (e) {
		e.preventDefault(); // Prevent scrolling when touching the canvas
		var mouseEvent = new MouseEvent("mouseup", {});
		canvas.dispatchEvent(mouseEvent);
	}, false);

	canvas.addEventListener("touchleave", function (e) {
		// Realiza el mismo proceso que touchend en caso de que el dedo se deslice fuera del canvas
		e.preventDefault(); // Prevent scrolling when touching the canvas
		var mouseEvent = new MouseEvent("mouseup", {});
		canvas.dispatchEvent(mouseEvent);
	}, false);

	canvas.addEventListener("touchmove", function (e) {
		e.preventDefault(); // Prevent scrolling when touching the canvas
		var touch = e.touches[0];
		var mouseEvent = new MouseEvent("mousemove", {
			clientX: touch.clientX,
			clientY: touch.clientY
		});
		canvas.dispatchEvent(mouseEvent);
	}, false);

	// Draw to the canvas
	function showCanvas() {
		if (drawing) {
			console.log('llega');
			var tint = 'black';
      var punta = 2;
      ctx.strokeStyle = tint;
      ctx.beginPath();
			ctx.moveTo(lastPos.x, lastPos.y);
			ctx.lineTo(mousePos.x, mousePos.y);
    	ctx.lineWidth = punta;
			ctx.stroke();
      ctx.closePath();
			lastPos = mousePos;
		}
	}
	showCanvas()
}

// Get the position of the mouse relative to the canvas
function getMousePos(canvasDom, mouseEvent) {
  var rect = canvasDom.getBoundingClientRect();
  /*
    Devuelve el tamaño de un elemento y su posición relativa respecto
    a la ventana de visualización (viewport).
  */
  return {
    x: mouseEvent.clientX - rect.left,
    y: mouseEvent.clientY - rect.top
  };
}

// Get the position of a touch relative to the canvas
function getTouchPos(canvasDom, touchEvent) {
  var rect = canvasDom.getBoundingClientRect();
  /*
    Devuelve el tamaño de un elemento y su posición relativa respecto
    a la ventana de visualización (viewport).
  */
  return {
    x: touchEvent.touches[0].clientX - rect.left, // Popiedad de todo evento Touch
    y: touchEvent.touches[0].clientY - rect.top
  };
}

function clearCanvas() {
  canvas.width = canvas.width;
}