<?php 
if(file_exists('cfg/')) {
	require 'cfg/conexion.php';
	require 'cfg/config.php';
	require 'cfg/funciones.php';
	require 'lib/PHPMailer/src/PHPMailer.php';
	require 'lib/PHPMailer/src/Exception.php';
	require 'lib/PHPMailer/src/SMTP.php';
	require 'lib/sesion/Config.php';
	require 'lib/sesion/Control.php';
} else {
	require '../../../cfg/conexion.php';
	require '../../../cfg/config.php';
	require '../../../cfg/funciones.php';
	require '../../../lib/PHPMailer/src/PHPMailer.php';
	require '../../../lib/PHPMailer/src/Exception.php';
	require '../../../lib/PHPMailer/src/SMTP.php';
	require '../../../lib/sesion/Config.php';
	require '../../../lib/sesion/Control.php';
}

$folders = array(
		'usuarios',
		'historia',
		'general',
		'diagnos',
		'proced',
		'diagproc',
		'ortodon',
		'examen',
		'recipes',
		'radiogra',
		'odonto',
		'citas',
		'correo',
		'reportes',
		'informe',
		'turno',
		'pagos',
		'remision',
		'endodoncia',
		'dolar',
		'unidmed',
		'producto',
		'receta',
		'especialidad',
		'examlista',
		'compra',
		'proveedores',
		'impuesto',
		'anamnesis',
		'motivo',
		'odontologo',
		'consenti',
		'constancia',
		'medicamento',
		'indicacion',
		'evolgeneral',
		'bancos',
		'clinica',
		'horario',
		'moneda',
		'graficas',
		'documentos',
		'especialista'
	);

$clases = array(
		array('mUsuarios','cUsuarios'),
		array('mHistoria','cHistoria'),
		array('mGeneral','cGeneral'),
		array('mDiagnos','cDiagnos'),
		array('mProced','cProced'),
		array('mDiagproc','cDiagproc'),
		array('mOrtodon','cOrtodon'),
		array('mExamen','cExamen'),
		array('mRecipes','cRecipes'),
		array('mRadiogra','cRadiogra'),
		array('mOdonto','cOdonto'),
		array('mCitas','cCitas'),
		array('mCorreo','cCorreo'),
		array('mReportes','cReportes'),
		array('mInforme','cInforme'),
		array('mTurno','cTurno'),
		array('mPagos','cPagos'),
		array('mRemision','cRemision'),
		array('mEndo','cEndo'),
		array('mDolar','cDolar'),
		array('mUnidmed','cUnidmed'),
		array('mProducto','cProducto'),
		array('mReceta','cReceta'),
		array('mEspecialidad','cEspecialidad'),
		array('mExamlista','cExamlista'),
		array('mCompra','cCompra'),
		array('mProveedores','cProveedores'),
		array('mImpuesto','cImpuesto'),
		array('mAnamnesis','cAnamnesis'),
		array('mMotivo','cMotivo'),
		array('mOdontologo','cOdontologo'),
		array('mConsenti','cConsenti'),
		array('mConstancia','cConstancia'),
		array('mMedicamento','cMedicamento'),
		array('mIndicacion','cIndicacion'),
		array('mEvolgene','cEvolgene'),
		array('mBancos','cBancos'),
		array('mClinica','cClinica'),
		array('mHorario','cHorario'),
		array('mMoneda','cMoneda'),
		array('mGraficas','cGraficas'),
		array('mDocumento','cDocumento'),
		array('mEspecialista','cEspecialista')
	);

foreach($folders as $ind=>$f) {
	foreach($clases[$ind] as $c) {
		if(file_exists('app/'.$f.'/clases/')) {
			require 'app/'.$f.'/clases/'.$c.'.php';
		} else {
			if(file_exists('../../'.$f.'/clases/')) {
				require '../../'.$f.'/clases/'.$c.'.php';
			} else {
				if(file_exists('../clases/'.$c[0].'.php')) {
					require '../clases/'.$c.'.php';
				}
			}
		}
	}
}

#Instancias
#$con = new Conexion();
$fun = new Funciones();
$inst_sesion_lib = new Control();
foreach($folders as $ind=>$f) {
	foreach($clases[$ind] as $c) {
		$clase = strtolower($c);
		$$clase = new $c();
	}
}