<?php 
	require '../../../cfg/base.php';
	$tipo_usua_rows = $musuarios->tiposDeUsuario();
	$especialidad = $mespecialidad->especSelect();
	$clinicas = $mclinica->lista();
	$odontologos = $musuarios->usuarioOdontologo();
?>

<style>
#firma-doctor {
  border: 2px dotted #CCCCCC;
  border-radius: 5px;
  cursor: crosshair;
}
</style>

<div class="col-xs-12 col-md-12 col-sm-1">
	<h5><strong>Nuevo Usuario</strong></h5>
</div>

<div class="col-xs-12 col-md-12 col-sm-12">
	<div class="msj"></div>
	<form action="" class="form-horizontal usuario-insert">
		<div class="form-group">
			<label for="" class="control-label col-sm-4 bolder">Documento de Identificacion:</label>
			<div class="col-sm-8 input-group" style="display: flex;">
				<select name="nac" id="" style="height: 34px !important;">
					<option value="CC">CC</option>
					<option value="CE">CE</option>
					<option value="TI">TI</option>
				</select>
				<input type="text" class="form-control" name="cedrif">
			</div>
		</div>

		<div class="form-group">
			<label for="" class="control-label col-sm-4 bolder">Nombres y Apellidos:</label>
			<div class="col-sm-8">
				<input type="text" class="form-control col-sm-7" name="nomraz">
			</div>
		</div>

		<div class="form-group">
			<label for="" class="control-label col-sm-4 bolder">Nombre de Usuario:</label>
			<div class="col-sm-8">
				<input type="text" class="form-control col-sm-7" name="usuario">
			</div>
		</div>

		<div class="form-group">
			<label for="" class="control-label col-sm-4 bolder">Tipo de Usuario:</label>
			<div class="col-sm-8">
				<select name="tipo" id="tipo" class="col-sm-12">
					<option value=""></option>
					<?php foreach($tipo_usua_rows as $tur) { ?>
						<option value="<?php echo $tur->nivusuario_codigo ?>"><?php echo $tur->nivusuario_descripcion ?></option>
					<?php } ?>
				</select>
			</div>
		</div>

		<div class="form-group" id="clinicas">
			<label for="" class="control-label col-sm-4 bolder">Clinicas:</label>
			<div class="col-sm-8">
				<select name="clinica[]" id="clinica" class="chosen-multiple" multiple>
				<?php foreach($clinicas as $r) : ?>
					<option value="<?php echo $r->clinica_ide ?>"><?php echo $r->clinica_descripcion ?></option>
				<?php endforeach; ?>
				</select>
			</div>
		</div>

		<!-- <div class="form-group" id="odontologos">
			<label for="" class="control-label col-sm-4 bolder">Odontol&oacute;go:</label>
			<div class="col-sm-7">
				<select name="odonto[]" id="odonto" class="chosen-multiple" multiple>
				<?php //foreach($odontologos as $r) : ?>
					<option value="<?php //echo $r->pers_cedrif ?>"><?php //echo $r->pacien_nomraz ?></option>
				<?php //endforeach; ?>
				</select>
			</div>
		</div> -->

		<div class="form-group" id="especialidad">
			<label for="" class="control-label col-sm-4 bolder">Especialidad:</label>
			<div class="col-sm-8">
				<select name="espec[]" id="espec" class="chosen-multiple" multiple>
				<?php foreach($especialidad as $r) : ?>
					<option value="<?php echo $r->espec_ide ?>"><?php echo $r->espec_descrip ?></option>
				<?php endforeach; ?>
				</select>
			</div>
		</div>

		<div class="form-group">
			<label for="" class="control-label col-sm-4 bolder">Clave de Acceso:</label>
			<div class="col-sm-8">
				<input type="password" class="form-control col-sm-7" value="1234" name="clave" id="clave">
			</div>
		</div>

		<div class="form-group">
			<label for="" class="control-label col-sm-4 bolder">Confirme Clave:</label>
			<div class="col-sm-8">
				<input type="password" class="form-control col-sm-7" value="1234" name="clave2">
			</div>
		</div>

		<div class="form-group firma-doctor" hidden>
			<label for="" class="control-label col-sm-4 bolder">Firma del Doctor:</label>
			<div class="col-sm-8">
				<canvas id="firma-doctor" width="300" height="150"></canvas>
				<button type="button" class="btn btn-secundary btn-sm" id="clear-fdoctor">Borrar Firma</button>
			</div>
		</div>
		
		<div class="clearfix"></div>
		<div class="clearfix form-actions">
			<input type="hidden" name="img-firma-doctor" id="img-firma-doctor" value="" >
			<button class="btn btn-primary pull-right">Guardar</button>
			<button class="btn btn-default pull-right cancel" type="button">Cancelar</button>		
		</div>
		
	</form>
</div>
<script>
	$("#espec").chosen({
		no_results_text: 'No hay resultados',
		width: "87%"
	});

	$('#clinica').chosen({
		no_results_text:'No hay cohincidencias',
		width:'100%'
	})

	$('#odonto').chosen({
		no_results_text:'No hay cohincidencias',
		width:'100%'
	})

	$(document).ready(function(){
		$('.button-add').hide();
		$('.cancel').on('click', function(){
			cancel();
		});

		$("#especialidad").hide();
		$("#clinicas").hide();
		$("#odontologos").hide();
	});

	function cancel(){
		location.reload()
	}

	$("#tipo").chosen({
		no_results_text:'No hay cohincidencias',
		width:'100%'
	}).change(function(){
		if (($(this).val() == 2) || ($(this).val() == 3)) {
			$("#clinicas").show();
			$("#especialidad").show();
			$(".firma-doctor").show();
			// $("#odontologos").hide();
		}
		// else if($(this).val() == 5){
		// 	$("#clinicas").show();
		// 	$("#odontologos").show();
		// 	$("#especialidad").hide();
		// }
		else{
			$("#clinicas").hide();
			// $("#odontologos").hide();
			$("#especialidad").hide();
			$(".firma-doctor").hide();
		}
	});

	window.requestAnimFrame = (function (callback) {
		return window.requestAnimationFrame ||
					window.webkitRequestAnimationFrame ||
					window.mozRequestAnimationFrame ||
					window.oRequestAnimationFrame ||
					window.msRequestAnimaitonFrame ||
					function (callback) {
					 	window.setTimeout(callback, 1000/60);
            // Retrasa la ejecucion de la funcion para mejorar la experiencia
					};
	})();

	var canvasDoctor = document.getElementById("firma-doctor");
	var ctxDoctor = canvasDoctor.getContext("2d");

	var clearBtnDoctor = document.getElementById("clear-fdoctor");
	clearBtnDoctor.addEventListener("click", function (e) {
		// Definimos que pasa cuando el boton draw-clearBtn es pulsado
		clearCanvasDoctor();
	}, false);

	var drawingDoctor = false;
	var mousePosDoctor = { x:0, y:0 };
	var lastPosDoctor = mousePosDoctor;

	canvasDoctor.addEventListener("mousedown", function (e)
  {
		var tint = 'black';
    var punta = 2;
		drawingDoctor = true;
		lastPosDoctor = getMousePosDoctor(canvasDoctor, e);
	}, false);
	canvasDoctor.addEventListener("mouseup", function (e)
  {
		drawingDoctor = false;
	}, false);
	canvasDoctor.addEventListener("mousemove", function (e)
  {
		mousePosDoctor = getMousePosDoctor(canvasDoctor, e);
	}, false);

	// Activamos touchEvent para nuestra pagina
	canvasDoctor.addEventListener("touchstart", function (e) {
		mousePosDoctor = getTouchPosDoctor(canvasDoctor, e);
    e.preventDefault(); // Prevent scrolling when touching the canvas
		var touchDoctor = e.touches[0];
		var mouseEventDoctor = new MouseEvent("mousedown", {
			clientX: touchDoctor.clientX,
			clientY: touchDoctor.clientY
		});
		canvasDoctor.dispatchEvent(mouseEventDoctor);
	}, false);
	canvasDoctor.addEventListener("touchend", function (e) {
    e.preventDefault(); // Prevent scrolling when touching the canvas
		var mouseEventDoctor = new MouseEvent("mouseup", {});
		canvasDoctor.dispatchEvent(mouseEventDoctor);
	}, false);
  canvasDoctor.addEventListener("touchleave", function (e) {
    // Realiza el mismo proceso que touchend en caso de que el dedo se deslice fuera del canvas
    e.preventDefault(); // Prevent scrolling when touching the canvas
    var mouseEventDoctor = new MouseEvent("mouseup", {});
    canvasDoctor.dispatchEvent(mouseEventDoctor);
  }, false);
	canvasDoctor.addEventListener("touchmove", function (e) {
    e.preventDefault(); // Prevent scrolling when touching the canvas
		var touchDoctor = e.touches[0];
		var mouseEventDoctor = new MouseEvent("mousemove", {
			clientX: touchDoctor.clientX,
			clientY: touchDoctor.clientY
		});
		canvasDoctor.dispatchEvent(mouseEventDoctor);
	}, false);

	// Get the position of the mouse relative to the canvas
	function getMousePosDoctor(canvasDom, mouseEvent) {
		var rect = canvasDom.getBoundingClientRect();
		return {
			x: mouseEvent.clientX - rect.left,
			y: mouseEvent.clientY - rect.top
		};
	}

	// Get the position of a touch relative to the canvas
	function getTouchPosDoctor(canvasDom, touchEvent) {
		var rect = canvasDom.getBoundingClientRect();
		return {
			x: touchEvent.touches[0].clientX - rect.left, // Popiedad de todo evento Touch
			y: touchEvent.touches[0].clientY - rect.top
		};
	}

	function renderCanvasDoctor() {
		if (drawingDoctor) {
      var tint = 'black';
      var punta = 2;
      ctxDoctor.strokeStyle = tint;
      ctxDoctor.beginPath();
			ctxDoctor.moveTo(lastPosDoctor.x, lastPosDoctor.y);
			ctxDoctor.lineTo(mousePosDoctor.x, mousePosDoctor.y);
    	ctxDoctor.lineWidth = punta;
			ctxDoctor.stroke();
      ctxDoctor.closePath();
			lastPosDoctor = mousePosDoctor;
		}
	}

	function clearCanvasDoctor() {
		canvasDoctor.width = canvasDoctor.width;
	}

	// Allow for animation
	(function drawLoop () {
		requestAnimFrame(drawLoop);
		renderCanvasDoctor();
	})();

	$(function(){

		$('.usuario-insert').validate({
			errorElement: 'div',
			errorClass: 'help-block',
			focusInvalid: true,
			rules: {
				cedula: {
					required: true,
					number: true,
					minlength: 7,
				},
				nomraz: {
					required: true
				},
				usuario: {
					required: true
				},
				tipo: {
					required: true
				},
				clave: {
					required: true
				},
				clave2: {
					required: true,
					equalTo: "#clave"
				}
			},
			messages: {
				cedula: {
					required: "Indique Nro Identificación",
					minlength: 'Número de Nro Identificación no válido',
					number: 'Debe indicar un valor numérico'
				},
				nomraz: {
					required: 'Debe indicar el nombre'
				},
				usuario: {
					required: 'Indique su nombre de usuario'
				},
				tipo: {
					required: 'Seleccione un tipo de usuario'
				},
				clave: {
					required: 'La clave es obligatoria'
				},
				clave2: {
					required: 'La confirmación es obligatoria',
					equalTo: "Las claves no coinciden"
				}
			},
			invalidHandler: function (event, validator) { 
				$('.alert-danger', $('.usuario-insert')).show();
			},			
			highlight: function (e) {
				$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
			},
			success: function (e) {
				$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
				$(e).remove();
			},
			submitHandler: function (form) {
				var tipo = $('#tipo').val();
				var espec = $('#espec').val();
				var clinica = $('#clinica').val();
				
				if (!tipo) {
					alerta('.msj','danger','Seleccione el tipo de usuario');
					return false;
				} else if (tipo && ['2', '3'].includes(tipo) && (!espec || !clinica)) {
					alerta('.msj','danger','Seleccione una especialidad y clinica');
					return false;
				}

				var canvasDoctor = document.getElementById("firma-doctor");
				var imageDoctor = canvasDoctor.toDataURL();
				document.getElementById('img-firma-doctor').value = imageDoctor;

				var formData = new FormData(form);

				$.ajax({
				url: 'app/usuarios/procesos/p.usuario.insert.php',
					type: 'POST',
					data: formData,
					cache: false,
					contentType: false,
					processData: false,
					success: function (data) {
						if(data==1){
							alerta('.msj','success','Registro Guardado correctamente');
							setTimeout(cancel(),1000);
						} else {
							alerta('.msj','danger',data);
						}
					}
				});
			},
			invalidHandler: function (form) {
			}
		})
	})
</script>