<?php 
class mUsuarios {

	protected $dbh,$con,$msj;

	function __clone() {

	} #clone

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	} #construct

	function comprobarSesion() {
		if(isset($_SESSION['usr'])) {
			$rt = 1;
		} else {
			$rt = 2;
		}
		return $rt;
	}

	function selectSubModulos() {
		$sql = "SELECT * from tbl_submodulos AS s 
		INNER JOIN tbl_modulos AS m ON s.modu_ide=m.modu_ide where subm_status=1 order by modu_ord, subm_ord ASC";
		$res = $this->con->prepare($sql);
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function permisoSubmodulo($subm,$nivel) {
		$sql = "SELECT * FROM tbl_permisos WHERE subm_ide=? and nivusuario_codigo=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$subm);
		$res->bindParam(2,$nivel);
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function selectFichas($tipo) {
		$sql = "SELECT * from tbl_fichas where fich_tipo=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$tipo);
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function permisoFichas($tius,$fich) {
		$sql = "SELECT * FROM tbl_permfich WHERE pefi_tius=? and pefi_fich=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$tius);
		$res->bindParam(2,$fich);
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function lista_fichas_permitidas($tius,$tipo) {
		$sql = "SELECT * FROM vw_permfich WHERE pefi_tius=? and fich_tipo=? and pefi_estado=1 order by fich_orden asc";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$tius);
		$res->bindParam(2,$tipo);
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function iniciarSesion() {
	     $pass=md5($this->pwd);
		 $sql = "SELECT u.*, p.pacien_nomraz FROM tbl_usuario AS u 
		INNER JOIN tbl_pacien AS p ON u.pers_cedrif=p.pacien_cedrif
		WHERE 
				u.usuario_login=? and 
				u.usuario_clave=? and 
				u.usuario_status='1'";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->usr);
		$res->bindParam(2,$pass);
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function modulosUsuario() {
		$sql = "SELECT m.modu_des,m.modu_ide,m.modu_ico FROM tbl_permisos AS p 
			INNER JOIN tbl_submodulos AS s ON p.subm_ide=s.subm_ide
			INNER JOIN tbl_modulos AS m ON s.modu_ide=m.modu_ide
			WHERE p.perm_est=1 AND p.nivusuario_codigo=?
			GROUP BY m.modu_ide
			ORDER BY m.modu_ord ASC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$_SESSION['niv']);
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function subModulosUsuario($modu) {
		$sql = "SELECT s.subm_des, s.subm_ide, s.subm_ord, s.subm_ico FROM tbl_permisos AS p 
			INNER JOIN tbl_submodulos AS s ON p.subm_ide=s.subm_ide
			WHERE s.modu_ide=? AND p.perm_est=1 AND p.nivusuario_codigo=?  AND s.subm_status=1
			ORDER BY s.subm_ord ASC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$modu);
		$res->bindParam(2,$_SESSION['niv']);
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function contenido($var) {
		$url = base64_decode($var);
		$sql = "SELECT * FROM tbl_permisos AS p 
			INNER JOIN tbl_submodulos AS sm ON p.subm_ide=sm.subm_ide
			WHERE sm.subm_ide=? AND p.perm_est=1 AND p.nivusuario_codigo=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$url);
		$res->bindParam(2,$_SESSION['niv']);
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function selectUsuarios() {
		$sql = "SELECT * FROM tbl_usuario AS u 
		INNER JOIN tbl_pacien AS p ON u.pers_cedrif=p.pacien_cedrif
		INNER JOIN tbl_nivusuario AS n ON u.nivusuario_codigo=n.nivusuario_codigo
		WHERE u.usuario_status!='3'
		ORDER BY p.pacien_cedrif ASC";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function usuarioOdontologo(){
		// SELECCIONAR SOLO LOS ODONTOLOGOS
		$sql = "SELECT * from vw_usuarios where (nivusuario_codigo = 2 or nivusuario_codigo = 3)";
		$res = $this->con->prepare($sql);
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function datosOdontologo($ide){
		// SELECCIONAR SOLO LOS ODONTOLOGOS
		$sql = "SELECT * from vw_usuarios where (nivusuario_codigo = 2 or nivusuario_codigo = 3) and pers_cedrif = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function selectUsuariosEditCedula() {
		$sql = "SELECT * FROM tbl_pacien where pacien_cedrif like '%'";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function tiposDeUsuario() {
		// para el sistema del doctor davir rodriguez se oculta el usuario tipo doctor
		// ya que se creo el modulo de odontologos 
		$sql = "SELECT * FROM tbl_nivusuario";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function clinicaMedico($cedrif){
		$sql = "SELECT * from tbl_clinicmed where clinicmed_med = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function medicoClinica($clinica){
		$sql = "SELECT * from vw_clinicmed where clinicmed_clinic = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$clinica);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function listaodontoasist($usuario){
		$sql = "SELECT * from vw_listaodontoasist where asismed_asis = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$usuario);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function tiposDeUsuarioDelete() {
        $this->con->beginTransaction();

        $sql = "SELECT * FROM tbl_usuario WHERE nivusuario_codigo=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->nivel);
		$res->execute();
		$row = $res->fetchAll(PDO::FETCH_OBJ);
		
		if(count($row)==0){
			$sql = "DELETE FROM tbl_nivusuario WHERE nivusuario_codigo=?";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->nivel);
			$exe_1=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 

			$sql = "DELETE FROM tbl_permisos WHERE nivusuario_codigo=?";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->nivel);
			$exe_2=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
          
		        if($exe_1==true and $exe_2==true) {
					$this->con->commit();
					$rt = 1;
				} else {
					$this->con->rollBack();
					$rt = $exe_1.' '.$exe_2;
				}	
        }else{
        	$rt="No se puede eliminar el Nivel esta asignado a algun Usuario";
        }
		return $rt;
	}


	function tiposDeUsuarioide($ide) {
		$sql = "SELECT * FROM tbl_nivusuario WHERE nivusuario_codigo=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function usuarioInsert($imgFirma) {
		$cedula = $this->cedrif;
		$pass=md5($this->clave);
		$this->con->beginTransaction();
		$sql = "INSERT INTO tbl_pacien (pacien_cedrif,pacien_nomraz,pacien_nac) VALUES (?,?,?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedula);
		$res->bindParam(2,$this->nomraz);
		$res->bindParam(3,$this->nac);
		$exe_1=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 

		$sql = "INSERT INTO tbl_usuario VALUES (null,?,?,?,1,0,?,1,?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->tipo);
		$res->bindParam(2,$this->usuario);
		$res->bindParam(3,$pass);
		$res->bindParam(4,$cedula);
		$res->bindParam(5,$imgFirma);
    $exe_2=($res->execute()==1) ? 1 : print_r($res->errorInfo());

		$sql = "DELETE FROM tbl_espemed WHERE espemed_med=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedula);
		$res->execute();

		$sql = "DELETE FROM tbl_clinicmed WHERE clinicmed_med=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedula);
		$res->execute();

		if(isset($_POST['espec']) and count($_POST['espec'])>0) {			
			$sql = "INSERT INTO tbl_espemed (espemed_espe,espemed_med) VALUES (?,?) ";
			$res = $this->con->prepare($sql);
			foreach($_POST['espec'] as $r) {
				$res->bindParam(1,$r);
				$res->bindParam(2,$cedula);
				$e = ($res->execute()==1) ? 1 : $this->msj[] = print_r($res->errorInfo());
			}	
		} else {
			$e = 1;
		}

		if(isset($_POST['clinica']) and count($_POST['clinica'])>0) {			
			$sql = "INSERT INTO tbl_clinicmed (clinicmed_clinic,clinicmed_med) VALUES (?,?) ";
			$res = $this->con->prepare($sql);
			foreach($_POST['clinica'] as $r) {
				$res->bindParam(1,$r);
				$res->bindParam(2,$cedula);
				$re = ($res->execute()==1) ? 1 : $this->msj[] = print_r($res->errorInfo());
			}	
		} else {
			$re = 1;
		}
		
		if($exe_1==true and $exe_2==true and $e==1 and $re==1) {
			$this->con->commit();
			$rt = 1;
		} else {
			$this->con->rollBack();
			$rt = $exe_1.' '.$exe_2.' '.$e.' '.$re;
		}	
		return $rt;
	}

	function nivelInsert() {
		$sql = "INSERT INTO tbl_nivusuario (nivusuario_descripcion) VALUES (?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->des);
		$rt=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		return $rt;
	}

		function nivelUpdate() {
		$sql = "UPDATE tbl_nivusuario SET nivusuario_descripcion=? WHERE nivusuario_codigo=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->des);
		$res->bindParam(2,$this->ide);
		$rt=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		return $rt;
	}

	function usuarioSelectMed($cedrif) {
		$sql = "SELECT * FROM tbl_usuario AS u 
		INNER JOIN tbl_pacien AS p ON u.pers_cedrif=p.pacien_cedrif
		INNER JOIN tbl_nivusuario AS n ON u.nivusuario_codigo=n.nivusuario_codigo
		INNER JOIN tbl_espemed AS e ON u.pers_cedrif=e.espemed_med
		INNER JOIN tbl_especialidad AS es ON e.espemed_espe=es.espec_ide
		WHERE p.pacien_cedrif=?;";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function usuarioSelect($cedrif) {
		$sql = "SELECT * FROM tbl_usuario AS u 
		INNER JOIN tbl_pacien AS p ON u.pers_cedrif=p.pacien_cedrif
		INNER JOIN tbl_nivusuario AS n ON u.nivusuario_codigo=n.nivusuario_codigo
		WHERE p.pacien_cedrif=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function usuarioUpdate($imgFirma) {
		$sql = "UPDATE tbl_pacien SET pacien_nac=?, pacien_nomraz=? WHERE pacien_cedrif=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->nac);
		$res->bindParam(2,$this->nomraz);
		$res->bindParam(3,$this->cedrif);
		$exe_1=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		
	  if($exe_1==1){
			$sql = "UPDATE tbl_usuario SET nivusuario_codigo=?, usuario_login=?, usuario_imagen_firma=? WHERE pers_cedrif=?";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->tipo);
			$res->bindParam(2,$this->usuario);
			$res->bindParam(3,$imgFirma);
			$res->bindParam(4,$this->cedrif);
	    $exe_2=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
	  }

		$sql = "DELETE FROM tbl_espemed WHERE espemed_med=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->cedrif);
		$res->execute();

		$sql = "DELETE FROM tbl_clinicmed WHERE clinicmed_med=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->cedrif);
		$res->execute();

		if(isset($_POST['espec']) and count($_POST['espec'])>0) {			
			$sql = "INSERT INTO tbl_espemed (espemed_espe,espemed_med) VALUES (?,?) ";
			$res = $this->con->prepare($sql);
			foreach($_POST['espec'] as $r) {
				$res->bindParam(1,$r);
				$res->bindParam(2,$this->cedrif);
				$e = ($res->execute()==1) ? 1 : $this->msj[] = print_r($res->errorInfo());
			}	
		} else {
			$e = 1;
		}

		if(isset($_POST['clinica']) and count($_POST['clinica'])>0) {			
			$sql = "INSERT INTO tbl_clinicmed (clinicmed_clinic,clinicmed_med) VALUES (?,?) ";
			$res = $this->con->prepare($sql);
			foreach($_POST['clinica'] as $r) {
				$res->bindParam(1,$r);
				$res->bindParam(2,$this->cedrif);
				$re = ($res->execute()==1) ? 1 : $this->msj[] = print_r($res->errorInfo());
			}	
		} else {
			$re = 1;
		}
		
		if($exe_1==true and $exe_2==true and $e==1 and $re==1) {
			$rt = 1;
		} else {
			$rt = $exe_1.' '.$exe_2.' '.$e.' '.$re;
		}	

		return $rt;
	}

	function estadoUpdate() {
		$sql = "UPDATE tbl_usuario SET usuario_status=? WHERE pers_cedrif=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->estado);
		$res->bindParam(2,$this->cedrif);
		return $res->execute();
	}

	function permisoUpdate() {
		$sql = "SELECT * FROM tbl_permisos WHERE subm_ide=? AND nivusuario_codigo=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->subm);
		$res->bindParam(2,$this->nivel);
		$res->execute();
		if($res->rowCount()>0) {
			$sql = "UPDATE tbl_permisos SET perm_est=? WHERE subm_ide=? AND nivusuario_codigo=?";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->estado);
			$res->bindParam(2,$this->subm);
			$res->bindParam(3,$this->nivel);
			return ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		} else {
			$sql = "INSERT INTO tbl_permisos (subm_ide,nivusuario_codigo,perm_est) VALUES (?,?,?)";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->subm);
			$res->bindParam(2,$this->nivel);
			$res->bindParam(3,$this->estado);
			return ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		}
	}

	function permisoUpdatefich() {
		$sql = "SELECT * FROM tbl_permfich WHERE pefi_tius=? AND pefi_fich=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->nivel);
		$res->bindParam(2,$this->fich);
		$res->execute();
		if($res->rowCount()>0) {
			$sql = "UPDATE tbl_permfich SET pefi_estado=? WHERE pefi_tius=? AND pefi_fich=?";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->estado);
			$res->bindParam(2,$this->nivel);
			$res->bindParam(3,$this->fich);
			return ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		} else {
			$sql = "INSERT INTO tbl_permfich (pefi_tius,pefi_fich,pefi_estado) VALUES (?,?,?)";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->nivel);
			$res->bindParam(2,$this->fich);
			$res->bindParam(3,$this->estado);
			return ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		}
	}

	function getAll() {
		$sql = "SELECT * FROM tbl_pacien";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	public function empresa() {
			$sql = "SELECT * FROM tbl_empresa";
			$res = $this->con->prepare($sql);
			$res->execute();
			return $res->fetchAll(PDO::FETCH_OBJ);
		}

	public function usuarioChangePass() {
	         $sql = "UPDATE tbl_usuario SET usuario_clave=? WHERE pers_cedrif=?";
	         $res = $this->con->prepare($sql);
	         $pass=md5($this->clave);
			 $res->bindParam(1,$pass);
			 $res->bindParam(2,$this->cedrif);
	         $rt=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
			 return $rt;
		}

	public function updateSID($sid,$codigo_usr){
		     $sql2 = "UPDATE tbl_usuario SET usuario_sid=? WHERE usuario_codigo=?";
		             $res = $this->con->prepare($sql2);
					 $res->bindParam(1,$sid);
					 $res->bindParam(2,$codigo_usr);
			         $res->execute(); 
			         $rt=$sid;
	        return $rt;     
	    }	

	public function searchSID($codigo_usr){
	    $sql = "SELECT usuario_sid FROM tbl_usuario WHERE usuario_codigo=?";
			         $res = $this->con->prepare($sql);
			         $res->bindParam(1,$codigo_usr);
		             $res->execute();
		             
			return $res->fetchAll(PDO::FETCH_OBJ);
	    }

	public function updateUserV($visible,$codigo_usr){
		     $sql2 = "UPDATE tbl_usuario SET usuario_visible=? WHERE usuario_codigo=?";
		             $res = $this->con->prepare($sql2);
					 $res->bindParam(1,$visible);
					 $res->bindParam(2,$codigo_usr);
	        return $res->execute();
	    }	    

	function insertClinicOdonto(){
		$sql = "SELECT fn_asismed(null,?,?,?,1,?) as res";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->usuario_codigo);
		$res->bindParam(2,$this->odonto);
		$res->bindParam(3,$this->clinica);
		$res->bindParam(4,$_SESSION['ced']);
		$res->execute();
		$result = $res->fetchAll(PDO::FETCH_OBJ);
		return $result[0]->res;
	}

	function deleteClinicOdonto(){
		$sql = "SELECT fn_asismed(?,0,0,0,3,?) as res";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$res->bindParam(2,$_SESSION['ced']);
		$res->execute();
		$result = $res->fetchAll(PDO::FETCH_OBJ);
		return $result[0]->res;
	}

	public function validarCorreo()
	{
		$sql = "SELECT pac.pacien_email AS email, usr.usuario_login AS user FROM tbl_usuario AS usr 
		INNER JOIN tbl_pacien AS pac ON usr.pers_cedrif=pac.pacien_cedrif
		WHERE 
			pac.pacien_email=?
		AND usr.usuario_status=1";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->email);
		return ($res->execute()) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}
	public function restablecerClave($pass, $ssid)
	{
		$sql = "UPDATE tbl_usuario AS usr
			INNER JOIN
				tbl_pacien AS pac ON usr.pers_cedrif = pac.pacien_cedrif 
			SET usr.usuario_clave = ?,
			usr.usuario_sid = ?,
			usr.usuario_status = 0
			WHERE
				pac.pacien_email = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$pass);
		$res->bindParam(2,$ssid);
		$res->bindParam(3,$this->email);
		return $res->execute();
	}
	public function validateSsid()
	{
		$sql = "SELECT usuario_login AS user, usuario_clave AS pass FROM tbl_usuario WHERE usuario_sid=? AND usuario_status = 0";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ssid);
		return ($res->execute()) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}
	public function cambiarClave($ssid)
	{
		$pass=md5($this->new_password);
		$sql = "UPDATE tbl_usuario
			SET usuario_clave = ?,
			usuario_sid = null,
			usuario_status = 1
			WHERE
				usuario_sid = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$pass);
		$res->bindParam(2,$ssid);
		return $res->execute();
	}
	public function buscarPaciente($ced)
	{
		$sql = "SELECT
				pacien_nomraz,
				pacien_movil1tlf,
				pacien_nac,
				pacien_sexo,
				pacien_casatlf,
				pacien_email,
				pacien_domicasa,
				pacien_fechnac
			FROM
				tbl_pacien where pacien_cedrif = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ced);
		return ($res->execute()) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}
	public function datosEspecialista($ced)
	{
		$sql = "SELECT
				pct.pacien_nomraz,
				esp.espec_descrip 
			FROM
				tbl_pacien AS pct
				LEFT JOIN tbl_espemed AS epm ON pct.pacien_cedrif = epm.espemed_med
				LEFT JOIN tbl_especialidad AS esp ON epm.espemed_espe = esp.espec_ide
			WHERE
				pct.pacien_cedrif = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ced);
		return ($res->execute()) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}
	public function datosEspecialistaInterno($ced)
	{
		$sql = "SELECT
				pct.pacien_nomraz,
				esp.espec_descrip,
				usr.usuario_imagen_firma
			FROM
				tbl_pacien AS pct
				INNER JOIN tbl_usuario AS usr ON pct.pacien_cedrif = usr.pers_cedrif
				LEFT JOIN tbl_espemed AS epm ON pct.pacien_cedrif = epm.espemed_med
				LEFT JOIN tbl_especialidad AS esp ON epm.espemed_espe = esp.espec_ide
			WHERE
				pct.pacien_cedrif = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ced);
		return ($res->execute()) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}
	public function odontologosPorEspecialidad($especialidadID)
	{
		$sql = "SELECT
			usr.pers_cedrif,
			IFNULL( pct.pacien_nomraz, usr.usuario_login ) AS especialista 
		FROM
			tbl_usuario AS usr
			LEFT JOIN tbl_pacien AS pct ON usr.pers_cedrif = pct.pacien_cedrif
			INNER JOIN tbl_espemed AS epm ON usr.pers_cedrif = epm.espemed_med AND epm.espemed_espe = $especialidadID
		WHERE
			usr.usuario_status = 1
		ORDER BY especialista ASC";
		
		$res = $this->con->prepare($sql);
		return ($res->execute()) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}
}