<?php  
	require '../../../cfg/base.php';  
	$paciente_rows = $mturno->pase_turno(); 
?>

<?php if (count($paciente_rows) > 0): ?>
	<table class="table table-bordered table-striped table-hover">
		<thead>
			<tr>
				<th>Nro Identificación</th>
				<th>Apellidos y Nombres</th>
				<th>Tipo de Cita</th>
				<th>Unidad</th>
				<th>Estado</th>
			</tr>
		</thead>
		<tbody>
			<?php foreach($paciente_rows as $ps) { ?>
				<?php 
				switch ($ps->citas_eti) {
			    case 'LABEL-INFO':
			        $tipo_cita= "ORTODONCIA";
			        break;
			    case 'LABEL-DANGER':
			        $tipo_cita= "PERIODONCIA";
			        break;
			    case 'LABEL-SUCCESS':
			        $tipo_cita= "CIRUGIA";
			        break;    
			    case 'LABEL-GREY':
			        $tipo_cita= "ENDODONCIA";
			        break;            
			    case 'LABEL-YELLOW':
			        $tipo_cita= "GENERAL";
			        break;        
			    case 'LABEL-PURPLE':
			        $tipo_cita= "PROTESIS";
			        break;                      
				}
				?>
				<tr>
					<td><?php echo $ps->pacien_cedrif; ?></td>
					<td><?php echo $ps->pacien_nomraz; ?></td>
					<td>
						<span class='<?php echo strtolower($ps->citas_eti); ?>' style="color: #FFFFFF"> 
							<?php echo $tipo_cita; ?>
						</span>
					</td>
					<td align="center"><?php echo $ps->citas_silla; ?></td>
					<td >
						<div class="visible-md visible-lg hidden-sm hidden-xs action-buttons">
							<?php if ($ps->citas_atendido==2) { ?>
								<span class='<?php echo strtolower('LABEL-SUCCESS'); ?>' style="color: #FFFFFF">
									&nbsp; ATENDIDO &nbsp;
								</span>
								<i class="green icon-flag bigger-130"></i>
							<?php } else if ($ps->citas_atendido==1){ ?>
								<span class='<?php echo strtolower('LABEL-YELLOW'); ?>' style="color: #FFFFFF">
									&nbsp; EN PROCESO &nbsp;
								</span>
								<a class="green" href="#" title="Atendido" onclick="asistiocita(<?php echo $ps->citas_ide; ?>)">
									<i class="icon-check bigger-130"></i>
								</a>
							<?php } else { ?>
								<span class='<?php echo strtolower('LABEL-DANGER'); ?>' style="color: #FFFFFF">
									&nbsp; EN ESPERA &nbsp;
								</span>
								<a class="orange" href="#" title="Atender" onclick="atendercita(<?php echo $ps->citas_ide; ?>)">
									<i class="icon-check bigger-130"></i>
								</a>
							<?php } ?>
						</div>
					</td>
				</tr>
			<?php } ?>
		</tbody>
	</table>
<?php else: ?>
	<div class="alert alert-info">No hay citas programadas</div>
<?php endif ?>