<?php
require_once '../../../cfg/base.php';
$dp = $mhistoria->datosPersonalesSelect($_GET['cedrif']);
$idealTreatment = $mreportes->tratIdeal($_GET['cedrif']);
$realTreatment = $mreportes->tratReal($_GET['cedrif']);
$pacienCedrif = '';
?>

<div class="table-header" style="margin-bottom: 10px;">
    <h3><strong>Presupuesto</strong></h3>
    <div style="margin-bottom: 5px;">
        Fecha: <?php echo date("d-m-Y"); ?>
    </div>
    <?php if (!empty($dp)) {
        $pacienCedrif = $dp[0]->pacien_cedrif;
    ?>
        <table class="table table-hover table-bordered tabla7" style="margin-bottom: 10px;">
            <tr>
                <th>Nombre</th>
                <td><?php echo $dp[0]->pacien_nomraz; ?></td>
                <th>Nº Identificacion</th>
                <td><?php echo $dp[0]->pacien_cedrif; ?></td>
            </tr>
            <tr>
                <th>Direccion</th>
                <td><?php echo $dp[0]->pacien_domicasa; ?></td>
                <th>Telefono</th>
                <td><?php echo $dp[0]->pacien_movil1tlf; ?></td>
            </tr>
        </table>
    <?php } ?>
</div>

<?php
if (!empty($idealTreatment) || !empty($realTreatment)) {
    if (!empty($idealTreatment)) { ?>
        <div style="margin-bottom: 5px;">
            <h5><strong>Tratamiento Ideal</strong></h5>
        </div>
        <table class="table table-hover table-bordered tabla7" style="margin-bottom: 5px;">
            <thead>
                <tr>
                    <th>Procedimiento</th>
                    <th>Pieza</th>
                    <th>Cantidad</th>
                    <th>Precio Unit.</th>
                    <th>Total COP</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($idealTreatment as $ideal) {
                    $cant_proce='1';
                    $prec_unit=$ideal->precio;   
                    $prec_total=$ideal->precio;
    
                    if ($ideal->proced_ide == 75) {
                        $cant_proce='24';
                        $prec_unit=$ideal->precio/24;   
                        $prec_total=$ideal->precio;
                    }
                ?>
                    <tr>
                        <td><?php echo $ideal->descrip_procedi; ?></td>
                        <td><?php echo $ideal->diente.'-'.$ideal->parte_diente; ?></td>
                        <td><?php echo $cant_proce; ?></td>
                        <td><?php echo number_format($prec_unit, 2, ',', '.'); ?></td>
                        <td><?php echo number_format($prec_total, 2, ',', '.'); ?></td>
                    </tr>
                <?php } ?>
                <tr>
                    <td colspan="4" align="right"><strong>Total General</strong></td>
                    <td><?php echo number_format($mreportes->totalTratamientoIdeal($_GET['cedrif']), 2, ',', '.'); ?></td>
                </tr>
            </tbody>
        </table>
    <?php }
    
    if (!empty($realTreatment)) { ?>
        <div style="margin-bottom: 5px;">
            <h5><strong>Tratamiento Real</strong></h5>
        </div>
        <table class="table table-hover table-bordered tabla7" style="margin-bottom: 5px;">
            <thead>
                <tr>
                    <th>Procedimiento</th>
                    <th>Pieza</th>
                    <th>Cantidad</th>
                    <th>Precio Unit.</th>
                    <th>Total COP</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($realTreatment as $real) {
                    $cant_proce='1';
                    $prec_unit=$real->precio;   
                    $prec_total=$real->precio;
    
                    if ($real->proced_ide == 75) {
                        $cant_proce='24';
                        $prec_unit=$real->precio/24;   
                        $prec_total=$real->precio;
                    }
                ?>
                    <tr>
                        <td><?php echo $real->descrip_procedi; ?></td>
                        <td><?php echo $real->diente.'-'.$real->parte_diente; ?></td>
                        <td><?php echo $cant_proce; ?></td>
                        <td><?php echo number_format($prec_unit, 2, ',', '.'); ?></td>
                        <td><?php echo number_format($prec_total, 2, ',', '.'); ?></td>
                    </tr>
                <?php } ?>
                <tr>
                    <td colspan="4" align="right"><strong>Total General</strong></td>
                    <td><?php echo number_format($mreportes->totalTratamientoReal($_GET['cedrif']), 2, ',', '.'); ?></td>
                </tr>
            </tbody>
        </table>
    <?php } ?>
    <div style="margin-top: 20px; margin-bottom: 5px;">
        <strong>Nota:</strong> El presupuesto esta sujeto a cambios sin previo aviso, por incremento de costos en los trabajos del laboratorio y materiales.
    </div>
<?php } else { ?>
    <div class="alert alert-danger">
        <strong>No se encontraron registros</strong>
    </div>
<?php }