<?php
require_once '../../../cfg/base.php';
$ced = $_GET['cedrif'];
$dp = $mhistoria->datosPersonalesSelect($ced);
$antecedentesPersonales = $mortodon->getAnamnesisId($ced);
$historiaDental = $mhistoria->datosPersonalesSelect($ced);
$motivosConsulta = $mortodon->getMotivoId($ced);
$row = $modonto->odontoSelectCedrif($ced);
$edad = '';

if (!empty($dp[0]->pacien_fechnac)) {
    $nacimiento = new DateTime($dp[0]->pacien_fechnac);
    $ahora = new DateTime(date("Y-m-d"));
    $diferencia = $ahora->diff($nacimiento);
    $edad = $diferencia->format("%y");
}
?>

<div class="table-header" style="margin-bottom: 10px;">
    <h3 style="text-align: center">
        <strong>HISTORIA MEDICA</strong>
    </h3>
    <?php if (!empty($dp)) { ?>
        <table class="table table-hover" id="contenido" style="margin-bottom: 10px; font-size: 12px; width: 100% !important">
            <tr>
                <td colspan="2" align="right"><strong>Fecha</strong> <?php echo date("d-m-Y"); ?></td>
            </tr>
            <tr>
                <td align="left"><strong>Nombre</strong> <?php echo $dp[0]->pacien_nomraz; ?></td>
                <td align="right"><strong>Nº Identificación</strong> <?php echo $dp[0]->pacien_cedrif; ?></td>
            </tr>
            <tr>
                <td align="left"><strong>Fecha de Nacimiento</strong> <?php echo $dp[0]->pacien_fechnac; ?></td>
                <td align="right"><strong>Edad</strong> <?php echo $edad; ?></td>
            </tr>
            <tr>
                <td align="left"><strong>Ocupación</strong> <?php echo $dp[0]->pacien_ocupa; ?></td>
                <td align="right"><strong>Teléfono</strong> <?php echo $dp[0]->pacien_movil1tlf; ?></td>
            </tr>
            <tr>
                <td align="left"><strong>Sexo</strong> <?php echo $dp[0]->pacien_sexo; ?></td>
            </tr>
        </table>
    <?php } ?>
</div>

<div style="margin-bottom: 10px;">
    <h3 style="text-align: justify">
        <strong>Motivo de consulta</strong>
    </h3>
    <?php foreach ($motivosConsulta as $consulta) { ?>
        <div style="text-align: justify; font-size: 12px; margin-bottom: 5px;">
            <strong>Fecha:</strong> <?php echo date("d-m-Y",strtotime($consulta->motpaci_fecha)).' '.$consulta->motpaci_hora; ?>, 
            <strong>Motivo:</strong> <?php echo $consulta->motivo_descrip; ?>,
            <strong>Observación:</strong> <?php echo $consulta->motpaci_obser ?: 'No indica'; ?>
        </div>
    <?php } ?>
</div>

<div style="margin-bottom: 10px;">
    <h3 style="text-align: justify">
        <strong>Antecedentes personales</strong>
    </h3>
    <?php if (!empty($antecedentesPersonales)) {
        foreach ($antecedentesPersonales as $antecedentesPersonal) {
            $sta= ($antecedentesPersonal->anam_status==1) ? 'Si': 'No';
        ?>
            <div style="text-align: justify; margin-bottom: 5px; font-size: 12px;">
                <strong><?php echo $antecedentesPersonal->anamnesis_descrip; ?>: </strong>
                <?php echo $sta.'. '.$antecedentesPersonal->anam_obser; ?>
            </div>
        <?php }
    } else {
        //
    } ?>
</div>

<div style="margin-bottom: 10px;">
    <h3 style="text-align: justify">
        <strong>Historia Dental</strong>
    </h3>
    <?php if (!empty($historiaDental)) { ?>
        <div style="text-align: justify; margin-bottom: 5px; font-size: 12px;">
            <strong>Ultima visita al odontólogo: </strong>
            <?php echo $historiaDental[0]->pacien_ult_visit; ?>
        </div>
        <div style="text-align: justify; margin-bottom: 5px; font-size: 12px;">
            <strong>Frecuencia de cepillado: </strong>
            <?php echo $historiaDental[0]->pacien_frec_cepill; ?>
        </div>
        <div style="text-align: justify; margin-bottom: 5px; font-size: 12px;">
            <strong>Seda dental, enjuague bucal, palillos: </strong>
            <?php echo $historiaDental[0]->pacien_sedal_otro; ?>
        </div>
        <div style="text-align: justify; margin-bottom: 5px; font-size: 12px;">
            <strong>Cambio de Cepillo: </strong>
            <?php echo $historiaDental[0]->pacien_camb_cepill; ?>
        </div>
    <?php } ?>
</div>

<h3 style="text-align: center">
    <strong>Diagnósticos</strong>
</h3>
<?php if (!empty($row)) { ?>
    <div style="text-align: justify; margin-bottom: 15px;">
        <?php foreach ($row as $diagnostic) {
            $diagnosticTitle = $diagnostic->diagno_descrip;
            $fecha = $diagnostic->diagcons_fecha.' '.$diagnostic->diagcons_hora;
            $group = $modonto->selectAgrupados($diagnostic->diagcons_ide); 
            foreach($group as $g) {
                $diagnosticTitle.= ', '.$codonto->piezas($g->diagcons_numero,$g->diagcons_fin,$g->diagcons_clase);
            }
            $procedures = $modonto->tratamientosPorDiagnostico($diagnostic->diagcons_ide);
        ?>
            <div style="font-size: 12px; margin-bottom: 7px;">
                <p>
                    <span style="font-size: 14px;"><strong>Diagnostico:</strong></span> <?php echo ucfirst(strtolower($diagnosticTitle)); ?>
                </p>
                Realizado por <strong><?php echo $diagnostic->especialista;?></strong> en fecha <strong><?php echo $fecha; ?></strong>
            </div>
            <div style="margin-bottom: 10px; margin-left: 7px;">
                <strong>Procedimientos</strong>
                <?php if (!empty($procedures)) {
                    foreach ($procedures as $proc) {
                        $fechaProc = ($proc->trat_fecha) ? $proc->trat_fecha.' '.$proc->trat_hora.' - ' : '';
                        $evolutions = $modonto->listaEvoluciones($proc->trat_ide);
                    ?>
                    <div style="font-size: 12px; margin-bottom: 5px; margin-left: 10px;">
                        <strong>Procedimiento:</strong> <?php echo ucfirst(strtolower($proc->proced_des)); ?>
                        realizado por <strong><?php echo $proc->especialista; ?></strong> en fecha <strong><?php echo $fechaProc; ?></strong>
                    </div>
                    <div style="margin-bottom: 10px; margin-left: 15px;">
                        <strong>Evoluciones</strong>
                        <?php if (!empty($evolutions)) {
                            foreach ($evolutions as $evolution) {?>
                                <div style="font-size: 12px; margin-bottom: 5px; margin-left: 18px;">
                                    <strong>Fecha:</strong> <?php echo date("d-m-Y",strtotime($evolution->evol_fec)).' '.(($evolution->evol_hora !== '00:00:00') ? $evolution->evol_hora : ''); ?>, 
                                    <strong>Descripción:</strong> <?php echo $evolution->evol_des; ?>
                                </div>
                            <?php }
                        } else { ?>
                            <div style="font-size: 12px; margin-left: 18px;">
                                No hay evoluciones
                            </div>
                        <?php } ?>
                    </div>
                    <?php }
                } else { ?>
                    <div style="font-size: 12px; margin-left: 10px;">
                        No hay procedimientos
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </div>
<?php } else { ?>
    <div class="alert alert-danger">
        <strong>No se han realizado procedimientos</strong>
    </div>
<?php }