<?php
require_once '../../../cfg/base.php';
$paymentPaid = $mreportes->getPaymentPaidDetail(true);
$total = [];
$totalDiscount = [];
?>

<div class="table-header" style="margin-bottom: 10px;">Pagos Facturados</div>

<?php if (!empty($paymentPaid)) {
    foreach ($paymentPaid as $key => $payments) {
        $amount = array_sum(array_column($payments, 'monto'));
        $discount = array_sum(array_column($payments, 'descuento'));
    ?>
        <div style="margin-bottom: 5px;">
            <h5>Pago con <strong><?php echo $key ?></strong></h5>
        </div>

        <table class="table table-hover table-bordered tabla7">
            <thead>
                <tr>
                    <th>Tipo de Pago</th>
                    <th>Fecha de la Factura</th>
                    <th>Fecha del Pago</th>
                    <th>Procedimiento</th>
                    <th>Referencia</th>
                    <th>Punto de Venta</th>
                    <th>Caja</th>
                    <th>Taza de Cambio</th>
                    <th>Monto</th>
                    <th>Descuento</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($payments as $payment) {
                    if (!empty($payment['bancos'])) { ?>
                        <tr>
                            <td colspan="5">
                                <?php echo $payment['tipo_pago']; ?>
                            </td>
                        </tr>
                        <?php foreach ($payment['bancos'] as $arrBanks) {
                            foreach ($arrBanks as $banks) { ?>
                                <tr>
                                    <td style="text-indent: 20px;"><?php echo $banks['banco']; ?></td>
                                    <td><?php echo $fun->fecha($banks['fecha_factura']); ?></td>
                                    <td><?php echo $banks['fecha_pago']; ?></td>
                                    <td><?php echo $banks['procedimiento']; ?></td>
                                    <td><?php echo $banks['referencia']; ?></td>
                                    <td><?php echo $banks['punto_venta']; ?></td>
                                    <td><?php echo $banks['caja']; ?></td>
                                    <td><?php echo number_format($banks['tasa_conversion'],3,',','.'); ?></td>
                                    <td><?php echo number_format($banks['monto'], 2, ',', '.'); ?></td>
                                    <td><?php echo number_format($banks['descuento'], 2, ',', '.'); ?></td>
                                </tr>
                            <?php }
                        } ?>
                    <?php } else {
                        foreach ($payment as $value) {
                            $amount += $value['monto'];
                            $discount += $value['descuento'];
                        ?>
                            <tr>
                                <td><?php echo $value['tipo_pago']; ?></td>
                                <td><?php echo $fun->fecha($value['fecha_factura']); ?></td>
                                <td><?php echo $value['fecha_pago']; ?></td>
                                <td><?php echo $value['procedimiento']; ?></td>
                                <td><?php echo $value['referencia']; ?></td>
                                <td><?php echo $value['punto_venta']; ?></td>
                                <td><?php echo $value['caja']; ?></td>
                                <td><?php echo number_format($value['tasa_conversion'],3,',','.'); ?></td>
                                <td><?php echo number_format($value['monto'], 2, ',', '.'); ?></td>
                                <td><?php echo number_format($value['descuento'], 2, ',', '.'); ?></td>
                            </tr>
                        <?php }
                    }
                } ?>
                <tr>
                    <td colspan="8" style="text-align: right;">
                        <strong>Total</strong>
                    </td>
                    <td><?php echo number_format($amount, 2, ',', '.'); ?></td>
                    <td><?php echo number_format($discount, 2, ',', '.'); ?></td>
                </tr>
            </tbody>
            </table>
<?php
        $total[] = $amount; 
        $totalDiscount[] = $discount;
    } ?>
    <div style="text-align: center; margin-bottom: 15px;">
        <h4>Total General: <?php echo number_format((array_sum($total) + array_sum($totalDiscount)), 2, ',', '.'); ?>
    </h4></div>
<?php } else { ?>
    <div class="alert alert-danger" style="margin-bottom: 15px;">
        <strong>No se encontraron registros</strong>
    </div>
<?php } ?>