<?php
require_once '../../../cfg/base.php';
$invoicedPayments = $mreportes->getPaymentPaid(true);
$total = [];
$totalDiscount = [];
?>

<div class="table-header" style="margin-bottom: 10px;">Pagos Facturados</div>

<?php if (!empty($invoicedPayments)) {
    foreach ($invoicedPayments as $key => $invoicedPayment) { ?>
        <div style="margin-bottom: 5px;">
            <h5>Pago con <strong><?php echo $key ?></strong></h5>
        </div>

        <table class="table table-hover table-bordered tabla7">
            <thead>
                <tr>
                    <th>Tipo de Pago</th>
                    <th>Fecha</th>
                    <th>Caja</th>
                    <th>Taza de Cambio</th>
                    <th>Monto</th>
                    <th>Descuento</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $amounts= [];
                $discounts= [];
                foreach ($invoicedPayment as $key => $billed) {
                    $amount = array_sum(array_column($billed, 'monto'));
                    $discount = array_sum(array_column($billed, 'descuento'));
                    $amounts[] = $amount;
                    $discounts[] = $discount;

                    $total[] = $amount; 
                    $totalDiscount[] = $discount;
                ?>
                    <tr>
                        <td colspan="6">
                            <strong><?php echo $key; ?></strong>
                        </td>
                    </tr>
                    <?php foreach ($billed as $payment) { ?>
                        <tr>
                            <td style="text-indent: 20px;"><?php echo $payment['bancos'] ?: ''; ?></td>
                            <td><?php echo $fun->fecha($payment['fecha_pago']); ?></td>
                            <td><?php echo $payment['caja']; ?></td>
                            <td><?php echo number_format($payment['tasa_conversion'],3,',','.'); ?></td>
                            <td><?php echo number_format($payment['monto'], 2, ',', '.'); ?></td>
                            <td><?php echo number_format($payment['descuento'], 2, ',', '.'); ?></td>
                        </tr>
                    <?php }
                } ?>
                <tr>
                    <td colspan="4" style="text-align: right;">
                        <strong>Total</strong>
                    </td>
                    <td><?php echo number_format(array_sum($amounts), 2, ',', '.'); ?></td>
                    <td><?php echo number_format(array_sum($discounts), 2, ',', '.'); ?></td>
                </tr>
            </tbody>
            </table>
<?php } ?>
    <div style="text-align: center; margin-bottom: 15px;">
        <h4>Total General: <?php echo number_format((array_sum($total) + array_sum($totalDiscount)), 2, ',', '.'); ?>
    </h4></div>
<?php } else { ?>
    <div class="alert alert-danger" style="margin-bottom: 15px;">
        <strong>No se encontraron registros</strong>
    </div>
<?php } ?>