<?php 
	$medicos = $modonto->getAllOdonto();
?>
<div id="breadcrumbs" class="breadcrumbs">
	<ul class="breadcrumb">
		<li><i class="icon-home home-icon"></i> <a href="#">Inicio</a></li>
		<li class="active"><i class="fa fa-file-text-o"></i> <a href="#">Reportes</a></li>
		<li class="active">N&oacute;mina Odont&oacute;logos</li>
	</ul>
</div>
<div class="space-20"></div>
<div class="clearfix"></div>

<div class="msj"></div>
<div class="col-sm-12">
	<form class="nomina-odonto">
		 <div class="form-group col-sm-3">
			<label for="" class="control-label col-sm-12">
				<small>Fecha de Inicio:</small>
			</label>
			<div class="col-sm-12">
				<div class="input-group">
					<input type="text" name="f_ini" id="f_ini" class="fecha form-control" data-date-format="yyyy-mm-dd">
					<span class="input-group-addon">
						<i class="icon-calendar bigger-110"></i>
					</span>
				</div>
			</div>
		</div>
		<div class="form-group col-sm-3">
			<label for="" class="control-label col-sm-12">
				<small>Fecha de Fin:</small>
			</label>
			<div class="col-sm-12">
				<div class="input-group">
					<input type="text" name="f_fin" id="f_fin" class="fecha form-control" data-date-format="yyyy-mm-dd">
					<span class="input-group-addon">
						<i class="icon-calendar bigger-110"></i>
					</span>
				</div>
			</div>
		</div>
		<div class="form-group col-sm-3">
			<label for="" class="control-label col-sm-12">
				<small>Odont&oacute;logo:</small>
			</label>
			<div class="col-sm-12">
				<select name="odonto" id="odonto" class="col-sm-12 chosen">
					<option value=""></option>
					<option value="%">TODOS</option>
					<?php if(count($medicos) > 0) { ?>
						<?php foreach($medicos as $p) { ?>
							<option value="<?php echo $p->pacien_cedrif ?>"><?php echo $p->pacien_nomraz?></option>
						<?php } ?>
					<?php } ?>
				</select>
			</div>
		</div>

		<div class="form-group col-sm-3">
			<label for="" class="control-label col-sm-12">
				<small>Buscar:</small>
			</label>
			<div class="col-sm-12">
				<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
					<button class="btn btn-primary" title="Buscar"><i class="fa fa-search"></i></button>
			    </div>		
		    </div>
		</div>
		
		<div class="clearfix"></div>
		
		<div class="form-group col-sm-2">
			<label for="" class="control-label col-sm-12"><small>% Cl&iacute;nica:</small>
				<input name="porc_clin" id="porc_clin" value="0" class="ace ace-checkbox-2" type="checkbox" onclick="porcClin()">
				<span class="lbl"></span>
			</label>	
		</div>
		<div class="form-group col-sm-2">
			<label for="" class="control-label col-sm-12"><small>% Odontol&oacute;go:</small>
				<input name="porc_odon" id="porc_odon" value="0" class="ace ace-checkbox-2" type="checkbox" onclick="porcOdonto()">
				<span class="lbl"></span>
			</label>	
		</div>
	</form>
</div>
<div class="clearfix"></div>
<div class="space-10"></div>
<div class="nom-list"></div>

<script type="text/javascript">
	function porcOdonto(){
        if ($("input[name='porc_odon']").is(':checked')) {
			$('#porc_odon').val(1);
	  		// alert($('#porc_odon').val());
		}else{
			$('#porc_odon').val(0);
			// alert($('#porc_odon').val());
		}
	};

	function porcClin(){
        if ($("input[name='porc_clin']").is(':checked')) {
			$('#porc_clin').val(1);
	  		// alert($('#porc_clin').val());
		}else{
			$('#porc_clin').val(0);
			// alert($('#porc_clin').val());
		}
	};

	$(function(){
		$('#odonto').chosen({width: "inherit",no_results_text:'No hay resultados'});

		$( ".fecha" ).datepicker({
			autoclose:true,endDate:'0d'
		     }).next().on(ace.click_event, function(){
			  $(this).prev().focus();
		});

		var formulario = '.nomina-odonto';
		$(formulario).validate({
			errorElement: 'div',
			errorClass: 'help-block',
			focusInvalid: true,
			rules: {
				f_ini : {
					required: true,
					date: true
				},
				f_fin : {
					required: true,
					date: true
				},
			},

			messages: {
				f_ini : {
					required: 'Obligatorio',
					date: 'Fecha no válida'
				},
				f_fin : {
					required: 'Obligatorio',
					date: 'Fecha no válida'
				},
			},

			invalidHandler: function (event, validator) { //display error alert on form submit   
				$('.alert-danger', $(formulario)).show();
			},

			highlight: function (e) {
				$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
			},

			success: function (e) {
				$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
				$(e).remove();
			},

			submitHandler: function (form) {
	        	var f_inip= $("#f_ini").val();
				var f_finp= $("#f_fin").val();
				var odonto= $("#odonto").val();
				var porc_odon= $("#porc_odon").val();
				var porc_clin= $("#porc_clin").val();

				if(f_inip > f_finp){
					alerta('.msj','danger',"La fecha de Fin no puede ser menor a la de Inicio")
				}else if(odonto == ''){
					alerta('.msj','danger',"Seleccione un odontólogo");
				}else if(porc_odon == 0 && porc_clin == 0){
					alerta('.msj','danger',"Debe Seleccionar un Porcentaje a Buscar");
				}else{
					cerrarAlerta('.msj');
					load('app/reportes/vistas/nomina.lista.php','f_ini='+f_inip+'&f_fin='+f_finp+'&odonto='+odonto+'&porc_odon='+porc_odon+'&porc_clin='+porc_clin,'.nom-list');
				}
				
			},
			invalidHandler: function (form) {
			}
		});
	})
</script>