<?php 
class mReportes {

	protected $dbh,$con,$msj;

	function __clone() {

	} #clone

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_REQUEST)) {
			foreach($_REQUEST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	} #construct

	function tratIdeal($cedrif) {
		$sql = "SELECT a.trat_ide, a.diagcons_ide, a.proced_ide, a.proced_prec as precio, a.trat_est as estado,
                b.diagcons_paciente,b.diagcons_numero as diente, 
                right(b.diagcons_clase,1) as parte_diente,c.proced_des as descrip_procedi
                FROM tbl_tratamiento as a inner join tbl_diagcons as b ON a.diagcons_ide=b.diagcons_ide
                inner join tbl_proced as c ON  a.proced_ide=c.proced_ide where b.diagcons_paciente=? and a.trat_est=0 and a.trat_status=0";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function tratReal($cedrif) {
		$sql = "SELECT a.trat_ide, a.diagcons_ide, a.proced_ide, a.proced_prec as precio, a.trat_est as estado,
                b.diagcons_paciente,b.diagcons_numero as diente, 
                right(b.diagcons_clase,1) as parte_diente,c.proced_des as descrip_procedi
                FROM tbl_tratamiento as a inner join tbl_diagcons as b ON a.diagcons_ide=b.diagcons_ide
                inner join tbl_proced as c ON  a.proced_ide=c.proced_ide  where b.diagcons_paciente=? and a.trat_est=1 and a.trat_status=0";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);	
	}

	function totalTratamientoIdeal($cedrif) {
$sql = "SELECT  sum(a.proced_prec) as total,b.diagcons_paciente
        FROM tbl_tratamiento as a inner join tbl_diagcons as b ON a.diagcons_ide=b.diagcons_ide
        where b.diagcons_paciente=? and a.trat_est=0  and a.trat_status=0
        group by b.diagcons_paciente";		
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		$total = $res->fetchAll(PDO::FETCH_OBJ);
		   if (empty($total[0]->total)){
                 $rs=0;  
               }else{
               $rs=$total[0]->total;
		   }

		return $rs;
	}

	function totalTratamientoReal($cedrif) {
$sql = "SELECT  sum(a.proced_prec) as total,b.diagcons_paciente
        FROM tbl_tratamiento as a inner join tbl_diagcons as b ON a.diagcons_ide=b.diagcons_ide
        where b.diagcons_paciente=? and a.trat_est=1 and a.trat_status=0
        group by b.diagcons_paciente";		
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		$total = $res->fetchAll(PDO::FETCH_OBJ);
		if (empty($total[0]->total)){
                 $rs=0;  
               }else{
               $rs=$total[0]->total;
		   }

		return $rs;
	}

	function traerCliente($consulta) {
		$sql = "SELECT * FROM selectclientecedula WHERE pers_cedrif=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$consulta);
		return ($res->execute()==1) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function tratamientoRealfact($consulta,$factura) {
		$sql = "SELECT trat_ide,fact_ide, SUM(pago_mon) as precio, proced_des
		FROM selecttratarealfactproce WHERE diagcons_paciente=?
		and fact_ide=?
		group by trat_ide,fact_ide,proced_des";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$consulta);
		$res->bindParam(2,$factura);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function totalfact($consulta2) {
		$sql = "SELECT * from tbl_factura WHERE fact_ide=?and fact_anulada=0;";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$consulta2);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function detall_pagos($consulta,$factura) {
		$sql = "SELECT diagcons_paciente,fact_ide,formpagos_nombre,sum(pago_mon) as pago_mon 
		from selectformpagos WHERE diagcons_paciente=?
		and fact_ide=?
		group by diagcons_paciente,fact_ide,formpagos_nombre;";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$consulta);
		$res->bindParam(2,$factura);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function dirFiscal($paciente,$ind) {
			$nom = $paciente[0]->pacien_nomraz;
			$ced = $paciente[0]->pacien_nac.'-'.$paciente[0]->pacien_cedrif;
			$dir = $paciente[0]->pacien_domicasa;
			$tel = $paciente[0]->pacien_movil1tlf;
		$rt = array('nom'=>$nom,'ced'=>$ced,'dir'=>$dir,'tel'=>$tel);
		return $rt[$ind];
	}

	function buscarCuadrerepor($f_inic,$f_fin,$caja) {
		$valcaja=($caja=='T') ? '%' : $caja;
		$sql="SELECT
				slc.pacien_nomraz,
				slc.fact_ide,
				slc.fact_anulada,
				slc.formpagos_nombre,
				slc.bancos_nombre,
				sum( slc.pago_mon ) AS total,
				slc.pago_hor,
				slc.pago_caja,
				tpg.pago_moneda,
				tpg.moneda_base_id,
				tpg.tasa_conversion 
			FROM
				selectcuadrecaja AS slc
				INNER JOIN tbl_pagos AS tpg ON slc.pago_ide = tpg.pago_ide 
			WHERE
				date( slc.pago_hor ) BETWEEN ? AND ? 
				AND slc.pago_caja LIKE ? 
				AND slc.fact_ide IS NOT NULL 
			GROUP BY
				slc.fact_ide,
				slc.pacien_nomraz,
				slc.fact_anulada,
				slc.formpagos_nombre,
				slc.bancos_nombre,
				slc.pago_hor,
				slc.pago_caja,
				tpg.pago_moneda 
			ORDER BY
				slc.fact_ide,
				slc.pago_caja,
				slc.pacien_nomraz ASC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$f_inic);
		$res->bindParam(2,$f_fin);
		$res->bindParam(3,$valcaja);
		$res->execute();
		return ($res->execute()==1) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function TotalCuadrereportippag($f_inic,$f_fin,$caja) {
		$valcaja=($caja=='T') ? '%' : $caja;
		$sql="SELECT ptoventa_descrip,formpagos_nombre,sum(pago_mon) as total, 
              (sum(pago_mon)-(ptoventa_portd * sum(pago_mon))/100) as total_porcentd,
              (sum(pago_mon)-(ptoventa_portc * sum(pago_mon))/100) as total_porcentc,pago_caja
               FROM selectcuadrecaja 
               WHERE date(pago_hor) between ? and ? and pago_caja like ? and fact_ide is not null and fact_anulada=0 
               GROUP BY ptoventa_descrip,formpagos_nombre,ptoventa_portd,ptoventa_portc,pago_caja
               ORDER BY ptoventa_descrip,pago_caja,formpagos_nombre ASC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$f_inic);
		$res->bindParam(2,$f_fin);
		$res->bindParam(3,$valcaja);
		$res->execute();
		return ($res->execute()==1) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function TotalCuadrerepor($f_inic,$f_fin,$caja) {
		$valcaja=($caja=='T') ? '%' : $caja;
		$sql="SELECT SUM(pago_mon) as total 
              FROM selectcuadrecaja 
              WHERE date(pago_hor) between ? and ? and pago_caja like ? 
              and fact_anulada=0 and fact_ide is not null";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$f_inic);
		$res->bindParam(2,$f_fin);
		$res->bindParam(3,$valcaja);
		$res->execute();
		$totalcuad = $res->fetchAll(PDO::FETCH_OBJ);
		return $totalcuad[0]->total;
	}
	public function getPaymentPaid($invoiced)
	{
		$payment = [];
		$datatPayment = $this->paymentPaid($invoiced);

		if (!empty($datatPayment)) {
			foreach ($datatPayment as $arr) {
				$payment[$arr['moneda_descripcion']][$arr["formpagos_nombre"]][] = [
					'tipo_pago' => $arr['formpagos_nombre'],
					'fecha_pago' => $arr['fecha_pago'],
					'caja' => $arr['pago_caja'],
					'tasa_conversion' => $arr['tasa_conversion'],
					'monto' => $arr['total'],
					'descuento' => $arr['descuento'],
					'bancos' => !empty($arr['bancos_nombre']) ? $arr['bancos_nombre'] : ''
				];
			}
		}
		return $payment;
	}
	public function paymentsBanks($datatPayment, $payment)
	{
		$banks = [];
		foreach ($datatPayment as $arr) {
			if ($arr['moneda_descripcion'] == $payment['moneda_descripcion'] && $arr['formpagos_nombre'] == $payment['formpagos_nombre']) {
				$banks[$arr['bancos_nombre']][] = [
					'banco' => $arr['bancos_nombre'],
					'fecha_pago' => $arr['fecha_pago'],
					'caja' => $arr['pago_caja'],
					'tasa_conversion' => $arr['tasa_conversion'],
					'monto' => $arr['total'],
					'descuento' => $arr['descuento']
				];
			}
		}

		return $banks;
	}
	public function paymentPaid($invoiced)
	{
		$fact_ide = ($invoiced) ? 'IS NOT NULL' : 'IS NULL';
		$valcaja=($this->tipcaja=='T') ? '%' : $this->tipcaja;
		$sql="SELECT
				slc.formpagos_nombre,
				slc.bancos_nombre,
				sum( slc.pago_mon ) AS total,
				sum( tpg.pago_descu ) AS descuento,
				CAST(slc.pago_hor AS DATE) AS fecha_pago,
				slc.pago_caja,
				IFNULL(tmd.moneda_descripcion, '') AS moneda_descripcion,
				tpg.tasa_conversion 
			FROM
				selectcuadrecaja AS slc
				INNER JOIN tbl_pagos AS tpg ON slc.pago_ide = tpg.pago_ide
				LEFT JOIN tbl_moneda AS tmd ON tpg.pago_moneda = tmd.moneda_ide
			WHERE
				date( slc.pago_hor ) BETWEEN ? 
				AND ? 
				AND slc.pago_caja LIKE ?
				AND slc.fact_ide $fact_ide
			GROUP BY
				slc.formpagos_nombre,
				slc.bancos_nombre,
				slc.pago_caja,
				tpg.pago_moneda 
			ORDER BY
				slc.formpagos_nombre,
				slc.pago_caja,
				tpg.pago_moneda ASC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->f_inic);
		$res->bindParam(2,$this->f_fin);
		$res->bindParam(3,$valcaja);
		$res->execute();
		return ($res->execute()==1) ? $res->fetchAll(PDO::FETCH_ASSOC) : print_r($res->errorInfo());
	}
	public function getPaymentPaidDetail($invoiced)
	{
		$payment = [];
		$datatPayment = $this->paymentPaidDetail($invoiced);

		if (!empty($datatPayment)) {
			foreach ($datatPayment as $arr) {
				$payment[$arr['moneda_descripcion']][$arr["formpagos_nombre"]][] = [
					'tipo_pago' => $arr['formpagos_nombre'],
					'fecha_pago' => $arr['fecha_pago'],
					'caja' => $arr['pago_caja'],
					'tasa_conversion' => $arr['tasa_conversion'],
					'monto' => $arr['monto'],
					'descuento' => $arr['descuento'],
					'referencia' => $arr['referencia'],
					'punto_venta' => $arr['punto_venta'],
					'procedimiento' => $arr['proced_des'],
					'fecha_factura' => $arr['fecha_factura'],
					'bancos' => []
				];
				if (!empty($arr['bancos_nombre'])) {
					$banks = $this->paymentsBanksDetail($datatPayment, $arr);
					$amount = [];
					$discount = [];
					array_walk($banks, function ($arr, $index) use(&$amount, &$discount) {
						$amount[] = array_sum(array_column($arr, 'monto'));
						$discount[] = array_sum(array_column($arr, 'descuento'));
					});

					$payment[$arr['moneda_descripcion']][$arr["formpagos_nombre"]] = [
						'tipo_pago' => $arr['formpagos_nombre'],
						'fecha_pago' => $arr['fecha_pago'],
						'caja' => $arr['pago_caja'],
						'tasa_conversion' => $arr['tasa_conversion'],
						'monto' => (!empty($amount)) ? array_sum($amount) : $arr['monto'],
						'descuento' => (!empty($discount)) ? array_sum($discount) : $arr['descuento'],
						'referencia' => $arr['referencia'],
						'punto_venta' => $arr['punto_venta'],
						'procedimiento' => $arr['proced_des'],
						'fecha_factura' => $arr['fecha_factura'],
						'bancos' => $banks
					];
				}
			}
		}

		return $payment;
	}
	public function paymentPaidDetail($invoiced)
	{
		$fact_ide = ($invoiced) ? 'IS NOT NULL' : 'IS NULL';
		$valcaja=($this->tipcaja=='T') ? '%' : $this->tipcaja;
		$sql="SELECT
				slc.formpagos_nombre,
				slc.bancos_nombre,
				slc.pago_mon AS monto,
				CAST( slc.pago_hor AS DATE ) AS fecha_pago,
				slc.pago_caja,
				slc.proced_des,
				slc.ptoventa_descrip AS punto_venta,
				IFNULL(tmd.moneda_descripcion, '') AS moneda_descripcion,
				tpg.pago_descu AS descuento,
				tpg.tasa_conversion,
				tpg.pago_nref AS referencia,
				tft.fact_fecha AS fecha_factura
			FROM
				selectcuadrecaja AS slc
				INNER JOIN tbl_pagos AS tpg ON slc.pago_ide = tpg.pago_ide
				LEFT JOIN tbl_factura AS tft ON slc.fact_ide = tft.fact_ide
				LEFT JOIN tbl_moneda AS tmd ON tpg.pago_moneda = tmd.moneda_ide 
			WHERE
				date( slc.pago_hor ) BETWEEN ?
				AND ? 
				AND slc.pago_caja LIKE ? 
				AND slc.fact_ide $fact_ide
			ORDER BY
				slc.formpagos_nombre,
				slc.pago_caja,
				tpg.pago_moneda ASC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->f_inic);
		$res->bindParam(2,$this->f_fin);
		$res->bindParam(3,$valcaja);
		$res->execute();
		return ($res->execute()==1) ? $res->fetchAll(PDO::FETCH_ASSOC) : print_r($res->errorInfo());
	}
	public function paymentsBanksDetail($datatPayment, $payment)
	{
		$banks = [];
		foreach ($datatPayment as $arr) {
			if ($arr['moneda_descripcion'] == $payment['moneda_descripcion'] && $arr['formpagos_nombre'] == $payment['formpagos_nombre']) {
				$banks[$arr['bancos_nombre']][] = [
					'banco' => $arr['bancos_nombre'],
					'fecha_pago' => $arr['fecha_pago'],
					'caja' => $arr['pago_caja'],
					'tasa_conversion' => $arr['tasa_conversion'],
					'monto' => $arr['monto'],
					'descuento' => $arr['descuento'],
					'referencia' => $arr['referencia'],
					'punto_venta' => $arr['punto_venta'],
					'procedimiento' => $arr['proced_des'],
					'fecha_factura' => $arr['fecha_factura']
				];
			}
		}

		return $banks;
	}
}