<?php 
require '../../../cfg/base.php';
$remisiones = $mremision->traerRemision($cedrif);
$plantillas = $mdocumento->plantillasPorTipo(2);
$odontologos = $mremision->especialistas();
$pathReplace = str_replace('\\','/',__DIR__);
$path = explode('app/', $pathReplace);
$pathDoc = $path[0].'doc';
?>

<script>
	$(function(){
		$('.remision-table').dataTable({
			"ordering": false,
			"aaSorting": []
		});
		$('.guardar-remision').validate({
			errorElement: 'div',
			errorClass: 'help-block',
			focusInvalid: true,
			rules: {},
			messages: {},

			invalidHandler: function (event, validator) { 
				$('.alert-danger', $('.diagproced')).show();
			},			
			highlight: function (e) {
				$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
			},
			success: function (e) {
				$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
				$(e).remove();
			},
			
			submitHandler: function (form) {
				if (!$('#documento_id').val() || !$('#especialista').val()) {
					alerta('.msj','danger','La plantilla y el especialista son obligatorios');
					return false;
				}

				var formData = new FormData(form);

				$.ajax({
					url: 'app/remision/procesos/insert.remision.php',
					type: 'POST',
					data: formData,
					cache: false,
					contentType: false,
					processData: false,
					success: function (data) {
						load('app/remision/vistas/admin.php','cedrif=<?php echo $cedrif ?>','#modulos')
					}
				});
			},
			invalidHandler: function (form) {
			}
		})
	})
	function blobToBase64(blob) {
		return new Promise((resolve, reject) => {
			const reader = new FileReader();
			reader.onloadend = () => {
				const dataUrl = reader.result;
				const base64 = dataUrl.substring(dataUrl.indexOf(',') + 1);
				resolve(base64);
			};
			reader.readAsDataURL(blob);
		});
	}
	function base64toBlob(base64Data, contentType) {
		contentType = contentType || '';
		var sliceSize = 1024;
		var byteCharacters = atob(base64Data);
		var bytesLength = byteCharacters.length;
		var slicesCount = Math.ceil(bytesLength / sliceSize);
		var byteArrays = new Array(slicesCount);

		for (var sliceIndex = 0; sliceIndex < slicesCount; ++sliceIndex) {
				var begin = sliceIndex * sliceSize;
				var end = Math.min(begin + sliceSize, bytesLength);

				var bytes = new Array(end - begin);
				for (var offset = begin, i = 0; offset < end; ++i, ++offset) {
						bytes[i] = byteCharacters[offset].charCodeAt(0);
				}
				byteArrays[sliceIndex] = new Uint8Array(bytes);
		}
		return new Blob(byteArrays, { type: contentType });
	}
	function download(documento){
		const arrDoc = documento.split('.');
		const fileName = arrDoc[0];
		const path = '<?php echo $pathDoc; ?>';
		fetch('doc/'+documento)
		.then(res => res.blob()).then(file => {
			blobToBase64(file).then(blobBase64 => {
				//const newBlob = base64toBlob(blobBase64, 'application/pdf'); //new Blob([blobBase64], { type: 'application/pdf' });
				//console.log(newBlob);
				let url = 'data:application/pdf;base64,'+blobBase64;  //window.URL.createObjectURL(newBlob);
				const elem = window.document.createElement("a");
				elem.href = url;
				elem.download = fileName+'.pdf';
				document.body.appendChild(elem);
        elem.click();
        document.body.removeChild(elem);
			});
    }).catch(() => {
      alert("Failed to download file!");
    });
	};
</script>

<h4 class="text-muted">Remisiones Médicas Externas</h4>
<hr>
<form class="col-sm-12 guardar-remision">
	<div class="msj"></div><br>
	<div class="form-group col-sm-6">
		<label class="col-sm-12 bolder control-label">
			Especialista:
		</label>
		<div class="col-sm-12 cargar-especialista">
			<select name="especialista" id="especialista" class="form-control">
				<option value="">Seleccionar</option>
				<?php if (!empty($odontologos)) {
						foreach ($odontologos as $odontologo) { ?>
							<option value="<?php echo $odontologo->pers_cedrif ?>"><?php echo $odontologo->pacien_nomraz; ?></option>
						<?php }
				} ?>
			</select>
		</div>	
	</div>
	<div class="form-group col-sm-6">
		<label class="col-sm-12 bolder control-label">
			Plantilla:
		</label>
		<div class="col-sm-12">
			<select name="documento_id" id="documento_id" class="form-control">
				<option value="">Seleccionar</option>
				<?php if (!empty($plantillas)) {
					foreach ($plantillas as $plantilla) { ?>
						<option value="<?php echo $plantilla->documento_id; ?>"><?php echo $plantilla->nombre; ?></option>
					<?php }
				} ?>
			</select>
		</div>	
	</div>

	<div class="form-group col-sm-12">
		<label class="col-sm-12 bolder control-label">
			Observación:
		</label>
		<div class="col-sm-12">
			<textarea class="form-control" rows="3" name="observacion"></textarea>
		</div>	
	</div>
	<div class="form-group col-sm-12">
		<input type="hidden" name="cedrif" value="<?php echo $cedrif ?>">
		<input type="hidden" name="tipo_especialista" value="2">
		<button class="btn btn-primary">Guardar</button>	
	</div>
</form>
<div class="clearfix"></div>
<?php if(!empty($remisiones)) { ?>
	<table class="table table-striped remision-table">
		<thead>
			<tr>
				<th>Fecha</th>
				<th>Hora</th>
				<th width="200">Médico</th>
				<th>Observación</th>
				<th>Opciones</th>
			</tr>
		</thead>
		<tbody>
				<?php foreach($remisiones as $remision) {  ?>
					<tr>
						<td><?php echo $fun->fecha($remision->fecha); ?></td>
						<td><?php echo $remision->hora; ?></td>
						<td><?php echo $remision->especialista; ?></td>
						<td align="justify"><?php echo $remision->observacion; ?></td>
						<td align="center">
							<div class="visible-md visible-lg visible-sm visible-xs action-buttons">
								<a href="<?php echo 'doc/'.$remision->documento; ?>" targe="_blanck" title="Descargar">
									<i class="fa fa-file-word-o fa-lg"></i>
								</a>
							</div>
						</td>
					</tr>
				<?php } ?>
		</tbody>
	</table>
<?php } else { ?>
	<div class="alert alert-info">
		<strong>No hay remision registradas.</strong>
	</div>
<?php } ?>