<?php 
class mRemision {
	protected $dbh,$con,$msj;

	function __clone() {

	} #clone

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	} #construct

	public function contarRemision($cedrif) {
		$sql = "SELECT count(*) as total FROM vw_notas WHERE notas_pacien=? and notas_recd=0";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		return ($res->execute()==1) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	public function traerRemision($cedrif) {
		$sql = "SELECT
				rmi.remision_id,
				IF
					( rmi.tipo_especialista = 1, 'Interno', 'Externo' ) AS tipo_especialista,
				rmi.fecha,
				rmi.observacion,
				rmi.hora,
				IF
					( pct.pacien_nomraz IS NOT NULL, pct.pacien_nomraz, eps.nombre ) AS especialista,
				documento
			FROM
				tbl_remision AS rmi
				LEFT JOIN tbl_pacien AS pct ON pct.pacien_cedrif = rmi.especialista_id
				LEFT JOIN tbl_especialistas AS eps ON eps.especialista_id = rmi.especialista_id 
			WHERE
				rmi.estado = 1
			AND rmi.paciente_id = ?
			ORDER BY rmi.fecha DESC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		return ($res->execute()==1) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	public function traerRemisionInterna($cedrif) {
		$sql = "SELECT * FROM vw_notas WHERE notas_pacien=? ORDER BY notas_ide DESC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		return ($res->execute()==1) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	public function insertRemision() {
		$date = date('Y-m-d');
		$hour = date('H:i:s');
		$sql = "INSERT INTO tbl_remision(especialista_id,paciente_id,tipo_especialista,fecha,observacion,remitido_por,estado,hora) VALUES(?,?,?,?,?,?,1,?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->especialista);
		$res->bindParam(2,$this->cedrif);
		$res->bindParam(3,$this->tipo_especialista);
		$res->bindParam(4,$date);
		$res->bindParam(5,$this->observacion);
		$res->bindParam(6,$_SESSION['ced']);
		$res->bindParam(7,$hour);
		if ($res->execute()) {
			$id=$this->con->lastInsertId();
			$response = ['status' => 'success', 'id' => $id];
		} else {
			$response = ['status' => 'error', 'message' => $res->errorInfo()];
		}
		return $response;
	}

	public function insertRemisionInterna() {
		$sql = "SELECT fn_remision(0,?,?,?,0,?,1)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->descrip);
		$res->bindParam(2,$this->especialista);
		$res->bindParam(3,$this->cedrif);
		$res->bindParam(4,$_SESSION['ced']);
		$res->execute();
	}
    
  public function LeidasRemision() {
		$sql = "SELECT fn_remision(?,0,?,?,?,?,2)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$res->bindParam(2,$this->especialista);
		$res->bindParam(3,$this->cedrif);
		$res->bindParam(4,$this->valor);
		$res->bindParam(5,$_SESSION['ced']);
		$res->execute();
	}
	public function especialistas()
	{
		$sql = "SELECT
					especialista_id AS pers_cedrif,
					nombre AS pacien_nomraz
				FROM
					tbl_especialistas
				WHERE
					estado = 1
				ORDER BY nombre";
		$res = $this->con->prepare($sql);
		return ($res->execute()) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}
	public function infoDocumentoRemision($remisionID)
	{
		$sql = "SELECT
					especialista_id AS pers_cedrif,
					nombre AS pacien_nomraz
				FROM
					tbl_especialistas
				WHERE
					estado = 1
				ORDER BY nombre";
		$res = $this->con->prepare($sql);
		return ($res->execute()) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}
	public function especialistaPorID($especialistaID)
	{
		$sql = "SELECT
					nombre AS pacien_nomraz,
					epc.espec_descrip 
				FROM
					tbl_especialistas AS esp
					INNER JOIN tbl_especialidad AS epc ON esp.especialidad_id = epc.espec_ide 
				WHERE
					esp.especialista_id = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$especialistaID);
		return ($res->execute()) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}
	public function agregarArchivoRemision($archivo, $remisionID)
	{
		$sql = "UPDATE tbl_remision SET documento = ? WHERE remision_id = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$archivo);
		$res->bindParam(2,$remisionID);
		$res->execute();
	}
}