<?php 
	class mReceta{
		
		protected $dbh,$con,$msj;

		function __clone() {

		} #clone

		function __construct() {
			$this->dbh = new Conexion();
			$this->con = $this->dbh->pgsql();
			$this->msj = array();
			if(isset($_POST)) {
				foreach($_POST as $indice=>$valor) {
					if(!is_array($valor)) {
						$this->$indice = strtoupper($valor);
					}
				}
			}
		} #construct

		function getAll() {
			$sql = "SELECT * FROM tbl_receta";
			$res = $this->con->prepare($sql);
			$res->execute();
			return $res->fetchAll(PDO::FETCH_OBJ);
		}

		function listaRecetaProced($ide_proced) {
			$sql = "SELECT * FROM vw_recetaproced WHERE receta_proc_ide=?";
		    $res = $this->con->prepare($sql);
		    $res->bindParam(1,$ide_proced);
		    $res->execute();
		    $rt = $res->fetchAll(PDO::FETCH_OBJ);
		    return $rt;
		}

		function recetaIde($ide_receta,$ide_produc) {
			$sql = "SELECT * FROM vw_recetaproced WHERE receta_ide=? and receta_produc_ide=?";
		    $res = $this->con->prepare($sql);
		    $res->bindParam(1,$ide_receta);
		    $res->bindParam(2,$ide_produc);
		    $res->execute();
		    $rt = $res->fetchAll(PDO::FETCH_OBJ);
		    return $rt;
		} 

		function listaRecetaPrecios($produc) {
			$sql = "SELECT produc_precio_bs,produc_precio_dol,produc_existen FROM tbl_producto WHERE produc_ide= ? and produc_borrado = 0";
		    $res = $this->con->prepare($sql);
		    $res->bindParam(1,$produc);
		    $res->execute();
			if(isset($res)) {
				$result = $res->fetchAll(PDO::FETCH_OBJ);
				$rt = $result;
			} else {
				$rt = 0;
			}
			return $rt;
		} 

		function recetaInsert() {
			$produc = (int)$this->produc;
			$proc_ide = (int)$this->proc_ide;
			$row = $this->listaRecetaPrecios($produc);
			$precio_dol = 0;
			$precio_bs = 0;
			// if($this->hon_pro != 1){
				$precio_dol = ($this->can * $row[0]->produc_precio_dol) / $row[0]->produc_existen;
				$precio_bs = $precio_dol * $this->dolar;
			// }
			// $precio_bs = ($this->can * $row[0]->produc_precio_bs) / $row[0]->produc_existen;
			$sql = "INSERT INTO tbl_receta VALUES (null,?,?,?,?,?,0,?)";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->proc_ide);
			$res->bindParam(2,$this->produc);
			$res->bindParam(3,$this->can);
			$res->bindParam(4,$precio_dol);
			$res->bindParam(5,$precio_bs);
			$res->bindParam(6,$this->hon_pro);
			$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
			$id=$this->con->lastInsertId(); 
				$this->dbh->sp_auditoria($_SESSION['ced'],1,'tbl_receta',$id);
			return $exe_1;
		}

		function selecSumPre() {
			$sql = "SELECT sum(receta_precio_bs) as sumabs, sum(receta_precio_dol) as sumadol FROM tbl_receta WHERE receta_proc_ide= ?";
		    $res = $this->con->prepare($sql);
		    $res->bindParam(1,$this->proc_ide);
		    $res->execute();
			if(isset($res)) {
				$result = $res->fetchAll(PDO::FETCH_OBJ);
				$sumas = $result;
				$rt = $this->updatePreProc($sumas,$this->proc_ide); 
			} if($rt == 1){
				$rt = 1;
			}else{
				$rt=0;
			}
			return $rt;
		} 

		function updatePreProc2($sumas,$proc_ide) {
			$sql = "UPDATE tbl_proced SET proced_prec=?, proced_prec_dol=?, proced_rece_proce=1 where proced_ide=?";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$sumas[0]->sumabs);
			$res->bindParam(2,$sumas[0]->sumadol);
			$res->bindParam(3,$proc_ide);
			$res->execute();
			if(isset($res)) {
				$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_proced',$proc_ide);
				$rt = 1;
			} else {
				$rt = 0;
			}
		return $rt;
		}

		function updatePreProc() {
			$sql = "UPDATE tbl_proced SET proced_prec=?, proced_prec_dol=?, proced_rece_proce=1 where proced_ide=?";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->suma_bs);
			$res->bindParam(2,$this->suma_dol);
			$res->bindParam(3,$this->proc_ide);
			$res->execute();
			if(isset($res)) {
				$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_proced',$this->proc_ide);
				$rt = 1;
			} else {
				$rt = 0;
			}
			return $rt;
		}

		function recetaUpdate() {
			$produc = (int)$this->ide_produc;
			$proc_ide = (int)$this->proc_ide;
			$ide_receta = (int)$this->ide_receta;
			$row = $this->listaRecetaPrecios($produc);
			$precio_dol = 0;
			$precio_bs = 0;
			// if($this->hon_pro2 != 0){
				$precio_dol = ($this->can * $row[0]->produc_precio_dol) / $row[0]->produc_existen;
				$precio_bs = $precio_dol * $this->dolar;
			// }
			$this->con->beginTransaction();
			// $precio_bs = ($this->can * $row[0]->produc_precio_bs) / $row[0]->produc_existen;
			$sql = "UPDATE tbl_receta SET receta_produc_ide=?, receta_cant=?, receta_precio_bs=?, receta_precio_dol=?, receta_servicio=? where receta_ide=?";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->ide_produc);
			$res->bindParam(2,$this->can);
			$res->bindParam(3,$precio_bs);
			$res->bindParam(4,$precio_dol);
			$res->bindParam(5,$this->hon_pro2);
			$res->bindParam(6,$this->ide_receta);
			$uno=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		   	if ($uno==1) {
		   		$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_receta',$this->ide_receta);
				$this->con->commit();
				$rt = 1;
			} else {
				$this->con->rollBack();
				$rt = $this->msj;
			}
			return $rt;
		}

		function recetaDelete() {
			$precio_bs = (int)$this->pre_bs;
			$precio_dol = (int)$this->pre_dol;
			$ide_proced = (int)$this->proc_ide;
			$sql = "DELETE FROM tbl_receta where receta_ide=?";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->ide_receta);
			$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
				$this->dbh->sp_auditoria($_SESSION['ced'],3,'tbl_receta',$this->ide_receta);
			return $exe_1;
		} 

		function editProce() {
			$sql = "UPDATE tbl_proced SET proced_rece_proce = 0 where proced_ide=?";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->ide_proced);
			$res->execute();
			if (isset($res)) {
				$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_proced',$this->ide_proced);
				$rt = 1;
			}else{
				$rt = 0;
			}
			return $rt;
		}

	}
?>