<?php  
require '../../../cfg/base.php';
$rows = $mproveedores->proveedorSelectIde($ide);
$tipos = array(
	array('id' => 'CC', 'descripcion' => 'CC'),
	array('id' => 'NIT', 'descripcion' => 'NIT')
);
echo $fun->modalHeader('Editar Registro') ?>
<div class="modal-body">
	<div class="bootbox-body">
		<div class="col-xs-12">
			<div class="mensaje1"></div>
				<form action="" class="actualizar-proveedores" role="form">
					<div class="form-group">
						<label for="" class="control-label col-xs-12 bolder">Tipo de Identificación</label>
						<select name="tipo_identificacion" class="col-sm-12">
							<option value="">Seleccionar</option>
							<?php foreach ($tipos as $tipo) {
								$selected = ($tipo['id'] == $rows[0]->proveedor_tipo_identificacion) ? 'selected' : '';
							?>
								<option value="<?php echo $tipo['id']; ?>" <?php echo $selected; ?>><?php echo $tipo['descripcion']; ?></option>
							<?php } ?>
						</select>
					</div>
					<div class="form-group">
						<label for="" class="control-label col-xs-12 bolder">N&uacute;mero de Identificaci&oacute;n</label>
						<input type="text" name="cedrif" id="cedrif" class="col-sm-12" value="<?php echo $rows[0]->proveedor_cedrif ?>">
					</div>
					<div class="form-group">
						<label for="" class="control-label col-xs-12 bolder">Nombre y Apellido / Raz&oacute;n Social</label>
						<input type="text" name="nom" id="nom" class="col-sm-12" value="<?php echo $rows[0]->proveedor_nom ?>">
					</div>
					<div class="form-group">
						<label for="" class="control-label col-xs-12 bolder">Direcci&oacute;n</label>
						<input type="text" name="dir" id="dir" class="col-sm-12" value="<?php echo $rows[0]->proveedor_direc ?>">
					</div>
					<div class="form-group">
						<label for="" class="control-label col-xs-12 bolder">Tel&eacute;fono</label>
						<input type="text" name="tlf" id="tlf" class="col-sm-12" value="<?php echo $rows[0]->proveedor_tlf ?>">
					</div>
					<div class="form-group">
						<label for="" class="control-label col-xs-12 bolder">Correo</label>
						<input type="email" name="correo" id="correo" class="col-sm-12" value="<?php echo $rows[0]->proveedor_correo ?>">
					</div>

					<input type="hidden" name="ide" value="<?php echo $rows[0]->proveedor_ide ?>">
				</form>
		</div>
	</div>
</div>
<div class="clearfix"></div>
<div id="proveedores"></div>
<?php echo $fun->modalFooter('Guardar Cambios','btn-modificar-proveedor') ?>

<script>

	$('.actualizar-proveedores').validate({
			errorElement: 'div',
			errorClass: 'help-inline',
			focusInvalid: true,
			rules: {
				cedrif: {
					required: true,
					minlength: 7,
					number: true
				},
				nom: {
					required:true
				},
				tlf: {
					required: true,
					number: true
				},
				dir: {
					required:true
				},
				correo: {
					email:true
				},
				tipo_identificacion: {
					required:true
				}
			},
			messages: {
				cedrif: {
					required: "Indique Nro Identificación",
					minlength: 'Número de Nro Identificación no válido',
					number: 'Debe indicar un valor numérico'
				},
				nom: {
					required:'Ingrese el nombre o razón social'
				},
				tlf: {
					required: 'Ingrese el número de teléfono',
					number: 'Ingrese solo numeros'
				},
				dir: {
					required:'Ingrese la dirección'
				},
				correo: {
					email:'Ingrese una dirección de correo valida'
				},
				tipo_identificacion: {
					required:'Ingrese tipo de indentificacion'
				}
			},
			invalidHandler: function (event, validator) { 
				$('.mensaje1', $('.actualizar-proveedores')).show();
			},			
			highlight: function (e) {
				$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
			},
			success: function (e) {
				$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
				$(e).remove();
			},
			submitHandler: function (form) {
				$.post('app/proveedores/procesos/p.proveedores.update.php',$('.actualizar-proveedores').serialize(),function(data){
					if(data==1) {
						alerta('.mensaje1','success','Registro actualizado correctamente');
						load('app/proveedores/vistas/proveedores.lista.php','','.lista-proveedores')
					} else {
						alerta('.mensaje1','danger',data);
					}
			})
				
			},
			invalidHandler: function (form) {
				$('#proveedores').fadeOut(1);
			}
		 
	});

	$('.btn-modificar-proveedor').click(function(){
		$('.actualizar-proveedores').submit();
	});

</script>