<?php
$tipos = array(
	array('id' => 'CC', 'descripcion' => 'CC'),
	array('id' => 'NIT', 'descripcion' => 'NIT')
);
?>
<div id="breadcrumbs" class="breadcrumbs">
	<ul class="breadcrumb">
		<li><i class="icon-home home-icon"></i> <a href="">Inicio</a></li>
		<li class="active"><i class="fa fa-cogs"></i> <a href="">Procesos</a></li>
		<li class="active"> Proveedores</li>
	</ul>
</div>

<div class="space-10"></div>
<div class="col-xs-12 col-md-4 col-sm-4 well">
	<div class="mensaje"></div>
	<form action="" class="guardar-proveedores" role="form">
		<div class="form-group">
			<label for="" class="control-label col-xs-12 bolder">Tipo de Identificación</label>
			<select name="tipo_identificacion" class="col-sm-12">
				<option value="">Seleccionar</option>
				<?php foreach ($tipos as $tipo) { ?>
					<option value="<?php echo $tipo['id']; ?>"><?php echo $tipo['descripcion']; ?></option>
				<?php } ?>
			</select>
		</div>
		<div class="form-group">
			<label for="" class="control-label col-xs-12 bolder">Número de Identificación</label>
			<input type="text" name="cedrif" id="cedrif" class="col-sm-12">
		</div>
		<div class="form-group">
			<label for="" class="control-label col-xs-12 bolder">Nombre y Apellido / Razón Social</label>
			<input type="text" name="nom" id="nom" class="col-sm-12">
		</div>
		<div class="form-group">
			<label for="" class="control-label col-xs-12 bolder">Dirección</label>
			<input type="text" name="dir" id="dir" class="col-sm-12">
		</div>
		<div class="form-group">
			<label for="" class="control-label col-xs-12 bolder">Tel&eacute;fono</label>
			<input type="text" name="tlf" id="tlf" class="col-sm-12">
		</div>
		<div class="form-group">
			<label for="" class="control-label col-xs-12 bolder">Correo</label>
			<input type="email" name="correo" id="correo" class="col-sm-12">
		</div>
		<div class="clearfix"></div>
		<div class=" clearfix form-actions">
			<div class="col-xs-12">
				<button class="btn btn-primary btn-block"><i class="icon-ok bigger-110"></i> Guardar Cambios</button>
			</div>
		</div>
	</form>
</div>
<div class="col-xs-12 col-md-8 col-sm-8 lista-proveedores">
</div>
<div class="clearfix"></div>
<div id="proveedores"></div>


<script>
	try{ace.settings.check('breadcrumbs' , 'fixed')}catch(e){}
</script>
<script>
	load('app/proveedores/vistas/proveedores.lista.php','','.lista-proveedores')

	$('.guardar-proveedores').validate({
			errorElement: 'div',
			errorClass: 'help-inline',
			focusInvalid: true,
			rules: {
				cedrif: {
					required: true,
					minlength: 7,
					number: true
				},
				nom: {
					required:true
				},
				tlf: {
					required: true,
					number: true
				},
				dir: {
					required:true
				},
				correo: {
					email:true
				},
				tipo_identificacion: {
					required:true
				}
			},
			messages: {
				cedrif: {
					required: "Indique Nro Identificación",
					minlength: 'Número de Nro Identificación no válido',
					number: 'Debe indicar un valor numérico'
				},
				nom: {
					required:'Ingrese el nombre o razón social'
				},
				tlf: {
					required: 'Ingrese el número de teléfono',
					number: 'Ingrese solo numeros'
				},
				dir: {
					required:'Ingrese la dirección'
				},
				correo: {
					email:'Ingrese una dirección de correo valida'
				},
				tipo_identificacion: {
					required:'Ingrese tipo de indentificacion'
				}
			},
			invalidHandler: function (event, validator) { 
				$('.mensaje', $('.guardar-proveedores')).show();
			},			
			highlight: function (e) {
				$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
			},
			success: function (e) {
				$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
				$(e).remove();
			},
			submitHandler: function (form) {
				$.post('app/proveedores/procesos/p.proveedores.insert.php',$('.guardar-proveedores').serialize(),function(data){
					if(data==1) {
						alerta('.mensaje','success','Registro guardado correctamente');
						load('app/proveedores/vistas/proveedores.lista.php','','.lista-proveedores')
						$('.guardar-proveedores').each(function(){
							this.reset();
						})
					} else {
						alerta('.mensaje','danger',data);
					}
			})
				
			},
			invalidHandler: function (form) {
				$('#proveedores').fadeOut(1);
			}
		});

</script>