<?php 
class mProveedores {

	protected $dbh,$con,$msj;

	function __clone() {

	} #clone

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	} #construct


	function proveedoresInsert() { 
		$sql = "INSERT INTO tbl_proveedores(proveedor_tipo_identificacion,
		proveedor_cedrif,
		proveedor_nom,
		proveedor_direc,
		proveedor_tlf,
		proveedor_correo,
		proveedor_borrado
		) VALUES (?,?,?,?,?,?,0)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->tipo_identificacion);
		$res->bindParam(2,$this->cedrif);
		$res->bindParam(3,$this->nom);
		$res->bindParam(4,$this->dir);
		$res->bindParam(5,$this->tlf);
		$res->bindParam(6,$this->correo);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		$id=$this->con->lastInsertId(); 
		$this->dbh->sp_auditoria($_SESSION['ced'],1,'tbl_proveedores',$id);
		return $exe_1;
	}

	function proveedorSelect() {
		$sql = "SELECT * FROM tbl_proveedores WHERE proveedor_borrado=0 ORDER BY proveedor_ide ASC";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function proveedorSelectIde($ide) {
		$sql = "SELECT * FROM tbl_proveedores where proveedor_ide=? and proveedor_borrado=0";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function proveedorSelectCedrif($cedrif) {
		$sql = "SELECT * FROM tbl_proveedores where proveedor_cedrif=? and proveedor_borrado=0";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function proveedorUpdate() {
		$this->con->beginTransaction(); 
		$sql = "UPDATE tbl_proveedores SET proveedor_cedrif=?, proveedor_nom=?, proveedor_direc=?, proveedor_tlf=?,
		proveedor_correo=?, proveedor_tipo_identificacion=? WHERE proveedor_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->cedrif);
		$res->bindParam(2,$this->nom);
		$res->bindParam(3,$this->dir);
		$res->bindParam(4,$this->tlf);
		$res->bindParam(5,$this->correo);
		$res->bindParam(6,$this->tipo_identificacion);
		$res->bindParam(7,$this->ide);
		$uno=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		if ($uno==1) {
			$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_proveedores',$this->ide);
			$this->con->commit();
			$rt = 1;
		} else {
			$this->con->rollBack();
			$rt = $this->msj;
		}
		return $rt;
	// var_dump($this->tlf);
	}

	function proveedorDelete() {
		$this->con->beginTransaction(); 
		$sql = "UPDATE tbl_proveedores SET proveedor_borrado=1 where proveedor_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$uno=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
	   	if ($uno==1) {
	   		$this->dbh->sp_auditoria($_SESSION['ced'],3,'tbl_proveedores',$this->ide);
			$this->con->commit();
			$rt = 1;
		} else {
			$this->con->rollBack();
			$rt = $this->msj;
		}
		return $rt;
	}


} #class
?>