<?php 
require '../../../cfg/base.php'; 
?>
<?php echo $fun->modalHeader('Agregar Lote de Producto') ?>
<?php echo $fun->modalWidth(70) ?>
<div class="modal-body">
	<div class="bootbox-body">
		<div class="col-sm-12">
			<div class="mensajelote"></div>
			<form action="" role="form" class="lote-insert">
				<div class="col-lg-12">
					<div class="col-sm-4">
						<div class="form-group">
							<label for="" class="control-label bolder col-sm-12">Nro de lote:</label>
							<div class="col-sm-12">
								<input type="text" class="form-control" id="nrolote" name="nrolote">
							</div>
						</div>	
					</div>
					<div class="col-sm-4">
						<div class="form-group">
							<label for="" class="control-label bolder col-sm-12">Fecha de vencimiento:</label>
							<div class="col-sm-12">
								<input type="date" min="0" class="form-control" name="fvenci" id="fvenci">
							</div>
						</div>	
					</div>
					<div class="col-sm-4">
						<div class="form-group">
							<label for="" class="control-label bolder col-sm-12">Permiso Sanitario:</label>
							<div class="col-sm-12">
								<input class="form-control" name="permsani" id="permsani">
							</div>
						</div>	
					</div>
			    </div>
			    <div class="col-lg-12">
					<div class="col-sm-4">
						<div class="form-group">
							<label for="" class="control-label bolder col-sm-12">Color:</label>
							<div class="col-sm-12">
								<input type="text" class="form-control" id="colorlote" name="colorlote">
							</div>
						</div>	
					</div>
			    </div>
			    <div class="col-lg-12">
                    <div class="btn-toolbar pull-right">
					      <div class="btn-group">
							<!-- IDENTIFICADOR -->
							<input type="hidden" name="ide" value="<?php echo $ide ?>">
					        <button type="button" class="btn btn-primary btn-agregar-lote"><i class="fa fa-plus-square"></i> Guardar</button>
					      </div>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>
<div class="space-20"></div>
<div class="clearfix"></div>
<br>
<div id="lista-lote"></div>
<?php echo $fun->modalFooter2() ?>
<script>
	$(function(){
		load('app/producto/vistas/lote.lista.php','ide=<?php echo $ide ?>','#lista-lote');

		$('.btn-agregar-lote').click(function() {
			$('.lote-insert').submit();
		});

		$('.lote-insert').validate({
			errorElement: 'div',
			errorClass: 'help-inline',
			focusInvalid: true,
			rules: {
				nrolote: {
					required: true
				},
				fvenci: {
					required: true
				},
				permsani: {
					required: true
				}
			},
			messages: {
				nrolote: {
					required: 'Obligatorio',
				},
				fvenci: {
					required: 'Obligatorio',
				},
				permsani: {
					required: 'Obligatorio',
				}
			},
			invalidHandler: function (event, validator) { 
				$('.alert-danger', $('.lote-insert')).show();
			},			
			highlight: function (e) {
				$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
			},
			success: function (e) {
				$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
				$(e).remove();
			},
			submitHandler: function (form) {
				$.post('app/producto/procesos/p.lote.insert.php',$('.lote-insert').serialize(),function(data){
					if(data==1) {
						load('app/producto/vistas/lote.lista.php','ide=<?php echo $ide ?>','#lista-lote');
						alert('Registro agregado con exito');
						//cerrarmodal();
					} else {
						alerta('.mensajelote','danger',data);
					}
				})
			},
			invalidHandler: function (form) {
			}
		})
	})
</script>