<?php 
class mProducto {

	protected $dbh,$con,$msj;

	function __clone() {

	} #clone

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	} #construct

	function getAll() {
		$sql = "SELECT * FROM tbl_producto WHERE produc_borrado = 0 limit 170";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function producInsert() {
		$sql = "INSERT INTO tbl_producto VALUES (null,?,?,?,?,?,?,?,?,?,?,0,?,?,?,?,?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->des);
		$res->bindParam(2,$this->exi);
		$res->bindParam(3,$this->costo_bs);
		$res->bindParam(4,$this->costo_dol);
		$res->bindParam(5,$this->porc_gan);
		$res->bindParam(6,$this->pre_bs);
		$res->bindParam(7,$this->pre_dol);
		$res->bindParam(8,$this->serv);
		$res->bindParam(9,$this->unidmed);
		$res->bindParam(10,$this->valdol);
		$res->bindParam(11,$this->iva);
		$res->bindParam(12,$this->aplic);
		$res->bindParam(13,$this->total_aplic);
		$res->bindParam(14,$this->exi_min);
		$res->bindParam(15,$this->color);		

		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		$id=$this->con->lastInsertId(); 
		$this->dbh->sp_auditoria($_SESSION['ced'],1,'tbl_producto',$id);
		return $exe_1;
	}

	function producSelectIde($ide) {
		$sql = "SELECT * FROM tbl_producto where produc_ide=? and produc_borrado=0";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}	

	function productoSelectLast() {
		$sql = "SELECT produc_ide FROM tbl_producto WHERE produc_borrado=0 ORDER BY produc_ide DESC LIMIT 1";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function producUpdate() {
		$this->con->beginTransaction();
		$sql = "UPDATE tbl_producto SET produc_descrip=?,produc_existen=?,produc_costo_bs=?,produc_costo_dol=?,produc_porc_gan=?,produc_precio_bs=?,produc_precio_dol=?,produc_servicio=?,produc_unid_med=?,produc_valdol=?,produc_impuesto=?, produc_aplicac=?, produc_taplicac=?, produc_exis_min_aplic=?,produc_color=? where produc_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->des);
		$res->bindParam(2,$this->exi);
		$res->bindParam(3,$this->costo_bs);
		$res->bindParam(4,$this->costo_dol);
		$res->bindParam(5,$this->porc_gan);
		$res->bindParam(6,$this->pre_bs);
		$res->bindParam(7,$this->pre_dol);
		$res->bindParam(8,$this->serv);
		$res->bindParam(9,$this->unidmed);
		$res->bindParam(10,$this->valdol);
		$res->bindParam(11,$this->iva);
		$res->bindParam(12,$this->aplic);
		$res->bindParam(13,$this->total_aplic);
		$res->bindParam(14,$this->exi_min);
		$res->bindParam(15,$this->color);		
		$res->bindParam(16,$this->ide);

		$uno=($res->execute()==1) ? 1 : print_r($res->errorInfo());

	   	if ($uno==1) {
	   		$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_producto',$this->ide);
			$this->con->commit();
			$actualizar = $this->actualizarPreDol($this->ide,$this->costo_dol,$this->costo_bs,$this->exi);
			if ($actualizar == 1) {
				$rt = 1;
			}else{
				$this->con->rollBack();
				$rt = $this->msj;
			}
		} else {
			$this->con->rollBack();
			$rt = $this->msj;
		}
		return $rt;
	}

	function actualizarPreDol($ide,$pre_dol,$pre_bs,$existen) {
		$sql = "SELECT fn_actualizarpredol(?,?,?,?) as resp";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->bindParam(2,$pre_dol);
		$res->bindParam(3,$pre_bs);
		$res->bindParam(4,$existen);
		$res->execute();
		$result = $res->fetchAll(PDO::FETCH_OBJ);
		if ($result[0]->resp == 1) {
			$rt = 1;
		}else{
			$rt = 0;
		}

		return $rt;
    }


	function producDelete() {
		$sql = "SELECT * FROM tbl_receta WHERE receta_produc_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$res->execute();
		$total = $res->rowCount();

		if($total==0) {
				$this->con->beginTransaction(); 
				$sql = "DELETE  FROM tbl_producto where produc_ide=?";
				$res = $this->con->prepare($sql);
				$res->bindParam(1,$this->ide);
				$uno=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
			   	if ($uno==1) {
			   		$this->dbh->sp_auditoria($_SESSION['ced'],3,'tbl_producto',$this->ide);
					$this->con->commit();
					$rt = 1;
				} else {
					$this->con->rollBack();
					$rt = $this->msj;
				}
		}else{
                 $rt = "No Se Puede Eliminar,  El Producto Esta En Una Receta Asignada";
		}
		return $rt;
	}

	// function cargarCanMaxtProdu($ide_produc,$receta_cant){
	// 	if ($ide_produc != 0 ) {
	// 		$row = $this->producSelectIde($ide_produc);
	// 		$rece_cant = ($receta_cant != 0) ? $receta_cant : '' ;
	// 		$html = '<div class="form-group">
	// 					<label for="" class="control-label bolder col-sm-12">Cantidad:</label>
	// 					<div class="col-sm-12">
	// 						<input type="number" min="0" max="'.$row[0]->produc_taplicac.'" value="'.$rece_cant.'" class="form-control" name="can" id="can">
	// 					</div>';
	// 		if($ide_produc != 1){
	// 			$html .=	'<div>
	// 							<font color="#ED1C24"> Cantidad Aplicaciones = '.$row[0]->produc_taplicac.'</font>
	// 						</div>
	// 					 </div>';
	// 		}else{
	// 			$html .= "</div>";
	// 		}
	// 	}else{					

	// 		$html = '<div class="form-group">
	// 					<label for="" class="control-label bolder col-sm-12">Cantidad:</label>
	// 					<div class="col-sm-12">
	// 						<input type="number" min="0" class="form-control" name="can" id="can" readonly>
	// 					</div>
	// 				 </div>';

	// 	}
	// 	return $html;
	// }

	function cargarCanMaxtProdu($ide_produc){
		$row = $this->producSelectIde($ide_produc);
		return $row;
	}
	public function loteInsert()
	{
		$sql = "INSERT INTO tbl_producto_lotes VALUES (null,?,?,?,?,?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$res->bindParam(2,$this->nrolote);
		$res->bindParam(3,$this->fvenci);
		$res->bindParam(4,$this->permsani);
		$res->bindParam(5,$this->colorlote);

		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo());
		return $exe_1;
	}
	public function getAllLote($ide_produc)
	{
		$sql = "SELECT * FROM tbl_producto_lotes WHERE produc_ide= $ide_produc limit 170";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
	public function loteSelectIde($ide_lote)
	{
		$sql = "SELECT * FROM tbl_producto_lotes where produclote_ide= $ide_lote";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
	public function deleteLote()
	{
		$sql = "DELETE FROM tbl_producto_lotes WHERE produclote_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$rt = ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		return $rt;
	}
} #class
?>