<?php 
class mProced {

	protected $dbh,$con,$msj;

	function __clone() {

	} #clone

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	} #construct


	function procedInsert() {
        $valexen=(isset($this->exento) && !empty($this->exento)) ? $this->exento : 0;
        $valpieza=(isset($this->pieza) && !empty($this->pieza)) ? $this->pieza : 0; 
		$sql = "INSERT INTO tbl_proced VALUES (null,?,?,?,?,?,?,1,?,?,0,0,?,0)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->des);
		$res->bindParam(2,$this->pre);
		$res->bindParam(3,$this->costo_dol); //costo en dolares
		$res->bindParam(4,$this->dol_stat); //si esta ajustado al dolar o no
		$res->bindParam(5,$this->porc_med); //porcentaje del medico
		$res->bindParam(6,$valexen); // porcentaje de la clinica
		$res->bindParam(7,$this->porc_cli);
		$res->bindParam(8,$valpieza);
		$res->bindParam(9,$this->ide_espec);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		$id=$this->con->lastInsertId(); 
				$this->dbh->sp_auditoria($_SESSION['ced'],1,'tbl_proced',$id);
			return $exe_1;
	}

	function procedSelect() {
		$sql = "SELECT * FROM tbl_proced ORDER BY proced_des ASC";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function procedSelectIde($ide) {
		$sql = "SELECT * FROM tbl_proced where proced_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function procedEspecSelect($ide_espec) {
		$sql = "SELECT * FROM tbl_proced where proced_espe=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide_espec);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function procedSelectIdeEnUso($ide) {
		$sql = "SELECT COUNT(*) as total FROM vw_tratamientopagar
				WHERE trat_est = 3 and proced_ide = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function procedUpdate() {
		$this->con->beginTransaction();
		$valexen=(isset($this->exento) && !empty($this->exento)) ? $this->exento : 0;
        $valpieza=(isset($this->pieza) && !empty($this->pieza)) ? $this->pieza : 0;

		$sql = "UPDATE tbl_proced SET proced_des=?, proced_prec=?, proced_prec_dol=?,  proced_predol_stat=?, proced_porc_med=?, proced_exe=?, proced_porc_clin=?, proced_pieza=? where proced_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->des);
		$res->bindParam(2,$this->pre);
		$res->bindParam(3,$this->costo_dol); //costo en dolares
		$res->bindParam(4,$this->dol_stat); //si esta ajustado al dolar o no
		$res->bindParam(5,$this->porc_med); //porcentaje del medico
		$res->bindParam(6,$valexen); // porcentaje de la clinica
		$res->bindParam(7,$this->porc_cli);
		$res->bindParam(8,$valpieza);
		$res->bindParam(9,$this->ide);
		$uno=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 

		/*$sql = "UPDATE tbl_tratamiento set proced_prec=?, proced_exe=? where proced_ide=? and trat_est=0";
	  	$res = $this->con->prepare($sql);
	  	$res->bindParam(1,$this->pre);
		$res->bindParam(2,$valexen);
	  	$res->bindParam(3,$this->ide);
	   	$dos = ($res->execute()==1) ? 1 : $this->msj[] = print_r($res->errorinfo());*/

	   	//if ($uno==1 and $dos==1) {
	   	if ($uno==1) {
	   		$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_proced',$this->ide);
			$this->con->commit();
			$rt = 1;
		} else {
			$this->con->rollBack();
			$rt = $this->msj;
		}
		return $rt;
	}

	function procedRecetaDelete() {
		$sql = "DELETE FROM tbl_receta where receta_proc_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$uno = ($res->execute()==1) ? 1 : print_r($res->errorInfo());
		if ($uno == 1) {
			$this->dbh->sp_auditoria($_SESSION['ced'],3,'tbl_receta',$this->ide);
			$result = $this->procedDelete($this->ide);
		}
		if($result == 1){
			$rt = 1;
		}else{
			$rt = print_r($res->errorInfo());
		}
		return $rt;
	}

	function procedDelete() {
		$sql = "DELETE FROM tbl_proced where proced_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
			$this->dbh->sp_auditoria($_SESSION['ced'],3,'tbl_proced',$this->ide);
			return $exe_1;
	}


} #class
?>