<?php 
require '../../../cfg/base.php';
$paciente = $musuarios->buscarPaciente($_GET['ced']);
$procedimientos = ($_GET['procedimiento_id'] != 'all') ? $_GET['procedimiento_id'] : '';
$pagos = $mpagos->abonosPorPaciente($_GET['ced'], $procedimientos);
?>
<h3 style="text-align: center">
    Recibo de Abonos
</h3>
<table class="table-responsive" id="contenido" style="margin-bottom: 10px;">
    <tr>
        <td colspan="2" align="right" class="titulos_principales_rest"><span><b>Fecha:</b><?php echo date('d-m-Y'); ?></span></td>
    </tr>
    <tr>
        <td align="left"><span><b>Nombre o Razon Social: </b><?php echo $paciente[0]->pacien_nomraz; ?></span></td>
        <td align="right"><span><b>Telefono: </b><?php echo $paciente[0]->pacien_movil1tlf; ?></span></td>
    </tr>
</table>
<?php
if(!empty($pagos)) {
	$abonos = [];
	array_walk($pagos, function($pago) use(&$abonos) {
		if (!isset($abonos[$pago['trat_ide']])) {
			$abonos[$pago['trat_ide']] = array(
				'procedimiento' => $pago['proced_des'],
				'total' => $pago['pago_tot']
			);
		}
		$abonos[$pago['trat_ide']]['abonos'][] = array(
			'id' => $pago['pago_ide'],
			'monto' => $pago['pago_mon'],
			'descuento' => $pago['pago_descu'],
			'fecha' => $pago['pago_hor'],
			'deuda' => $pago['pago_dev']
		);
	});
?>
	<div class="table-responsive">
		<?php foreach ($abonos as $abono) {
			$totalAbonos = array_sum(array_column($abono['abonos'], 'monto'));
			$totalDescuentos = array_sum(array_column($abono['abonos'], 'descuento'));
			$maxId = max(array_column($abono['abonos'], 'id'));
			$deuda = array_values(array_filter($abono['abonos'], function ($arr) use($maxId) {
				return $arr['id'] == $maxId;
			}));
		?>
			<table id="contenido" style="margin-bottom: 10px; font-size: 14px;">
				<tr>
					<td align="left"><strong>Procedimiento:</strong> <?php echo $abono['procedimiento']; ?></td>
					<td align="right"><strong>Total:</strong> <?php echo number_format($abono['total'], 2, ',', '.'); ?></td>
				</tr>
			</table>

			<table class="table table-hover table-bordered documents tabla7">
				<thead>
					<tr>
						<th>Fecha del Abono</th>
						<th>Abonos</th>
						<th>Descuentos</th>
						<th>Deuda</th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ($abono['abonos'] as $value) { ?>
						<tr>
							<td><?php echo date('d-m-Y H:i:s', strtotime($value['fecha'])); ?></td>
							<td style="text-align: right;"><?php echo number_format($value['monto'], 2, ',', '.'); ?></td>
							<td style="text-align: right;"><?php echo number_format($value['descuento'], 2, ',', '.'); ?></td>
							<td style="text-align: right;"><?php echo number_format($value['deuda'], 2, ',', '.'); ?></td>
						</tr>
					<?php } ?>
					<tr style="font-size: 12px;">
						<td style="text-align: right;"><strong>Total</strong></td>
						<td style="text-align: right;"><?php echo number_format($totalAbonos, 2, ',', '.'); ?></td>
						<td style="text-align: right;"><?php echo number_format($totalDescuentos, 2, ',', '.'); ?></td>
						<td style="text-align: right;"><?php echo number_format($deuda[0]['deuda'], 2, ',', '.'); ?></td>
					</tr>
				</tbody>
			</table>
		<?php } ?>
	</div>
<?php } else { ?>
	<div class="alert alert-info">
		<strong>No se encontraron registros.</strong>
	</div>
<?php } ?>

<script type="text/javascript">	
	$(function(){
		$('.documents').dataTable();
	});
</script>