$(function() {

    $('.generarPago').validate({
        errorElement: 'div',
        errorClass: 'help-block',
        focusInvalid: true,
        rules: {
            tipo: {
                required: true,
            },
            monto: {
                required: true,
                number: true,
            },
            num_ref: {
                required: true,
                number: true,
            },
            ptoventa: {
                required: true,
                number: true,
            },
            banco: {
                required: true,
                number: true,
            },
            tipcaja: {
                required: true,
            },
            moneda: {
                required: true,
            },
        },

        messages: {
            cedula: {
                required: 'Obligatorio',
            },
            monto: {
                required: 'Obligatorio',
                number: 'Solo Numeros',
            },
            num_ref: {
                required: 'Obligatorio',
            },
            ptoventa: {
                required: 'Obligatorio',
            },
            banco: {
                required: 'Obligatorio',
            },
            tipcaja: {
                required: 'Obligatorio',
            },
            tipo: {
                required: 'Obligatorio',
            },
            moneda: {
                required: 'Obligatorio',
            },
        },

        invalidHandler: function(event, validator) { //display error alert on form submit   
            $('.alert-danger', $('.generarPago')).show();
        },

        highlight: function(e) {
            $(e).closest('.form-group').removeClass('has-info').addClass('has-error');
        },

        success: function(e) {
            $(e).closest('.form-group').removeClass('has-error').addClass('has-info');
            $(e).remove();
        },

        submitHandler: function(form) {
            var formapago = $('#formapago').val();
            var tipcaja = $('#tipcaja').val();
            var totalpagar = $('#total').val();
            var montopagar = $('#monto').val();
            var moneda = $('#moneda').val();

            $.post('app/pagos/procesos/p.datosmoneda.php', 'moneda_ide=' + moneda, function(datomoneda) {
                datomoneda = JSON.parse(datomoneda);
                monto_fin = montopagar * (1 / datomoneda[0].moneda_valorconv);
                if (monto_fin <= totalpagar) {
                    console.log($('.generarPago').serialize());
                    $.post('p-pag-generarPago', $('.generarPago').serialize(), function(data) {
                        res = data.split(',');
                        if (res[0] == 1) {
                            var cedula = $('#ced').val();
                            cerrarAlerta('.mensaje1');
                            $('.formpago').val('');
                            $('.total').val(res[1]);
                            $('.dif').val(res[2]);
                            $('#monto').val(res[1]);
                            $('.tot_mon_extr').fadeOut(1);
                            load('pag-lista_pagos', $('.generarPago').serialize(), '.listapagos');
                            load('pag-cliente.historico', 'ced=' + cedula, '#cliente-historico');
                            $('.generarPago').each(function() {
                                this.reset();
                            });
                        } else {
                            alerta('.mensaje1', 'danger', data);
                        }
                    });
                } else {
                    alerta('.mensaje1', 'danger', "El monto a pagar debe ser menor al monto total");
                }
            });
        },
    });
});