<script type="text/javascript">
$(function(){

	$( ".fecha" ).datepicker({
		autoclose:true
	}).next().on(ace.click_event, function(){
		$(this).prev().focus();
	});

	var formulario = '.buscarcuadre';
	$(formulario).validate({
		errorElement: 'div',
		errorClass: 'help-block',
		focusInvalid: true,
		rules: {
			f_inic : {
				required: true,
				date: true
			},
			f_fin : {
				required: true,
				date: true
			},
			tipcaja: {
				required: true
			},
			tipo: {
				required: true,
			}
		},

		messages: {
			f_inic : {
				required: 'Obligatorio',
				date: 'Fecha no válida'
			},
			f_fin : {
				required: 'Obligatorio',
				date: 'Fecha no válida'
			},
			tipcaja: {
				required: 'Obligatorio',
			},
			tipo: {
				required: 'Obligatorio'
			}
		},

		invalidHandler: function (event, validator) { //display error alert on form submit   
			$('.alert-danger', $(formulario)).show();
		},

		highlight: function (e) {
			$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
		},

		success: function (e) {
			$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
			$(e).remove();
		},

		submitHandler: function (form) {
			$('#payments-paid, #billed').html('');
			var f_inicp= $("#f_inic").val();
			var f_finp= $("#f_fin").val();
			var caja=$("#tipcaja").val();
			if(f_inicp<=f_finp){
				if (['A', 'T'].includes($('#tipo').val())) {
					if ($('#detalle').val() === 'D') {
						load('app/reportes/vistas/payments_paid_detail.php',$(formulario).serialize(),'#payments-paid');
					} else {
						load('app/reportes/vistas/payments_paid.php',$(formulario).serialize(),'#payments-paid');
					}
				}
				if (['F', 'T'].includes($('#tipo').val())) {
					if ($('#detalle').val() === 'D') {
						load('app/reportes/vistas/billed_detail.php',$(formulario).serialize(),'#billed');
					} else {
						load('app/reportes/vistas/billed.php',$(formulario).serialize(),'#billed');
					}
				}
			}else{
				alerta('.msj','danger',"La fecha de Fin no puede ser menor a la de Inicio")
				$('.detalles-factura').fadeOut();  				  
			}
		},
		invalidHandler: function (form) {
		}
	});
})

function download(){
	var filters = $('form .filter');
	var empty = 0;
	var f_inicp= $("#f_inic").val();
	var f_finp= $("#f_fin").val();
	var caja=$("#tipcaja").val();
	var tipo=$("#tipo").val();
	var detalle=$("#detalle").val();

	for (let index = 0; index < filters.length; index++) {
		const element = filters[index];
		if (!element.value) {
			empty++;
		}
	}
	if (empty > 0) {
		alerta('.msj','danger',"Filtros requeridos");
		return;
	}

	if(f_inicp > f_finp){
		alerta('.msj','danger',"La fecha de Fin no puede ser menor a la de Inicio");
		return;
	}

	window.open('cuadrecaja-'+f_inicp+'/'+f_finp+'/'+caja+'/'+tipo+'/'+detalle);	
}
</script>

<div id="breadcrumbs" class="breadcrumbs">
	<script type="text/javascript">
	try{ace.settings.check('breadcrumbs' , 'fixed')}catch(e){}
	</script>
	<ul class="breadcrumb">
		<li><i class="icon-home home-icon"></i> <a href="#">Inicio</a></li>
		<li class="active"><i class="fa fa-money"></i> <a href="#">Pagos</a></li>
		<li class="active"> Cuadre de caja</li>
	</ul>
</div>
<div class="space-20"></div>
<div class="col-xs-3"></div>
<div class="msj"></div>
<div class="col-sm-12">
	<form class="buscarcuadre" autocomplete="off">
		<div class="col-sm-12">
			<div class="form-group col-md-4 col-sm-4">
				<label for="" class="control-label col-sm-12">
					<small>Fecha de Inicio:</small>
				</label>
				<div class="col-sm-10">
					<div class="input-group">
						<input type="text" name="f_inic" id="f_inic" class="fecha form-control filter" data-date-format="yyyy-mm-dd">
						<span class="input-group-addon">
							<i class="icon-calendar bigger-110"></i>
						</span>
					</div>
				</div>
			</div>
			<div class="form-group col-md-4 col-sm-4">
				<label for="" class="control-label col-sm-12">
					<small>Fecha de Fin:</small>
				</label>
				<div class="col-sm-10">
					<div class="input-group">
						<input type="text" name="f_fin" id="f_fin" class="fecha form-control filter" data-date-format="yyyy-mm-dd">
						<span class="input-group-addon">
							<i class="icon-calendar bigger-110"></i>
						</span>
					</div>
				</div>
			</div>
			<div class="form-group col-md-4 col-sm-4">
				<label for="" class="control-label col-sm-12">
					<small>Caja:</small>
				</label>
				<div class="col-sm-10">
					<select name="tipcaja" id="tipcaja" class="filter" style="width:100% !important">	
						<option value="">Seleccione...</option>
						<option value="Caja1">Caja1</option>
						<option value="Caja2">Caja2</option>
						<option value="T">Todos</option>
					</select>
				</div>
			</div>
		</div>
		
		<div class="col-sm-12">
			<div class="form-group col-md-4 col-sm-4">
				<label for="" class="control-label col-sm-12">
					<small>Tipo:</small>
				</label>
				<div class="col-sm-10">
					<select name="tipo" id="tipo" class="filter" style="width:100% !important">	
						<option value="">Seleccione...</option>
						<option value="A">Abonos</option>
						<option value="F">Facturadas</option>
						<option value="T">Todos</option>
					</select>
				</div>
			</div>

			<div class="form-group col-md-4 col-sm-4">
				<label for="" class="control-label col-sm-12">
					<small>Detalle:</small>
				</label>
				<div class="col-sm-10">
					<select name="detalle" id="detalle" class="filter" style="width:100% !important">
						<option value="R">Resumen</option>
						<option value="D">Detallado</option>
					</select>
				</div>
			</div>

			<div class="form-group col-md-4 col-sm-4" style="margin-top: 18px;">
				<button class="btn btn-primary"><i class="fa fa-search"></i></button>
				<button type="button" class="btn btn-danger" title="Imprimir" onclick="download()" >
					<i class="fa fa-file-pdf-o"></i>
				</button>
			</div>
		</div>
	</form>
</div>
<div class="clearfix"></div>
<div class="space-10"></div>

<div id="payments-paid"></div>
<div class="clearfix"></div>
<div id="billed"></div>