<?php require '../../../cfg/base.php';

$personData =  $mhistoria->datosPersonalesSelect($ced);
$proced =  $mpagos->treatmentPayment($ced);
$trtfact_rows  =  $mpagos->tratamientosFacturarTodos($ced);
$subTotal = 0;
$totalIva = 0;
$subTotalDebt = 0;
$totalDebtIva = 0;

$disabled = (empty($proced)) ? 'disabled' : '';

if (!empty($personData)) { ?>
    <div class="col-sm-3">
        <div class="pull-right">
            <span class="profile-picture">
			    <img src="<?php echo $chistoria->picture($ced).'?'.rand(1,1000) ?>"style="heigth:150px;height:150px">
            </span>  
        </div>
    </div>
    <div class="col-sm-9">
        <table class="tablaperfil">
            <caption>Datos del Cliente:</caption>
            <tr>
                <th>Razón Social:</th>
                <td><?php echo $personData[0]->pacien_nomraz ?></td>
            </tr>
            <tr>
                <th>Nro Identificación:</th>
                <td><?php echo $personData[0]->pacien_cedrif ?></td>
            </tr>
            <tr>
                <th>Fecha de Nacimiento:</th>
                <td><?php echo $fun->fecha($personData[0]->pacien_fechnac).' ('.$ccitas->edad($personData[0]->pacien_fechnac).') Años' ?></td>
            </tr>
        </table>
    </div>
    <div class="clearfix"></div>
    <div class="space-10"></div>
    <div class="msj1"></div>
    <div class="table-header">Procediminetos Pendientes Por Pagos</div>
    <table class="table table-striped table-hover table-bordered">
		<thead>
			<tr>
				<th><input type="checkbox" name="chk_todos" id="chk_todos" class="todos"></th>
				<th>Fecha</th>
				<th>Procedimiento</th>
				<th>Pieza (s)</th>
				<th>Costo</th>
				<th>Abonado</th>
				<th>Deuda</th>
			</tr>
		</thead>
		<tbody>
            <?php if (!empty($proced)) {
                foreach ($proced as $trtind => $trt) {
                    $precio     =  $trt->precio * $trt->proced_cantidad;
					//$preciofin  = ($trt->iva==1) ? $precio : ($precio/('1.'.$_SESSION['iva']));
					$preciofin  = $precio;
                    $paymentMont = $trt->pago_mon + $trt->pago_descu;
                    $deuda = $preciofin - $paymentMont;
                    $grupo = $modonto->selectAgrupados($trt->diagcons_ide);

                    $subTotal += $preciofin;
                    $totalIva += ($trt->iva == 0) ? $preciofin + (($preciofin * $_SESSION['iva']) / 100) : $preciofin;
                    $subTotalDebt += $deuda;
                    $totalDebtIva += ($trt->iva == 0) ? $deuda + (($deuda * $_SESSION['iva']) / 100) : $deuda;

                    $proced = [
                        'cost' => $deuda,
                        'ced' => $ced,
                        'id' => $trt->trat_ide
                    ]
                ?>
                    <tr> 
						<td>
                            <input name="proced_pagar[]" type="checkbox" class="check_proced" data-proced="<?php echo htmlspecialchars(json_encode($proced), ENT_QUOTES); ?>">
                        </td>
						<td>
                            <?php echo $fun->fecha($trt->diagcons_fecha); ?>
                        </td>
						<td>
                            <?php echo $trt->proced_des; ?>
                        </td>
						<td>
							<?php
                                echo $codonto->piezas($trt->diagcons_numero,$trt->diagcons_fin,$trt->diagcons_clase);
								if (!empty($grupo)) {
                                    foreach($grupo as $g) {
                                        echo ', '.$codonto->piezas($g->diagcons_numero,$g->diagcons_fin,$g->diagcons_clase);
                                    }
                                }
							?>
						</td>
						<td>
                            <?php echo number_format($preciofin, 2, ',', '.');  ?>
                        </td>
                        <td>
                            <?php echo number_format($paymentMont ?: 0, 2, ',', '.');  ?>
                        </td>
					    <td style="background-color: #ff000063;">
                            <?php echo number_format($deuda,2,',','.') ?>
                        </td>  
					</tr>
                <?php } ?>
                <tr>
                    <td colspan="4"> <span class="pull-right bolder">Sub-Total:</span></td>
                    <td><p id="subtotal"><?php echo number_format($subTotal, 2, ',', '.'); ?></p></span></td>
                    <td>&nbsp;</td>
                    <td><p id="subtotal"><?php echo number_format($subTotalDebt, 2, ',', '.'); ?></p></span></td>
                </tr>
                <tr>
                    <td colspan="4"> <span class="pull-right bolder">IVA:</span></td>
                    <td><?php echo number_format($_SESSION['iva'], 2, ',', '.'); ?></span></td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                </tr>
                <tr>
                    <td colspan="4"> <span class="pull-right bolder">Total:</span></td>
                    <td><?php echo number_format($totalIva, 2, ',', '.'); ?></td>
                    <td>&nbsp;</td>
                    <td><?php echo number_format($totalDebtIva, 2, ',', '.'); ?></td>
                </tr>
                <tr style="border-left: hidden; border-right: hidden; border-bottom: hidden;">
                    <td colspan="7" style="background-color: #fff;">
                        <div class="pull-right">
                            <button type="button" class="btn btn-info" id="btn-pagos" value="0" <?php echo $disabled; ?>>
                                <i class="fa fa-check"></i> 
                                Formas de Pago
                            </button>
                            <button type="button" class="btn btn-danger" id="generate-pdf">
                                <i class="fa fa-file-pdf-o"></i> 
                                Abonos
                            </button>
                        </div>
                    </td>
                </tr>
            <?php } else {?>
                <div class="alert alert-info">
                    <strong>No Tiene Procediminetos Pendientes Por Pagos.</strong>
                </div>
            <?php } ?>
        </tbody>
    </table>
<?php } else { ?>
    <div class="alert alert-danger"><button class="close" data-dismiss="alert" type="button"><i class="icon-remove"></i></button>El paciente no se encuentra registrado</div>
<?php }

if(count($trtfact_rows)>0){  ?>
    <form class="facturar">	
        <br><br>
        <div class="table-header">Procesos Para Realizar Factura</div>
            <table class="table table-striped table-hover table-bordered">
            <thead>
                <tr>
                    <th></th>
                    <th>Procedimiento</th>
                    <th>Costo</th>
                    <th>Detalle Pago</th>
                </tr>
            </thead>
            <tbody>
                <?php if(count($trtfact_rows)>0) { ?>
                    <?php foreach($trtfact_rows as $trtifac=>$trtfac) { ?>
                        <?php 
                            $totalPagado = $mpagos->pagosTratamiento($trtfac->trat_ide); 
                            //echo 'PAGADO = '.$totalPagado;
                        ?>
                        <tr class="tr_check_proced">
                            <td><input name="proced_pagar2[]" type="checkbox" class="check_proced2" id="check_proced<?php echo $trtifac ?>" value="<?php echo $trtfac->trat_ide ?>" checked onclick="return false" ></td>
                            <td><?php echo $trtfac->proced_des ?></td>
                            <td><?php echo number_format($totalPagado, 2, ',', '.') ?></td>
                    <td>
                    <button type="button" class="btn btn-success btn-xs" title="Detalle de pago" onclick="modal('app/pagos/vistas/pagos.borrar.todos.php','ced=<?php echo $ced ?>&tratamiento_ide=<?php echo $trtfac->trat_ide ?>')">
                        <i class="fa fa-toggle-right"></i>
                    </button>
                    </td>

                        </tr>
                    <?php } ?>
                    <tr>
                        
                        <td colspan="2"><span class="pull-right bolder"> Total:</span></td>
                        <td><span class="pull-center"></span><?php echo number_format($mpagos->sumsubtotalpagados($ced,1,$_SESSION['iva']),2, ',', '.'); ?></td>
                    </tr>
                    <tr>
                        <td colspan="2"> <span class="pull-right bolder"> Descuento:</span></td>
                        <td><span class="pull-center" id="tex-decuf"><?php echo number_format($mpagos->verificarTratamientopagdescu($ced), 2, ',', '.'); ?></span></td>
                    </tr>
                    <tr>
                        <?php  $totalfact=($mpagos->sumsubtotalpagados($ced,1,$_SESSION['iva'])-$mpagos->verificarTratamientopagdescu($ced)); ?>
                        <td colspan="2"> <span class="pull-right bolder">Total:</span></td>
                        <td><span class="pull-center"  id="tex-totalf"><?php echo number_format($totalfact, 2, ',', '.'); ?></span></td>
                    </tr>
            </table>
            <?php } else { ?>
                <div class="alert alert-info">
                    <strong>No hay procedimientos por facturar.</strong>
                </div>
            <?php } ?>
        <div class="text-right">
            <button class="btn btn-info" <?php echo (count($trtfact_rows)==0) ? 'disabled' : null ?> title="Procesar Factura">
                <i class="fa fa-print fa-2x"></i> 
                Procesar Factura
            </button>
        </div>

        <input type="hidden" name="cedfact" id="cedfact" value="<?php echo $ced ?>">
        <input type="hidden" name="subtotalfactexe" id="subtotalfactexe" value="<?php echo $mpagos->sumsubtotalpagados($ced,1,$_SESSION['iva']); ?>">
        <input type="hidden" name="subtotalfactiva" id="subtotalfactiva" value="<?php echo $mpagos->sumsubtotalpagar($ced,0,$_SESSION['iva']); ?>">
        <input type="hidden" name="descuento_total" id="descuento_total" value="<?php echo $mpagos->verificarTratamientopagdescu($ced); ?>">
        <input type="hidden" name="subtotalivafact" id="subtotalivafact" value="<?php echo $mpagos->sumivapagados($ced,$_SESSION['iva']); ?>">
        <input type="hidden" name="totalfact_f" id="totalfact_f" value="<?php echo $totalfact; ?>">
    </form> <!-- Fin de facturacion -->
<?php } ?>

<script src="app/pagos/vistas/js/client_history.js"></script>
<script>
    $(document).ready(function () {
        //chk_todos
        $('#generate-pdf').on('click', function () {
            let all = '';
            let ids = [];
            let ced = '';
            $('.check_proced').each(function (index, element) {
                const data = $(element).data('proced');
                ced = data.ced;
                if ($(element).is(':checked')) {
                    ids.push(data.id);
                }
            });
            if ($('#chk_todos').is(':checked')) {
                all = 'all';
            }
            if (!all && ids.length == 0) {
                alerta('.msj1','danger','Debe seleccionar al menos un procedimiento');
                return false;
            }
            window.open('abonos-'+(ids.length > 0 ? ids : 'all')+'-'+ced);
        });
    });
</script>