<?php 
class mPagos {

	protected $dbh,$con,$msj;

	function __clone() {

	} #clone

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	} #construct
	
	function getBancos() {
		$sql = "SELECT * from tbl_bancos order by bancos_nombre asc";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function getPtoVenta() {
		$sql = "SELECT * from tbl_ptoventa";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function getFormasPagos() {
		$sql = "SELECT * FROM tbl_formpagos order by formpagos_nombre asc";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	} 

	function tratamientosPagarTodos($cedrif) {
		$sql = "SELECT * FROM vw_tratamientopagar
				WHERE trat_est between '0' and '1' and diagcons_paciente=? order by diagcons_fecha desc";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function sumsubtotalpagar($cedrif,$op,$iva) {
		$sql = "SELECT fn_sumsubtotal(?,?,?) as total";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->bindParam(2,$op);
		$res->bindParam(3,$iva);
		$res->execute();
		$total = $res->fetchAll(PDO::FETCH_OBJ);
		$rt = (!empty($total)) ? $total[0]->total : 0;
		return $rt;
    }

    function sumivapagar($cedrif,$iva) {
		$sql = "SELECT fn_ivapagar(?,?) as total";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->bindParam(2,$iva);
		$res->execute();
		$total = $res->fetchAll(PDO::FETCH_OBJ);
		$rt = $total[0]->total;
		return $rt;
    }

    function procedimientosPagarTotal($form) {
		$acumulador = 0; # Lleva la suma total de todos los procedimientos a pagar.
		for($x=0; $x<=$form['totalproced']; $x++) {
			$ind = (isset($form['proced_pagar'.$x.''])) ? $form['proced_pagar'.$x.''] : null;
			#Obtenemos los saldos
			$monto = $this->pagosTratamiento($ind);
			$precio = $this->precioTratamiento($ind);
			# Obtenemos el saldo deudor del tratamiento;
			$deudor = $precio-$monto;
			# Acumulamos el resultado para sumar todos los tratamientos
			$acumulador = $acumulador+abs($deudor);
		}
		return $acumulador;
	}

	function procedimientosTotalDescu($form) {
		$acumulador = 0; # Lleva la suma total de todos los procedimientos a pagar.
		for($x=0; $x<=$form['totalproced']; $x++) {
			$ind = (isset($form['proced_pagar'.$x.''])) ? $form['proced_pagar'.$x.''] : null;
			#Obtenemos los saldos
			$precio = $this->precioTratamiento($ind);
			# Obtenemos el saldo deudor del tratamiento;
			$deudor = $precio;
			# Acumulamos el resultado para sumar todos los tratamientos
			$acumulador = $acumulador+abs($deudor);
		}
		return $acumulador;
	}

	function detallePagoTratamiento($tratamiento_ide) {
		$sql = "SELECT SUM(pago_mon+pago_descu) as total, pago_moneda as moneda from tbl_pagos where trat_ide=? GROUP BY trat_ide";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$tratamiento_ide);
		$res->execute();
		// Obtenemos el monto cancelado
		if($res->rowCount()>0) {
			$monto = $res->fetchAll(PDO::FETCH_OBJ);
			$total = $monto[0]->total;
			$moneda = $monto[0]->moneda;
			$datamoneda = $this->datamoneda($moneda);
			$pagado = $total * (1 / $datamoneda[0]->moneda_valorconv);
			$rt = $pagado;
		} else {
			$rt = 0;
		}
		return $rt;
  	}

  	function pagosTratamiento($tratamiento_ide) {
		$pagado = 0;
		$sql = "SELECT SUM(pago_mon+pago_descu) as total from tbl_pagos where trat_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$tratamiento_ide);
		$res->execute();
		// Obtenemos el monto cancelado
		if($res->rowCount()>0) {
			$monto = $res->fetchAll(PDO::FETCH_ASSOC);
			/*foreach ($monto as $m) {
				$total = $m->total;
				$moneda = $m->moneda;
				$datamoneda = $this->datamoneda($moneda);
				$pagado = $pagado + ($total * (1 / $datamoneda[0]->moneda_valorconv));
			}
			$rt = $pagado;*/
			$rt = $monto[0]['total'];
		} else {
			$rt = 0;
		}
		return $rt;
  	}

  	function precioTratamiento($tratamiento_ide) {
		$sql = "SELECT (proced_prec * proced_cantidad) as total from tbl_tratamiento where trat_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$tratamiento_ide);
		$res->execute();
		# Obtenemos el precio del tratamiento
		if($res->rowCount()>0) {
			$monto = $res->fetchAll(PDO::FETCH_OBJ);
			$rt = $monto[0]->total;
		} else {
			$rt = 0;
		}
		return $rt;
	}

	function datamoneda($ide) {
		$sql = "SELECT * FROM tbl_moneda WHERE moneda_ide = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

  	function cantidadTratamiento($tratamiento_ide) {
		$sql = "SELECT proced_cantidad as cantidad from tbl_tratamiento where trat_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$tratamiento_ide);
		$res->execute();
		# Obtenemos el precio del tratamiento
		if($res->rowCount()>0) {
			$cant = $res->fetchAll(PDO::FETCH_OBJ);
			$rt = $cant[0]->cantidad;
		} else {
			$rt = 0;
		}
		return $rt;
	}

	function listaDetalleTraProced($tratamiento_ide) {
		$sql = "SELECT * FROM vw_selectdestraproced WHERE trat_ide=?";
		    $res = $this->con->prepare($sql);
		    $res->bindParam(1,$tratamiento_ide);
		    $res->execute();
		    $rt = $res->fetchAll(PDO::FETCH_OBJ);
		    return $rt;
	}

	function listaDetallePagos($tratamiento_ide) {
		$sql = "SELECT * FROM vw_selectdetallepago WHERE trat_ide=?";
		    $res = $this->con->prepare($sql);
		    $res->bindParam(1,$tratamiento_ide);
		    $res->execute();
		    $rt = $res->fetchAll(PDO::FETCH_OBJ);
		    return $rt;
	}  
	function datomoneda($ide) {
		$sql = "SELECT * FROM tbl_moneda WHERE moneda_ide = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}    

    function generarPago($evolutionId = null) {
		$this->con->beginTransaction();
		$uno = 0;
		$dos = 0;
		$fecha=date('Y-m-d H:i:s');
		$procedurePay = (isset($this->proced_pagar) && !empty($this->proced_pagar)) ? json_decode($this->proced_pagar, true) : null;
		$totalproced= count($procedurePay);
		$total_pag =$this->total; //resultado de la sumatoria de los tratamientos seleccionados
		$totalPercentageDiscount = (isset($this->tipodesc) && !empty($this->tipodesc)) ? $this->total_percentage_discount : 0;
		$amountDiscount = (isset($this->porc) && !empty($this->porc)) ? $this->porc : 0; // Motonto del descuento dado
		$mondesu  = ($totalPercentageDiscount > 0) ? $totalPercentageDiscount : $amountDiscount;
		$moneda = $this->moneda; // Moneda en la que se hace el pago
		$descudiv  = ($mondesu/$totalproced); // Monto del descuento dado dividido por cantidad de tratamientos
		$monto_pagabs  = (isset($this->monto_pagar) && !empty($this->monto_pagar)) ? abs($this->monto_pagar) : 0; // Monto procedimiento a apagar por el paciente
		$dato_mon = $this->datomoneda($moneda);
		$baseCurrency = $this->baseCurrency();
		
		if ($dato_mon[0]->moneda_valorconv != $baseCurrency[0]->moneda_valorconv) {
			$monto_pagabs = ($monto_pagabs / $dato_mon[0]->moneda_valorconv);
			$descudiv = ($descudiv > 0) ? $descudiv / $dato_mon[0]->moneda_valorconv : $descudiv;
		}
		$dife = 0;
		$residuo = 0;
		$monto_prin = 0;
		$amount = 0;
		$difference = 0;

        for($x=0; $x< $totalproced; $x++) {
			$monto_prin = ($residuo > 0) ? $residuo : $monto_pagabs;
			$ind  = $procedurePay[$x];

			if ($ind!=null) { // Si no hay procedimiento
				$precio   = $this->precioTratamiento($ind);
				$deuda  = $this->verificardeudaTratamiento($ind);
				//$dedudecu = $this->verificardeudaTratamientodescu($ind);
				$yapagado = $this->fn_verificartratamientopagado($ind);
				$yapagado = (isset($yapagado)) ? $yapagado : 0; 
		    
				if($yapagado==0) { // No esta pagado
                    /* Si el monto del pago se acabo salga del proceso
                    if ($monto_fin<0) {
                    	break;
                    }*/
				    $dife = ($deuda > 0) ? $deuda - ($monto_prin + $descudiv) : $precio - ($monto_prin + $descudiv);
					$amount = $monto_prin;
					$difference = $dife;
					if ($deuda > 0 && $monto_prin >= $deuda) {
						$amount = $deuda;
						$difference = 0;
					}
					$banco = !empty($this->banco) ? $this->banco : null;
					$numRef = !empty($this->num_ref) ? $this->num_ref : null;
					$ptoVenta = !empty($this->ptoventa) ? $this->ptoventa : null;
					$motivo = !empty($this->motivo) ? $this->motivo : null;

					$sql = "INSERT INTO tbl_pagos values (null,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
					$res = $this->con->prepare($sql);
					$res->bindParam(1,$ind);
					$res->bindParam(2,$this->tipo);
					$res->bindParam(3,$banco);
			        $res->bindParam(4,$numRef);
					$res->bindParam(5,$ptoVenta);
					$res->bindParam(6,$precio);
					$res->bindParam(7, $amount);
					$res->bindParam(8, $difference);
					$res->bindParam(9,$fecha);
					$res->bindParam(10,$this->tipcaja);
					$res->bindParam(11,$descudiv);
					$res->bindParam(12,$motivo);
					$res->bindParam(13,$moneda);
					$res->bindParam(14,$baseCurrency[0]->moneda_ide);
					$res->bindParam(15,$dato_mon[0]->moneda_valorconv);
					$res->bindParam(16,$evolutionId);
					$uno = $tres = ($res->execute()==1) ? 1 : $this->msj[] = print_r($res->errorinfo());
					$id=$this->con->lastInsertId();
					$this->dbh->sp_auditoria($_SESSION['ced'],1,'tbl_pagos',$id);
					
			/* Actualizo el estaus del tratamiento a facturado*/
					if ($dife > 0) {
						$dos = 1;
						break;
					}
			        $sql = "UPDATE tbl_tratamiento set trat_est=2 where trat_ide=?";
					$res = $this->con->prepare($sql);
					$res->bindParam(1,$ind);
					$dos = ($res->execute()==1) ? 1 : $this->msj[] = print_r($res->errorinfo());
					$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_tratamiento',$ind);
					$residuo = abs($dife);	
	            } // Fin de no esta pagado
	        }// Fin si ni hay procedimiento    
	    }// Fin del for
		
		if ($uno==1 and $dos==1){
			$this->con->commit();
			$rt = 1;
			$resultados = $rt.','.abs($difference).','.abs($residuo);
		}else{
			$this->con->rollBack();
			$rt = "Error al generar el pago, por favor verifique";
			$resultados = $rt;
		}

		return $resultados;
	}

	function verificardeudaTratamiento($tratamiento_ide) {
		$sql = "SELECT MIN(pago_dev) as total from tbl_pagos where trat_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$tratamiento_ide);
		$res->execute();
		$monto = $res->fetchAll(PDO::FETCH_OBJ);
		
		// Obtenemos el monto cancelado
		if($monto[0]->total>0) {
		    $rt = $monto[0]->total;	
		} else {
			$rt = 0;
		}
		return $rt;
  	}

  	function verificardeudaTratamientodescu($tratamiento_ide) {
		$sql = "SELECT pago_descu from tbl_pagos where trat_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$tratamiento_ide);
		$res->execute();
		$montod = $res->fetchAll(PDO::FETCH_OBJ);
		
		// Obtenemos el monto del descuento
		if(isset($montod[0]->pago_descu)) {
		    $rt = $montod[0]->pago_descu;	
		} else {
			$rt = 0;
		}
		return $rt;
  	}

  	function verificarTratamientopagdescu($cedrif) {
		$sql = "SELECT SUM(pago_descu) as total from selecttratarealfactproce where diagcons_paciente=? and trat_est=2";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		$montod = $res->fetchAll(PDO::FETCH_OBJ);
		
		// Obtenemos el monto del descuento
		if(isset($montod[0]->total)) {
		    $rt = $montod[0]->total;	
		} else {
			$rt = 0;
		}
		return $rt;
  	}

  	function verificarTratamientopagdescufact($cedrif,$nrofact) {
		$sql = "SELECT SUM(pago_descu) as total from selecttratarealfactproce where diagcons_paciente=? and trat_est=3 and fact_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->bindParam(2,$nrofact);
		$res->execute();
		$montod = $res->fetchAll(PDO::FETCH_OBJ);
		
		// Obtenemos el monto del descuento
		if(isset($montod[0]->total)) {
		    $rt = $montod[0]->total;	
		} else {
			$rt = 0;
		}
		return $rt;
  	}
    
    function fn_verificartratamientopagado($tratamiento_ide) {
		$sql = "SELECT fn_verificartratamientopagado(?) as total";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$tratamiento_ide);
		$res->execute();
		$monto = $res->fetchAll(PDO::FETCH_OBJ);

		// Obtenemos el monto cancelado
		if(!empty($monto) && $monto[0]->total>0) {
			$rt = $monto[0]->total;
		} else {
			$rt = 0;
		}
		return $rt;
  	}

  	function borrarPagos() {
		$sql = "DELETE FROM tbl_pagos WHERE pago_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->pago_ide);
		if($res->execute()==true) {
			$sql = "UPDATE tbl_tratamiento set trat_est=1 where trat_ide=?";
			$res = $this->con->prepare($sql);
		    $res->bindParam(1,$this->idpro);
		}

		if($res->execute()==true) {
			//$this->con->commit();
			$this->dbh->sp_auditoria($_SESSION['ced'],3,'tbl_pagos',$this->idpro);
			$rt = 1;
		} else {
		    //$this->con->rollBack();
			$rt = 'Error';
		}
		return $rt;
	}

	function tratamientosFacturarTodos($cedrif) {
	    $sql = "SELECT * FROM selecttratarealfact WHERE diagcons_paciente=? 
			    ORDER BY trat_ide asc";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function sumsubtotalpagados($cedrif,$op,$iva) {
		$sql = "SELECT fn_tratamientospagados(?,?,?) as total";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->bindParam(2,$op);
		$res->bindParam(3,$iva);
		$res->execute();
		$total = $res->fetchAll(PDO::FETCH_OBJ);
		$rt = (!empty($total)) ? $total[0]->total : 0;
		return $rt;
    }

    function sumivapagados($cedrif,$iva) {
		$sql = "SELECT fn_ivapagados(?,?) as total";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->bindParam(2,$iva);
		$res->execute();
		$total = $res->fetchAll(PDO::FETCH_OBJ);
		$rt = (!empty($total)) ? $total[0]->total : 0;
		return $rt;
    }

    function restaurarpagos($tratamiento_ide) {
		$sql = "SELECT fn_restaurarpagos(?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$tratamiento_ide);
		return ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
    }

    function generarFact() { 		
     	$sql = "INSERT INTO tbl_factura
                VALUES (null,now(), ?, ?, ?, 0, ?, ?, 0, 0)";
	     $res = $this->con->prepare($sql);
	     $res->bindParam(1,$this->subtotalfactexe);
	     $res->bindParam(2,$this->subtotalfactiva);
	     $res->bindParam(3,$this->descuento_total);
	     $res->bindParam(4,$this->subtotalivafact);
	     $res->bindParam(5,$this->totalfact_f);
	     $uno = ($res->execute()==1) ? 1 : $this->msj[] = print_r($res->errorinfo()); 
          
       if($uno==1) {
	          $nro_fact=$this->con->lastInsertId();
	          for($x=0; $x < count($_POST['proced_pagar2']); $x++) {
	            $sql = "UPDATE tbl_tratamiento set trat_est=3, fact_ide=? where trat_ide=?"; 
	            $res = $this->con->prepare($sql);
		        $res->bindParam(1,$nro_fact);
		        $res->bindParam(2,$_POST['proced_pagar2'][$x]);
		        $dos = ($res->execute()==1) ? 1 : $this->msj[] = print_r($res->errorinfo());
		        // if ($dos==1) {
		        // 	$sql = "SELECT fn_actualizaexisproduc(?)";
		        // 	$res = $this->con->prepare($sql);
		        // 	$res->bindParam(1,$_POST['proced_pagar2'][$x]);
		        // 	$tres = ($res->execute()==1) ? 1 : $this->msj[] = print_r($res->errorinfo());
		        // }
		      }
		} else {
			$rt = 0;
		}
		if ($uno==1 && $dos==1 /* && $tres==1*/) {
			$rt=$nro_fact;
		}else{
		    $rt = 0;
		}
		return $rt; 
	}

    public function buscarCuadre() {
		$whereFact = (isset($this->cuadre_caja) && !empty($this->cuadre_caja)) ? ' AND fact_ide IS NOT NULL' : '';
		$valcaja=($this->tipcaja=='T') ? '%' : $this->tipcaja;
		$sql = "SELECT fact_ide FROM selectcuadrecaja WHERE date(pago_hor) between ? and ? and pago_caja like ?".$whereFact;
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->f_inic);
		$res->bindParam(2,$this->f_fin);
		$res->bindParam(3,$valcaja);
		$res->execute();
		$rt = $res->rowCount()>0;
		return $rt;
	}
    
    function deudorTratamiento($tratamiento_ide) {
		$monto    = $this->pagosTratamiento($tratamiento_ide);
		/*$precio   = $this->precioTratamiento($tratamiento_ide);
		$cantidad = $this->cantidadTratamiento($tratamiento_ide);
		$deudor   = ($precio*$cantidad)-$monto;*/
		return $monto;  //$deudor;
	}

	function insertContadorDescInv(){
		$rows = $this->tratamientosFacturarTodos($this->cedfact);
		// var_dump($rows);
       // Aqui realizo un for para la cantidad de productos
       if(count($rows) > 0):
	       foreach ($rows as $r) : // para traer la cantidad y los estados de cada uno

		       	for ($i=0; $i < $r->proced_cantidad ; $i++) {        
			       	$sql1   = "SELECT * from tbl_receta where receta_proc_ide=?";
			       	$res1   = $this->con->prepare($sql1);
			       	$res1->bindParam(1,$r->proced_ide);
			       	$res1->execute();
			       	$receta = $res1->fetchAll(PDO::FETCH_OBJ);

		            if ($r->trat_est != 3) { // Si el tratamiento es facturado
				            // Aqui realizo un forreach para los productos en la receta  poder sumar 
		            	foreach($receta as $m) {
		            		$sql2 = "SELECT * from tbl_contador_aplicaciones where contador_material = ?";
		            		$res2 = $this->con->prepare($sql2);
		            		$res2->bindParam(1,$m->receta_produc_ide);
		            		$res2->execute();
		            		$tot2 = $res2->fetchAll(PDO::FETCH_OBJ);
								//print_r(count($tot2));

				                    // Aqui comparo y veo se el contador de aplicaciones exite lo vreo o le sumo si esta ya creado
		            		if (count($tot2)==0 && $m->receta_produc_ide!=1) {
		            			$sql = "INSERT INTO tbl_contador_aplicaciones VALUES (null,?,?,1)";
		            			$res = $this->con->prepare($sql);
		            			$res->bindParam(1,$r->trat_ide);
		            			$res->bindParam(2,$m->receta_produc_ide);
		            			$result = ($res->execute()==true) ? $this->con->lastInsertId('tbl_contador_aplicaciones') : print_r($res->errorInfo());
		            		}elseif (count($tot2)>0 && $m->receta_produc_ide!=1) {
		            			$sql_produc_conta = "UPDATE tbl_contador_aplicaciones set contador_suma = contador_suma + 1 where contador_material = ?";
		            			$res_produc_conta = $this->con->prepare($sql_produc_conta);
		            			$res_produc_conta->bindParam(1,$m->receta_produc_ide);
		            			$re = $res_produc_conta->execute();
						    }// Fin del if

					        if($m->receta_produc_ide!=1){  
			                        // Aqui reviso si esta mayor el contador para blanquear o no
					           	$sql_suma = "SELECT contador_suma as suma, produc_aplicac as aplicaciones from tbl_contador_aplicaciones as a, tbl_producto as b where a.contador_material = ? and b.produc_ide = ?";
					           	$res_suma = $this->con->prepare($sql_suma);
					           	$res_suma->bindParam(1,$m->receta_produc_ide);
					           	$res_suma->bindParam(2,$m->receta_produc_ide);
					           	$res_suma->execute();
					           	$suma = $res_suma->fetchAll(PDO::FETCH_OBJ);

					           	if ($suma[0]->suma >= $suma[0]->aplicaciones) {
											// Aqui si es mayor o igual pongo en cero en contador
					           		$sql_produc_conta = "UPDATE tbl_contador_aplicaciones set contador_suma = 0 where contador_material = ?";
					           		$res_produc_conta = $this->con->prepare($sql_produc_conta);
					           		$res_produc_conta->bindParam(1,$m->receta_produc_ide);
					           		return $res_produc_conta->execute();

											// Aqui resto a los materiales
					           		$sql_produc = "UPDATE tbl_producto set produc_existen = produc_existen-1  where produc_ide = ?";
					           		$res_produc = $this->con->prepare($sql_produc);
					           		$res_produc->bindParam(1,$m->receta_produc_ide);
					           		$res_produc->execute();
					            }// Fin if
					            
					            
					    	} // Fin de if        
						}// Fin del foreach          
					}// Fin del if del estado	    
		        }// Fin del For
			endforeach;
		endif;
	}// Fin de la function

	function treatmentPayment($cedrif) {
		$sql = "SELECT
				vtt.*,
				tpg.pago_tot,
				SUM(tpg.pago_mon) AS pago_mon,
				SUM(pago_descu) AS pago_descu
			FROM
				vw_tratamientopagar AS vtt
				LEFT JOIN tbl_pagos AS tpg ON vtt.trat_ide = tpg.trat_ide 
			WHERE
				trat_est IN ( 0, 1 ) 
				AND diagcons_paciente = ?
			GROUP BY
				trat_ide 
			ORDER BY
				diagcons_fecha DESC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	public function numberTreatments($cedrif) {
		$sql = "SELECT trat_ide FROM vw_tratamientopagar
				WHERE trat_est between '0' and '1' and diagcons_paciente=? order by diagcons_fecha desc";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->rowCount();
	}
	function baseCurrency() {
		$sql = "SELECT moneda_ide, moneda_valorconv FROM tbl_moneda WHERE moneda_principal = 1";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
	public function verifyDebt($treatmentId)
	{
		return $arrDebt = $this->treatmentDebt($treatmentId);
	}
	public function treatmentDebt($treatmentId)
	{
		$sql = "SELECT pago_mon, pago_moneda, moneda_base_id, tasa_conversion from tbl_pagos where trat_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$treatmentId);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_ASSOC);
	}
	public function abonosPorPaciente($ced, $procedimientos)
	{
		$sql = "SELECT
				tr.trat_ide,
				pc.proced_des AS proced_des,
				dc.diagcons_numero AS diagcons_numero,
				dc.diagcons_fin AS diagcons_fin,
				dc.diagcons_clase AS diagcons_clase,
				tp.pago_ide,
				tp.pago_tot,
				tp.pago_mon,
				tp.pago_descu,
				tp.pago_hor,
				tp.pago_dev
			FROM
				tbl_tratamiento AS tr
				JOIN tbl_diagcons AS dc ON tr.diagcons_ide = dc.diagcons_ide
				JOIN tbl_proced AS pc ON tr.proced_ide = pc.proced_ide
				JOIN tbl_diagno dg ON dc.diagcons_diagnostico = dg.diagno_codigo
				JOIN tbl_pagos AS tp ON tr.trat_ide = tp.trat_ide 
			WHERE
				tr.trat_est IN ( 0, 1 ) 
				AND dc.diagcons_paciente = ? ";
		if (!empty($procedimientos)) {
			$sql.=" AND tr.trat_ide IN($procedimientos)";
		}
		$sql.= "ORDER BY
				tp.pago_hor";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ced);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_ASSOC);
	}
}