<?php 
require '../../../cfg/base.php';
error_reporting(0);
$proced = $modonto->allProcedures($cedrif);

if(!empty($proced)) { ?>
<div class="table-header bolder">Todos los Procedimientos
	<span class="pull-right padding-r20">
		<button type="button" onclick="window.open('presupuesto-<?php echo $cedrif ?>')" class="btn btn-minier btn-info">Imprimir</button>
	</span>
</div>
<table class="table table-hover table-bordered table-striped">
	<thead>
		<tr>
			<th>Pieza y Procedimiento</th>
			<th>Odontol&oacute;go</th>
			<th>Cantidad</th>
			<th>Costo</th>
			<th>Abonado</th>
			<th>Deuda</th>
			<th>Estado</th>
			<th>Condición</th>
			<th style="width:110px">Opciones</th>
		</tr>
	</thead>
	<tbody>
		<?php foreach($proced as $d) {
			$pieces = $codonto->piezas($d->diagcons_numero,$d->diagcons_fin,$d->diagcons_clase);
			$disabled =  ($d->trat_est == 3) ? 'disabled' : ''; 
			$titulo =  ($d->trat_est == 3) ? 'Ver Evoluciones' : 'Agregar Evoluciones';
			$total= ($d->precio * $d->proced_cantidad);
			$payment = (!empty($d->pago_mon)) ? $d->pago_mon : 0;
			$debt = $total - $payment;
		?>
			<tr>
				<td><?php echo $pieces.' '.$d->proced_des; ?></td>
				<td><?php echo $d->pacien_nomraz; ?></td>
				<td><?php echo $d->proced_cantidad; ?></td>
				<td><?php echo number_format($total,2,",","."); ?></td>
				<td><?php echo number_format($payment,2,",","."); ?></td>
				<td><?php echo number_format($debt,2,",","."); ?></td>
				<td><?php echo $codonto->estadoProcedimiento($d->trat_est); ?></td>
				<td><?php echo $codonto->condicionProced($d->trat_est,$d->trat_status); ?></td>
				<td>
					<div class="action-buttons">
						<?php if($d->trat_status==0) {
							if($d->trat_est>=0 and $d->trat_est<=1) { ?>	
								<button class="btn btn-success btn-xs" title="Cambiar de Estado" onclick="cambiarEstado('trat_ide=<?php echo $d->trat_ide ?>&estado=<?php echo $codonto->estadoValor($d->trat_est); ?>'); return false;">
								<i class="icon-exchange bigger-110 icon-only"></i>
								</button>
							<?php }
							if (empty($d->pago_mon) && empty($d->evol_ide)) { ?>
								<button <?php echo $disabled ?> class="btn btn-danger btn-xs" title="Borrar" onclick="borrarProcedimiento('trat_ide=<?php echo $d->trat_ide ?>'); return false;">
									<i class="icon-trash bigger-110 icon-only"></i>
								</button>
							<?php }
						}
						if(($d->trat_est>=1 and $d->trat_est<=3) && $d->trat_status==0) { ?>
								<button class="btn btn-info btn-xs"  title="Agregar Evoluciones" onclick="modal('app/odonto/vistas/evolucion.php','trat_ide=<?php echo $d->trat_ide ?>&cedrif=<?php echo $cedrif ?>&des=<?php echo $pieces.'-'.$d->diagno_descrip ?>&diagno=<?php echo $d->diagcons_ide ?>&prec=<?php echo $debt ?>'); return false;">
								<i class="fa fa-external-link"></i>
								</button>
						<?php }
						if($d->trat_est==4 and $d->trat_status==1) { ?>
								<button class="btn btn-inverse btn-xs" title="Ver Evoluciones" onclick="modal('app/odonto/vistas/evolucionVer.php','trat_ide=<?php echo $d->trat_ide ?>&cedrif=<?php echo $cedrif ?>&des=<?php echo $pieces.'-'.$d->diagno_descrip ?>&diagno=<?php echo $d->diagcons_ide ?>&prec=<?php echo $debt ?>'); return false;">
								<i class="fa fa-flag-checkered"></i>
								</button>
						<?php } ?>
					</div>
				</td>
			</tr>
		<?php } ?>
	</tbody>
</table>
<?php } else { ?>
	<div class="alert alert-info">
		<strong>No hay procedimientos registrados.</strong>
	</div>
<?php } ?>
<div class="clearfix"></div>
<script>
	function borrarProcedimiento(ide) {
		if(confirm('¿Desea borrar el procedimiento?')==true) {
			$.post('app/odonto/procesos/p.procedimiento.delete2.php',ide,function(data){
				if(data==1) {
					load('app/odonto/vistas/procedimientosTodos.php','cedrif=<?php echo $cedrif ?>','#procedimientos');
				} else {
					alert(data);
				}
			})
		}
	}
	function cambiarEstado(ide) {
		//if(confirm('¿Desea cambiar el estado?')==true) {
			$.post('app/odonto/procesos/p.procedimiento.update.php',ide,function(data){
				if(data==1) {
					load('app/odonto/vistas/procedimientosTodos.php','cedrif=<?php echo $cedrif ?>','#procedimientos');
				} else {
					alert('No se puede cambiar el estado');
				}
			})
		//}	
	}

</script>