<?php 
require '../../../cfg/base.php';
$row_espec = $modonto->getAllEspec();

$arrDiagnoses = [];
if (isset($diagnoses) && !empty($diagnoses)) {
	$arrDiagnoses = json_decode($diagnoses, true);

	if (count($arrDiagnoses) < 2) {
		return;
	}
	
	$descriptions = array_column($arrDiagnoses, 'des');
	$des = implode(' / ', $descriptions);
	$diagno = array_column($arrDiagnoses, 'diagno')[0];

	$diagcons = implode(',',array_column($arrDiagnoses, 'diagcons'));
	$pieza = implode(',',array_column($arrDiagnoses, 'pieza'));
	$cedrif = array_column($arrDiagnoses, 'cedrif')[0];
}
echo $fun->modalHeader('Agregar Procedimiento para: '.$des);
?>
<style>
.modal-dialog {
	width: 50% !important;
}
#cantidad {
	width: 388px !important;
}
</style>
<div class="modal-body">
	<form action="" role="form" class="form-horizontal diagproced">
		<div class="msj_20"></div>
		<div class="form-group">
			<label for="" class="control-label col-sm-3">Especialidad:</label>
			<div class="col-sm-9">
				<select name="espec" id="espec" class="form-control chosen" onchange="load('app/odonto/vistas/cargar.proced.php','disabled=1&diagno=<?php echo $diagno ?>&espec='+$(this).val(),'#proced');load('app/odonto/vistas/cargar.medico.php','disabled=1&diagno=<?php echo $diagno ?>&espec='+$(this).val(),'#medico');">
					<option value=""></option>
						<?php foreach($row_espec as $r) { ?>
							<option value="<?php echo $r->espec_ide ?>"><?php echo $r->espec_descrip; ?></option>
						<?php } ?>
				</select>
			</div>
		</div>
		<div class="form-group" id="proced"></div>

		<div class="form-group">
			<label for="" class="control-label col-sm-3">Cantidad:</label>
			<div class="col-sm-9">	     
				<input type="number" class="form-control" name="cantidad" id="cantidad" min="1" value="1"> 
			</div>
		</div>
			
		<div class="form-group" id="medico"></div>

		<input type="hidden" name="diagcons" value="<?php echo $diagcons ?>">	
		<input type="hidden" name="pieza" value="<?php echo $pieza ?>">		
		<input type="hidden" name="cedrif" value="<?php echo $cedrif ?>">

		<?php if (isset($diagnoses) && !empty($diagnoses)) { ?>
			<input type="hidden" name="diagnoses" value="<?php echo htmlspecialchars($diagnoses, ENT_QUOTES); ?>">
		<?php } ?>
		
		<div class="form-actions modal-footer">
			<button class="btn btn-primary btn-sm pull-right"><span class="i fa fa-check"></span> Guardar Cambios</button>
		</div>
	</form>
	<div class="space-10"></div>
	<div id="proced-lista" class="table-responsive"></div>
</div>
<script>
	$('#espec').chosen({width: "inherit",no_results_text:'No hay resultados'});
	load('app/odonto/vistas/cargar.proced.php','espec=&diagno=&disabled=','#proced');
	load('app/odonto/vistas/cargar.medico.php','espec=&diagno=&disabled=','#medico');
	load('app/odonto/vistas/procedimiento.lista.php','cedrif=<?php echo $cedrif ?>&des=<?php echo $des ?>&diagcons=<?php echo $diagcons ?>','#proced-lista');
	$(function(){
		$('.diagproced').validate({
			errorElement: 'div',
			errorClass: 'help-block',
			focusInvalid: true,
			rules: {
				diagproced: {
					required: true
				},
				espec: {
					required: true
				},
				med :{
					required: true
				}
			},
			messages: {
				diagproced: {
					required: 'Indique el procedimiento'
				},
				espec: {
					required: 'Indique la especialidad'
				},
				med :{
					required: 'Indique el Odontologo'
				}
			},
			invalidHandler: function (event, validator) { 
				$('.alert-danger', $('.diagproced')).show();
			},			
			highlight: function (e) {
				$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
			},
			success: function (e) {
				$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
				$(e).remove();
			},
			submitHandler: function (form) {
				if ($('#espec').val() == '') {
					alerta('.msj_20','danger','Seleccione una especialidad');
				}else if ($('#diagproced').val() == ''){
					alerta('.msj_20','danger','Seleccione un procedimiento');
				}else if ($('#med').val() == ''){
					alerta('.msj_20','danger','Seleccione un odontologo');	
				}else{

					$.post('app/odonto/procesos/p.procedimiento.insert2.php',$('.diagproced').serialize(),function(data){
						if (data==1) {
							$.post('app/odonto/procesos/p.procedimiento.insert.php',$('.diagproced').serialize(),function(data){
								if(data==1) {
									load('app/odonto/vistas/procedimiento.lista.php','cedrif=<?php echo $cedrif ?>&des=<?php echo $des ?>&diagcons=<?php echo $diagcons ?>','#proced-lista');
									load('app/odonto/vistas/diagnosticos.php','cedrif=<?php echo $cedrif; ?>&odont=&diag_acti=0','#seleccionados');
									$('.msj_20').fadeOut();
								} else {
									alerta('.msj_20','danger',data);
								}
							})
						}else{
							if ((confirm('La cantidad del producto a usar para el procedimiento excede el limite minimo de existencia, ¿desea agregar el procedimiento?')) == true) {
								$.post('app/odonto/procesos/p.procedimiento.insert.php',$('.diagproced').serialize(),function(data){
									if(data==1) {
										load('app/odonto/vistas/procedimiento.lista.php','cedrif=<?php echo $cedrif ?>&des=<?php echo $des ?>&diagcons=<?php echo $diagcons ?>','#proced-lista');
										load('app/odonto/vistas/diagnosticos.php','cedrif=<?php echo $cedrif; ?>&odont=&diag_acti=0','#seleccionados');
										$('.msj_20').fadeOut();
									} else {
										alerta('.msj_20','danger',data);
									}
								})
							} //end if confirm
						} //end if principal
					})

				} // end validaciones de valores vacios
			},
			invalidHandler: function (form) {
			}
		})
	})
	function enviar() {
		$('.diagproced').submit();
	}
</script>
