<?php 
require '../../../cfg/base.php';
$diagnos = $modonto->odontoCedrif($cedrif);
$otrol = $modonto->odontoSelectCedrifTipo1($cedrif);
?>
<div class="msj_1"></div>
<div class="space-20"></div>
<div class="col-sm-5">
	<div class="col-sm-12">
		<div class="table-header">Diagnósticos 
			<span class="pull-right padding-r20">
				<button class="btn btn-success btn-xs" title="Insertar Multiples Procedimientos" onclick="multipleProcedures()" >
					<i class="fa fa-check bigger-130"></i>
				</button>
				<button type="button" class="btn btn-info btn-minier" onclick="load('app/odonto/vistas/procedimientosTodos.php','cedrif=<?php echo $cedrif ?>','#procedimientos')" class="btn btn-minier btn-white">Mostrar Todo</button>
			</span>
		</div>
		<?php if(!empty($diagnos)) { ?>
			<table class="table table-hover table-bordered table-striped tabla-diagnostic">
				<thead>
					<tr>
						<th></th>
						<th>Pieza</th>
						<th>Diagnóstico</th>
						<th>Opciones</th>
					</tr>
				</thead>
				<tbody>
					<?php foreach($diagnos as $d) {
						$piece = $codonto->piezas($d->diagcons_numero,$d->diagcons_fin,$d->diagcons_clase);
						$arrDiagnostic = [
							'pieza' => $piece,
							'cedrif' => $cedrif,
							'des' => $piece.' - '.$d->diagno_descrip,
							'diagcons' => $d->diagcons_ide,
							'diagno' => $d->diagno_codigo?:""
						]; ?>
						<tr>
							<td><input name="diagnostic[]" type="checkbox" data-diagnostic="<?php echo htmlspecialchars(json_encode($arrDiagnostic), ENT_QUOTES ); ?>" /></td>
							<td>
								<?php
									echo $piece;

									$grupo = $modonto->selectAgrupados($d->diagcons_ide); 
									foreach($grupo as $g) {
										echo ', '.$codonto->piezas($g->diagcons_numero,$g->diagcons_fin,$g->diagcons_clase);
									}
								?>
							</td>
							<td><?php echo $d->diagno_descrip ?></td>
							<td>
								<div class="action-buttons">
									<button class="btn btn-success btn-xs" title="Insertar Procedimientos" onclick="modal('app/odonto/vistas/procedimiento.insert.php','pieza=<?php echo $piece; ?>&cedrif=<?php echo $cedrif ?>&des=<?php echo $piece.' - '.$d->diagno_descrip ?>&diagcons=<?php echo $d->diagcons_ide ?>&diagno=<?php echo $d->diagno_codigo ?>'); return false;" >
										<i class="fa fa-check bigger-130"></i>
									</button>
									
									<?php if (empty($d->pago_mon) && empty($d->evol_ide)) { ?>
										<button class="btn btn-danger btn-xs" title="Borrar" onclick="borrarDiagno('diagno=<?php echo $d->diagcons_ide ?>'); return false" >
											<i class="icon-trash bigger-110 icon-only"></i>
										</button>
									<?php } ?>
									
									<button class="btn btn-primary btn-xs" title="Ver procedimientos" onclick="load('app/odonto/vistas/procedimientos.php','cedrif=<?php echo $cedrif ?>&des=<?php echo $piece.' - '.$d->diagno_descrip ?>&diagno=<?php echo $d->diagcons_ide ?>','#procedimientos'); return false;" >
										<i class="fa fa-search"></i>
									</button>
								</div>
							</td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		<?php } else { ?>
			<div class="alert alert-info">
				<strong>No hay diagnósticos registrados.</strong>
			</div>
		<?php } ?>
	</div>



	<div class="col-sm-12">
		<div class="table-header">Procedimientos Anteriores</div>

		<?php if(!empty($otrol)) { ?>
			<table class="table table-hover table-bordered table-striped">
				<thead>
					<tr>
						<th>Pieza</th>
						<th>Diagnóstico</th>
						<th>Opciones</th>
					</tr>
				</thead>
				<tbody>
					<?php foreach($otrol as $d) { ?>
						<tr>
							<td>
								<?php echo $codonto->piezas($d->diagcons_numero,$d->diagcons_fin,$d->diagcons_clase)?>
								<?php 
								$grupo = $modonto->selectAgrupados($d->diagcons_ide); 
								foreach($grupo as $g) {
									echo ', '.$codonto->piezas($g->diagcons_numero,$g->diagcons_fin,$g->diagcons_clase);
								}
								?>
							</td>
							<td><?php echo $d->diagno_descrip ?></td>
							<td>
								<div class="visible-md visible-lg hidden-sm hidden-xs action-buttons">
									<button class="btn btn-danger btn-xs" title="Borrar" onclick="borrarDiagno('diagno=<?php echo $d->diagcons_ide ?>'); return false">
										<i class="icon-trash bigger-110 icon-only"></i>
									</button>
								</div>
							</td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		<?php } else { ?>
			<div class="alert alert-info">
				<strong>No hay diagnósticos registrados en otro lugar.</strong>
			</div>
		<?php } ?>

	</div>
</div>

<div class="col-sm-7">
	<div id="procedimientos"></div>
</div>

<div class="clearfix"></div>

<script>
	load('app/odonto/vistas/procedimientosTodos.php','cedrif=<?php echo $cedrif ?>','#procedimientos')
	
	function multipleProcedures() {
		const checked = document.querySelectorAll(".tabla-diagnostic input[type=checkbox]:checked").length;
		const inputs = document.querySelectorAll(".tabla-diagnostic input[type=checkbox]");
		const diagnostic = [];

		if (checked == 0 || checked == 1) {
			alert('Debe seleccionar mas de un diagnostico');
			return;
		}

		for (let index = 0; index < inputs.length; index++) {
			const element = inputs[index];
			if (element.checked) {
				const objDagnostic= JSON.parse(element.dataset.diagnostic);
				if (diagnostic.length > 0) {
					const valid = diagnostic.find(diag => diag.diagno != objDagnostic.diagno);
					if (valid) {
						alert('Los diagnosticos no pueden ser diferentes');
						return;
					}
				}
				diagnostic.push(objDagnostic);
			}
		}
		modal('app/odonto/vistas/procedimiento.insert.php','pieza=&cedrif=&des=&diagcons=&diagno=&diagnoses='+JSON.stringify(diagnostic));
	}

	function borrarDiagno(ide) {
		if(confirm('¿Borrar el diagnóstico seleccionado?')==true) {
			$.post('app/odonto/procesos/p.diagnostico.borrar.php',ide+'&cedrif=<?php echo $cedrif ?>',function(data){
				if(data==1) {
					load('app/odonto/vistas/odonto.insert.php','cedrif=<?php echo $cedrif ?>&odont=&diag_acti=0','#odontoinsert');
					load('app/odonto/vistas/marcar.diagnostico.php','cedrif=<?php echo $cedrif ?>&odont=&diag_acti=0','.marcar-diagnostico');
					load('app/odonto/vistas/diagnosticos.php','cedrif=<?php echo $cedrif; ?>&odont=&diag_acti=0','#seleccionados');
				}else{
					alert(data);
				}
			})
		}
	}
</script>