<?php 
class mOdonto {

	protected $dbh,$con,$msj;

	function __clone() {

	} #clone

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	} #construct

	/**
	 * script para incluir imágenes en el editor de texto enriquecido
	 * @param  [type] $imagen [description]
	 * @return [type]         [description]
	 */
	public function crearImagen($imagen) {
		$i1 = explode('<img src="', $imagen);
		if(count($i1)>0) {
			$unimos2 = $i1[0].'';
			for($x=1;$x<count($i1);$x++) {
				$i3 = explode('">',$i1[$x]);
				#print_r($i3);
				$re = str_replace(' ', '+', $i3[0]);
				$unimos = $re.'" style="">';
				for($y=1;$y<count($i3);$y++) {
					if ($y==count($i3)-1) {
						$unimos .= $i3[$y];
					} else {
						$unimos .= $i3[$y].'">';
					}
				}
				$unimos2 .= ' <img src="'.$unimos;
			}
			$rt1 = $unimos2;
			$rt = str_replace('aspersonsignalascii', '&', $unimos2);
		} else {
			$rt = null;
		}
		return $rt;
	}

	function dienteTodoInsert() {
		$sql = "INSERT INTO tbl_diagcons VALUES(null,?,?,?,?,?,?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->diagno);
		$res->bindParam(2,$this->cedrif);
		$res->bindParam(3,$this->diente);
		$res->bindParam(4,$this->parte);
		$res->bindParam(5,$this->grupo);
		$res->bindParam(6,$this->otrolugar);
		$rt = ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		return $rt;
	} #dienteTodoInsert

	/**
	 * Para mostrar todos los diagnósticos en el odontograma
	 * @param  [type] $cedrif [description]
	 * @return [type]         [description]
	 */
	function odontoSelectCedrifOdonto($cedrif) {
		$sql = "SELECT * FROM tbl_diagcons AS dc
			INNER JOIN tbl_diagno AS d ON dc.diagno_codigo=d.diagno_codigo
			WHERE pacien_cedula=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	} #odontoSelectCedrif

	/**
	 * Mostrar en la tabla de diagnósticos realizados por la clínica
	 * @param  [type] $cedrif [description]
	 * @return [type]         [description]
	 */
	function odontoSelectCedrif($cedrif) {
		$sql = "SELECT
			dc.diagcons_ide,
			d.diagno_descrip,
			dc.diagcons_fecha,
			dc.diagcons_hora,
			IFNULL(pct.pacien_nomraz, usuario_login) AS especialista
			FROM
				tbl_diagcons AS dc
			INNER JOIN tbl_diagno AS d ON dc.diagcons_diagnostico=d.diagno_codigo
			INNER JOIN tbl_usuario AS usr ON dc.diagcons_medico = usr.usuario_codigo
			LEFT JOIN tbl_pacien AS pct ON usr.pers_cedrif = pct.pacien_cedrif
			WHERE
				dc.diagcons_paciente=?
			AND dc.diagcons_tipo=0
			AND dc.diagcons_group=0";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	// function odontoSelectCedrif2($cedrif,$odont) {
	// 	if ($odont == '') {
	// 		$sql = "SELECT * FROM vw_OdontoCedrif_TratDiagCons 
	// 			WHERE diagcons_paciente=? group by diagno";
	// 		$res = $this->con->prepare($sql);
	// 		$res->bindParam(1,$cedrif);
	// 		$res->execute();
	// 		$result = $res->fetchAll(PDO::FETCH_OBJ);
				
	// 	}else if($odont != ''){	

	// 		$sql = "SELECT * FROM vw_OdontoCedrif_TratDiagCons 
	// 			WHERE diagcons_paciente=? and diagcons_medico=? order by diagno_descrip";
	// 		$res = $this->con->prepare($sql);
	// 		$res->bindParam(1,$cedrif);
	// 		$res->bindParam(2,$odont);
	// 		$res->execute();
	// 		$result = $res->fetchAll(PDO::FETCH_OBJ);
	// 	}
	// 	return $result;
	// } #odontoSelectCedrif

	function nominaOdonto($f_ini,$f_fin,$odonto,$porc_clin,$porc_odon) {
		if ($odonto == '%') {
			$sql = "SELECT * FROM vw_nomina_odonto 
					WHERE  (date(diagcons_fecha) between '".$f_ini."' and '".$f_fin."') order by diagcons_ide";
			$res = $this->con->prepare($sql);
			$res->execute();
			$result = $res->fetchAll(PDO::FETCH_OBJ);
				
		}else if($odonto != '%'){
			$sql = "SELECT * FROM vw_nomina_odonto 
				WHERE trat_especialista=? and (date(diagcons_fecha) between '".$f_ini."' and '".$f_fin."') order by diagcons_ide";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$odonto);
			$res->execute();
			$result = $res->fetchAll(PDO::FETCH_OBJ);
		}
		return $result;
	}

	function tratamientoDiagcons($diagcons) {
		$arrDiagcons = array_map('intval',explode(',',$diagcons));

		$sql = "SELECT *, tra.proced_prec AS precio FROM tbl_tratamiento AS tra 
			INNER JOIN tbl_diagcons AS d ON tra.diagcons_ide=d.diagcons_ide
			INNER JOIN tbl_proced AS p ON tra.proced_ide=p.proced_ide
			-- INNER join tbl_pacien as pa on tra.trat_especialista = pa.pacien_cedrif
			-- INNER join tbl_odontologo as odo on tra.trat_especialista = odo.odontologo_num_ident
			INNER join vw_usuarios as odo on tra.trat_especialista = odo.pers_cedrif
			WHERE tra.diagcons_ide IN(".implode(',', $arrDiagcons).") ORDER BY d.diagcons_numero, tra.trat_ide ASC";
		$res = $this->con->prepare($sql);
		$res->execute();
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}
	/**
	 * Diagnósticos realizados en otro lugar
	 * @param  [type] $cedrif [description]
	 * @return [type]         [description]
	 */
	function odontoSelectCedrifTipo1($cedrif) {
		$sql = "SELECT * FROM tbl_diagcons AS dc
			INNER JOIN tbl_diagno AS d ON dc.diagcons_diagnostico=d.diagno_codigo
			WHERE dc.diagcons_paciente=? AND dc.diagcons_tipo=1 and dc.diagcons_group=0";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	} #odontoSelectCedrifTipo1

	function selectAgrupados($diagcons) {
		$sql = "SELECT * FROM tbl_diagcons
			WHERE diagcons_group=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$diagcons);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	} #odontoSelectCedrif


	function selecOdonto($odon){
		$sql = "SELECT * FROM tbl_pacien as a
				INNER JOIN tbl_usuario as b on a.pacien_cedrif = b.pers_cedrif 
				WHERE b.usuario_codigo = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$odon);
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function selecOdontoEspe($odon){
		// $sql = "SELECT * FROM tbl_odontologo as a WHERE a.odontologo_num_ident = ?";
		$sql = "SELECT * FROM vw_selecmedicos WHERE pacien_cedrif = ? ORDER BY pacien_nomraz ASC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$odon);
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}

	function diagnosticoDelete() {
		
		$sql = "SELECT * FROM tbl_tratamiento WHERE diagcons_ide=? and trat_paciente=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->diagno);
		$res->bindParam(2,$this->cedrif);
		$res->execute();
		$tot = $res->fetchAll(PDO::FETCH_OBJ);
		if(count($tot) > 0){
			foreach ($tot as $r) {
				if($r->trat_est >=3){
					if(count($tot)==0){
						$sql = "DELETE FROM tbl_diagcons WHERE diagcons_ide=? or diagcons_group=?";
						$res = $this->con->prepare($sql);
						$res->bindParam(1,$this->diagno);
						$res->bindParam(2,$this->diagno);
						return ($res->execute()==true) ? 1 : print_r($res->errorInfo());
					}else{
						return "Debe Eliminar el procedimiento asociado";
					}
				}else{
					return "Existen procedimientos Facturados";
				}
			}
		}else if(count($tot)==0){
			$sql = "DELETE FROM tbl_diagcons WHERE diagcons_ide=? or diagcons_group=?";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->diagno);
			$res->bindParam(2,$this->diagno);
			return ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		}else{
			return "Debe Eliminar el procedimiento asociado";
		}
	}

    function evolucionDelete() {
      //Busco la evolucion que se vaa borrar

		$sql = "SELECT evol_pago FROM tbl_evolucion WHERE evol_ide=?";
		$res = $this->con->prepare($sql);
	    $res->bindParam(1,$this->evol_ide);
		$res->execute();
		$devolu = $res->fetchAll(PDO::FETCH_OBJ);
		$valdevolu = $devolu[0]->evol_pago;
		
		$sql = "DELETE FROM tbl_evolucion WHERE evol_ide=?";
		$res = $this->con->prepare($sql);
	    $res->bindParam(1,$this->evol_ide);
		$res->execute();

        $sql = "SELECT evol_ide as total,proced_prec,evol_pago,evol_falta,trat_ide FROM tbl_evolucion
        where evol_ide = (select max(evol_ide) from tbl_evolucion where trat_ide=?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->trat_ide);
		$res->execute();
		$total = $res->rowCount();
		
		if($total>0) {

			$evolmax2=$res->fetchAll(PDO::FETCH_OBJ);
		    $evolmax3=$evolmax2[0]->total;
	        
	        $sql = "UPDATE tbl_evolucion set evol_falta=(evol_falta+?) WHERE evol_ide=?";
			$res = $this->con->prepare($sql);
	        $res->bindParam(1,$valdevolu);
			$res->bindParam(2,$evolmax3);
			return ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		} else {
			return 1;
		}
	}

	function procedDiagno($espec) {
		$sql = "SELECT * FROM tbl_proced WHERE proced_espe=? and proced_sta=1 ORDER BY proced_des ASC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$espec);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function getMedico($espec) {
		$sql = "SELECT * FROM vw_medporespec WHERE espemed_espe=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$espec);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function getMedico2($espec) {
		$sql = "SELECT * FROM vw_odontologoespecialidad WHERE espemed_espe=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$espec);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function getAllOdonto() {
		// $sql = "SELECT * FROM vw_odontologo ORDER BY odontologo_nombre ASC";
		$sql = "SELECT * FROM vw_selecmedicos where (nivusuario_codigo = 2 or nivusuario_codigo = 3) ORDER BY pacien_nomraz ASC";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function procedimientoInsert() {
		$sql = "SELECT * FROM tbl_proced WHERE proced_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->diagproced);
		$res->execute();
		$tot = $res->fetchAll(PDO::FETCH_OBJ);
		$fecha = date('Y-m-d');
		$hora = date('H:i:s');
		if (isset($this->diagnoses) && !empty($this->diagnoses)) {
			return $this->insertMultipleProcedures($this->diagnoses, $tot);
		} else {
			$sql = "INSERT INTO tbl_tratamiento VALUES(null,?,?,?,?,0,0,?,0,0,0,0,?,?,?,?,?)";
			$odonto = (($this->med == '') ? $_SESSION['ced'] : $this->med);
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->diagcons);
			$res->bindParam(2,$this->diagproced);
			$res->bindParam(3,$tot[0]->proced_prec);
			$res->bindParam(4,$this->cantidad);
			$res->bindParam(5,$tot[0]->proced_exe);
			$res->bindParam(6,$tot[0]->proced_prec_dol);
			$res->bindParam(7,$odonto);
			$res->bindParam(8,$this->cedrif);
			$res->bindParam(9,$fecha);
			$res->bindParam(10,$hora);
			return ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		}
	}

	function procedimientoDelete() {
		$sql = "SELECT * FROM tbl_tratamiento WHERE diagcons_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->diagcons_ide);
		$res->execute();
		$tot = $res->fetchAll(PDO::FETCH_OBJ);

		   if(count($tot)==0){
					$sql = "DELETE FROM tbl_diagcons WHERE diagcons_ide=? or diagcons_group=?";
					$res = $this->con->prepare($sql);
					$res->bindParam(1,$this->diagcons_ide);
					$res->bindParam(2,$this->diagcons_ide);
					return ($res->execute()==true) ? 1 : print_r($res->errorInfo());
			}else{
				    return "No puede Eliminar, Tiene procedimiento(s)";
			}		
	}


	function procedimientoDelete2() {
		$sql = "SELECT * FROM tbl_evolucion WHERE trat_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->trat_ide);
		$res->execute();
		$tot = $res->fetchAll(PDO::FETCH_OBJ);

		   if(count($tot)==0){
					$sql = "DELETE FROM tbl_tratamiento WHERE trat_ide=?";
					$res = $this->con->prepare($sql);
					$res->bindParam(1,$this->trat_ide);
					$res1= ($res->execute()==true) ? 1 : print_r($res->errorInfo());
					
                    if($res1==1):
                    	  $rt=1;
                    else:
                          $rt="No puede Eliminar, verifique porfavor"; 	
                    endif;	

					return $rt;
			}else{
				    return "No puede Eliminar, Tiene Evoluciones este procedimiento";
			}		
	}

	function procedimientoUpdate() {
		$sql = "UPDATE tbl_tratamiento SET trat_est=? WHERE trat_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->estado);
		$res->bindParam(2,$this->trat_ide);
		return $res->execute();
	}

	function guardarEvolucion() {
		$fecha = date('Y-m-d',strtotime($this->evol_fec));
		$hora = date('H:i:s');
		$editor = $this->crearImagen($this->descripcion);
		$sql = "INSERT INTO tbl_evolucion(evol_des, evol_fec, evol_hora, trat_ide, proced_prec, evol_pago, evol_falta)
		VALUES(?,?,?,?,0,0,0)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$editor);
		$res->bindParam(2,$fecha);
		$res->bindParam(3,$hora);
		$res->bindParam(4,$this->trat_ide);
		return ($res->execute()==true) ? $this->con->lastInsertId('tbl_evolucion_evol_ide_seq') : print_r($res->errorInfo());	
	}

	function guardaFotosEvolucion($evol_ide,$nombre,$temp) {
		$destino = '../../../img/evolucion/';
		$nom = str_replace(' ', '', $nombre);
		if(move_uploaded_file($temp, $destino.$nom)) {
			$sql = "INSERT INTO tbl_evolfotos VALUES(null,?,?,now())";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$evol_ide);
			$res->bindParam(2,$nom);
			return ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		}
	}

    function evolucionSelectIde($evol_ide) {
		$sql = "SELECT * from tbl_evolucion WHERE evol_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$evol_ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

function evolucionSelectmax($trat_ide) {
		$sql = "SELECT evol_ide as total,proced_prec,evol_pago,evol_falta,trat_ide FROM tbl_evolucion
        where evol_ide = (select max(evol_ide) from tbl_evolucion where trat_ide=?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$trat_ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function evolucionFotosSelectIde($evol_ide) {
		$sql = "SELECT * from tbl_evolfotos WHERE evol_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$evol_ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function traerFotos($evol_ide) {
		$sql = "SELECT * from tbl_evolfotos WHERE evol_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$evol_ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function fotosDelete() {
		$sql = "DELETE FROM tbl_evolfotos WHERE evfo_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->evfo_ide);
		return $res->execute();
	}

	function updateEvolucion() {
		$fecha = date('Y-m-d',strtotime($this->evol_fec));
		$sql = "UPDATE tbl_evolucion SET evol_des=?, evol_fec=?, proced_prec=?, evol_pago=?, evol_falta=? WHERE evol_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->descripcion);
		$res->bindParam(2,$fecha);
		$res->bindParam(3,$this->precp);
		$res->bindParam(4,$this->abono);
		$res->bindParam(5,$this->restap);		
		$res->bindParam(6,$this->evol_ide);
		return $res->execute();
	}

	function listaEvoluciones($trat_ide) {
		$sql = "SELECT * FROM tbl_evolucion WHERE trat_ide=? ORDER BY evol_fec DESC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$trat_ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function finalizarProcedimiento() {
		$sql = "UPDATE tbl_tratamiento SET trat_est=4, trat_status=1 WHERE trat_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->trat_ide);
		return $res->execute();
	}

    function reaperturarProcedimiento() {
		$sql = "UPDATE tbl_tratamiento SET trat_est=3,trat_status=0 WHERE trat_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->trat_ide);
		return $res->execute();
	}

	function procedimientosTodos($cedrif) {
		$sql = "SELECT *, tr.proced_prec AS precio FROM tbl_tratamiento AS tr 
			INNER JOIN tbl_diagcons AS dc ON tr.diagcons_ide=dc.diagcons_ide
			INNER JOIN tbl_proced AS p ON tr.proced_ide=p.proced_ide
			INNER JOIN tbl_diagno AS d ON dc.diagcons_diagnostico=d.diagno_codigo
			-- INNER join tbl_odontologo as odo on tr.trat_especialista = odo.odontologo_num_ident
			INNER join vw_usuarios as odo on tr.trat_especialista = odo.pers_cedrif
			WHERE dc.diagcons_paciente=?
			ORDER BY tr.trat_est, tr.trat_status";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
/* para saber si a sido facturado */
	function procedimientosTodosEvolu($cedrif,$trat_ide) {
		$sql = "SELECT *, tr.proced_prec AS precio FROM tbl_tratamiento AS tr 
			INNER JOIN tbl_diagcons AS dc ON tr.diagcons_ide=dc.diagcons_ide
			INNER JOIN tbl_proced AS p ON tr.proced_ide=p.proced_ide
			INNER JOIN tbl_diagno AS d ON dc.diagcons_diagnostico=d.diagno_codigo
			INNER join tbl_pacien as pa on tr.trat_especialista = pa.pacien_cedrif
			WHERE dc.diagcons_paciente=? and tr.trat_ide=?
			ORDER BY tr.trat_est, tr.trat_status";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->bindParam(2,$trat_ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function diagnosticosMedico($cedrif,$odont) {
		if ($odont == '') {
			$sql = "SELECT * FROM
				tbl_diagcons AS dc
			INNER JOIN tbl_diagno AS di ON dc.diagcons_diagnostico = di.diagno_codigo
			INNER JOIN tbl_usuario AS pe ON dc.diagcons_medico = pe.usuario_codigo
			WHERE dc.diagcons_paciente = ?";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$cedrif);
			$res->execute();
			$result = $res->fetchAll(PDO::FETCH_OBJ);
		}else if ($odont != ''){
			$sql = "SELECT * FROM
				tbl_diagcons AS dc
			INNER JOIN tbl_diagno AS di ON dc.diagcons_diagnostico = di.diagno_codigo
			INNER JOIN tbl_usuario AS pe ON dc.diagcons_medico = pe.usuario_codigo
			WHERE dc.diagcons_paciente = ? AND dc.diagcons_medico = ?";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$cedrif);
			$res->bindParam(2,$odont);
			$res->execute();
			$result = $res->fetchAll(PDO::FETCH_OBJ);
		}
		return $result;
	}
	
	function diagnosticosMedicoAll() {
			$sql = "SELECT * FROM
				tbl_diagcons AS dc
			INNER JOIN tbl_diagno AS di ON dc.diagcons_diagnostico = di.diagno_codigo
			INNER JOIN tbl_usuario AS pe ON dc.diagcons_medico = pe.usuario_codigo";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function traerDiagnosticos() {
    $sql = "SELECT * FROM tbl_diagno  order by diagno_descrip asc";
    //$sql = "SELECT * from tbl_diagno order by diagno_descrip";
    $res = $this->con->prepare($sql);
    $res->execute();
    return $res->fetchAll(PDO::FETCH_OBJ);
  }

  function guardarDiagnostico() {
  		$sql = "SELECT * FROM tbl_diagcons WHERE diagcons_numero=? AND diagcons_clase=? AND diagcons_diagnostico=?
		AND diagcons_fin=? AND diagcons_paciente=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1, $this->numero);
		$res->bindParam(2, $this->clase);
		$res->bindParam(3, $this->diagnostico);
		$res->bindParam(4, $this->fin);
		$res->bindParam(5, $this->paciente);
		$res->execute();
		if($res->rowCount()==0) {
			$sql = "INSERT INTO tbl_diagcons (diagcons_numero, diagcons_clase, diagcons_diagnostico, diagcons_fin, diagcons_paciente, 
				diagcons_medico, diagcons_fecha, diagcons_hora, diagcons_tipo, diagcons_group) VALUES (?, ?, ?, ?, ?, ?, now(), now(),?,?)";
			$res = $this->con->prepare($sql);
			$res->bindParam(1, $this->numero);
			$res->bindParam(2, $this->clase);
			$res->bindParam(3, $this->diagnostico);
			$res->bindParam(4, $this->fin);
			$res->bindParam(5, $this->paciente);
			$res->bindParam(6, $_SESSION['usr']);
			$res->bindParam(7, $this->tipo);
			$res->bindParam(8, $this->group);
			$rt = ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		} else {
			$rt = "Diagnóstico ya registrado";			
		}
		return $rt;
	}

	function traerFotosEvolucion($trat_ide) {
		$sql = "SELECT * FROM tbl_evolfotos AS ev
			INNER JOIN tbl_evolucion AS e ON ev.evol_ide=e.evol_ide
			INNER JOIN tbl_tratamiento AS t ON e.trat_ide=t.trat_ide
			WHERE t.trat_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$trat_ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	public function validarDiagconsRepetido() {
		$sql = "SELECT * FROM tbl_diagcons WHERE diagcons_numero=? AND diagcons_diagnostico=? AND diagcons_clase=? AND diagcons_paciente=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->numero);
		$res->bindParam(2,$this->diagnostico);
		$res->bindParam(3,$this->clase);
		$res->bindParam(4,$this->paciente);
		$res->execute();
		$rt = ($res->rowCount()>0) ? 'Diagnóstico ya registrado' : 1;
		return $rt;
	}

	public function validarPuedeTodo() {
		$sql = "SELECT * FROM tbl_diagno WHERE diagno_codigo=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->diagnostico);
		$res->execute();
		$row = $res->fetchAll(PDO::FETCH_OBJ);
		if($row[0]->diagno_totcar==5) {
			$rt = 1;
		} else {
			$rt = "El diagnóstico seleccionado no puede ser aplicado en todas las caras del diente";
		}
		return $rt;
	}

	public function validarAgrupado() {
		$sql = "SELECT * FROM tbl_diagno WHERE diagno_codigo=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->diagnostico);
		$res->execute();
		$row = $res->fetchAll(PDO::FETCH_OBJ);
		$sql = "SELECT * FROM tbl_diagcons WHERE diagcons_numero=? AND diagcons_diagnostico=? AND diagcons_paciente=? ORDER BY diagcons_ide ASC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->numero);
		$res->bindParam(2,$this->diagnostico);
		$res->bindParam(3,$this->paciente);
		$res->execute();
		$rows = $res->fetchAll(PDO::FETCH_OBJ);
		if($row[0]->diagno_totcar>count($rows)) {
			if(count($rows)>0) {
				$rt = $rows[0]->diagcons_ide;
			} else {
				$rt = 0;
			}
		} else {
			$rt = "Se ha cumplido el límite máximo de caras por diente para el diagnóstico seleccionado";
		}
		return $rt;
	}
    
    function proxima_cita($ide) {
		$sql = "SELECT citas_per, citas_fecha, pacien_nomraz FROM tbl_citas AS c INNER JOIN tbl_pacien AS p on c.citas_per=p.pacien_cedrif WHERE p.pacien_cedrif=? ORDER BY citas_fecha DESC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	public function getAllEspec() {
		$sql = "SELECT * FROM tbl_especialidad ORDER BY espec_ide asc";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	public function autoUpdateEspec($sel) {
		$row = $this->getAllEspec();
		$rt = '<select name="espec" id="espec" class="form-control chosen" onchange="load(\'\',\'disabled=1&espec=\'+$(this).val(),\'#proced\');">';
		$rt .='<option></option>';
		foreach($row as $r) {
			$rt .= '<option value="'.$r->espec_ide.'">'.$r->espec_descrip.'</option>';
		}
		$rt .= '</select>';
		$rt .= "<script type='text/javascript'>$('#espec').chosen({no_results_text:No hay resultados})</script>";
		return $rt;
	}

	public function group_diagcons($cedrif) {
		$sql = "SELECT * FROM vw_group_diagcons WHERE diagcons_paciente=? order by diagno_descrip ASC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		$rt = $res->fetchAll(PDO::FETCH_OBJ);
		return $rt;
	}

	function diagconstratgroup($diagcons) {
		$sql = "SELECT * FROM vwdiaconstratmproced WHERE diagcons_diagnostico=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$diagcons);
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}
	public function insertMultipleProcedures($diagnoses, $tot)
	{
		$diagnostics = json_decode($diagnoses, true);
		$diagnoses = array_map(function ($diagnoses) {
			return array_change_key_case($diagnoses);
		}, $diagnostics);
		$result = [];
		$fecha = date('Y-m-d');
		$hora = date('H:i:s');
		foreach ($diagnoses as $key => $diagnostic) {
			$sql = "INSERT INTO tbl_tratamiento VALUES(null,?,?,?,?,0,0,?,0,0,0,0,?,?,?,?,?)";
			$odonto = (($this->med == '') ? $_SESSION['ced'] : $this->med);
			$res = $this->con->prepare($sql);
			$res->bindParam(1, $diagnostic['diagcons']);
			$res->bindParam(2,$this->diagproced);
			$res->bindParam(3,$tot[0]->proced_prec);
			$res->bindParam(4,$this->cantidad);
			$res->bindParam(5,$tot[0]->proced_exe);
			$res->bindParam(6,$tot[0]->proced_prec_dol);
			$res->bindParam(7,$odonto);
			$res->bindParam(8,$diagnostic['cedrif']);
			$res->bindParam(9,$fecha);
			$res->bindParam(10,$hora);
			$result[$key] = ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		}
		return $result;
	}
	function allProcedures($cedrif) {
		$sql = "SELECT
				tr.trat_ide,
				tr.trat_est,
				tr.proced_prec AS precio,
				tr.proced_cantidad,
				tr.trat_status,
				d.diagno_descrip,
				dc.diagcons_ide,
				dc.diagcons_numero,
				dc.diagcons_fin,
				dc.diagcons_clase,
				p.proced_des,
				odo.pacien_nomraz,
				SUM( tpg.pago_mon + tpg.pago_descu) AS pago_mon
			FROM
				tbl_tratamiento AS tr
				INNER JOIN tbl_diagcons AS dc ON tr.diagcons_ide = dc.diagcons_ide
				INNER JOIN tbl_proced AS p ON tr.proced_ide = p.proced_ide
				INNER JOIN tbl_diagno AS d ON dc.diagcons_diagnostico = d.diagno_codigo
				INNER JOIN vw_usuarios AS odo ON tr.trat_especialista = odo.pers_cedrif
				LEFT JOIN tbl_pagos AS tpg ON tr.trat_ide = tpg.trat_ide
			WHERE
				dc.diagcons_paciente = ? 
			GROUP BY
				tr.trat_ide 
			ORDER BY
				tr.trat_est,
				tr.trat_status";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
	function datomoneda($ide) {
		$sql = "SELECT moneda_valorconv FROM tbl_moneda WHERE moneda_ide = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
	function baseCurrency() {
		$sql = "SELECT moneda_ide, moneda_valorconv FROM tbl_moneda WHERE moneda_principal = 1";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
	/**
	 * Mostrar en la tabla de diagnósticos realizados por la clínica
	 * @param  [type] $cedrif [description]
	 * @return [type]         [description]
	 */
	function odontoCedrif($cedrif) {
		$sql = "SELECT
				dc.diagcons_numero,
				dc.diagcons_fin,
				dc.diagcons_clase,
				dc.diagcons_ide,
				dc.diagno_codigo,
				d.diagno_descrip,
				SUM( pg.pago_mon ) AS pago_mon,
				ev.evol_ide 
			FROM
				tbl_diagcons AS dc
				INNER JOIN tbl_diagno AS d ON dc.diagcons_diagnostico = d.diagno_codigo
				LEFT JOIN tbl_tratamiento AS tr ON dc.diagcons_ide = tr.diagcons_ide
				LEFT JOIN tbl_pagos AS pg ON tr.trat_ide = pg.trat_ide
				LEFT JOIN tbl_evolucion AS ev ON tr.trat_ide = ev.trat_ide 
			WHERE
				dc.diagcons_paciente = ? 
				AND dc.diagcons_tipo = 0 
				AND dc.diagcons_group = 0 
			GROUP BY
				dc.diagcons_ide
				ORDER BY dc.diagcons_ide DESC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
	function evolutionsList($trat_ide) {
		$sql = "SELECT
				ev.evol_fec,
				ev.evol_des,
				sum(pg.pago_mon + pg.pago_descu) AS pago,
				pg.pago_dev
			FROM
				tbl_evolucion AS ev
				LEFT JOIN tbl_pagos AS pg ON ev.evol_ide = pg.evol_ide
			WHERE
				ev.trat_ide = ?
			GROUP BY
				ev.evol_ide
			ORDER BY
				ev.evol_fec DESC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$trat_ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
	function tratamientosPorDiagnostico($diagcons) {
		$sql = "SELECT
				tra.trat_ide,
				tra.trat_fecha,
				tra.trat_hora,
				p.proced_des,
				pa.pacien_nomraz AS especialista
			FROM
				tbl_tratamiento AS tra
			INNER JOIN tbl_proced AS p ON tra.proced_ide=p.proced_ide
			INNER join tbl_pacien as pa on tra.trat_especialista = pa.pacien_cedrif
			WHERE
				tra.diagcons_ide = $diagcons";
		$res = $this->con->prepare($sql);
		$res->execute();
		return ($res->execute()==true) ? $res->fetchAll(PDO::FETCH_OBJ) : print_r($res->errorInfo());
	}
}