<?php 
	require '../../../cfg/base.php';
	$datos = $mmoneda->poride($ide);
	$mon_prin = $mmoneda->monedaPrincipal();
	$monedas = $mmoneda->getAll();

	$desactiva = ($datos[0]->moneda_principal == 1) ? 'readonly' : '';

	if (count($mon_prin) > 0 && $datos[0]->moneda_principal == 0  && count($monedas) > 1) {
		$input = '<input type="hidden" name="prin" id="prin" value="'.$datos[0]->moneda_principal.'">';
		$tooltip = '<span class="input-group-addon btn-info" id="monprin" title="Ya existe una moneda principal"><i class="icon-question"></i></span>';
		$disabled = 'disabled';
	} elseif (count($mon_prin) > 0 && $datos[0]->moneda_principal == 1 && count($monedas) > 1) {
		$input = '';
		$tooltip = '';
		$disabled = '';
	} elseif (count($mon_prin) > 0 && $datos[0]->moneda_principal == 1 && count($monedas) == 1) {
		$input = '<input type="hidden" name="prin" id="prin" value="'.$datos[0]->moneda_principal.'">';
		$tooltip = '<span class="input-group-addon btn-info" id="monprin" title="Solo hay una moneda registrada"><i class="icon-question"></i></span>';
		$disabled = 'disabled';
	} elseif (count($mon_prin) == 0 && $datos[0]->moneda_principal == 0 && count($monedas) == 1) {
		$input = '';
		$tooltip = '';
		$disabled = '';
	} elseif (count($mon_prin) == 0 && $datos[0]->moneda_principal == 0 && count($monedas) > 1) {
		$input = '';
		$tooltip = '';
		$disabled = '';
	}

?>
<?php echo $fun->modalWidth('50%') ?>
<form class="update-moneda form-horizontal">
	<?php echo $fun->modalHeader('Modificar Moneda') ?>
		<div class="modal-body">
			<div class="mensaje"></div>

			<div class="form-group">
				<label for="" class="control-label col-lg-3 bolder">Pincipal:</label>
				<div class="col-lg-7 input-group">
					<select <?php echo $disabled ?> name="prin" class="select_prin" data-place-holder="Seleccione">
						<option value=""></option>
						<option value="1" <?php echo $fun->selected(1,$datos[0]->moneda_principal) ?>>SI</option>
						<option value="0" <?php echo $fun->selected(0,$datos[0]->moneda_principal) ?>>NO</option>
					</select>
					<?php echo $tooltip ?>
				</div>
				<?php echo $input ?>
			</div>

			<div class="form-group">
				<label for="" class="control-label col-lg-3 bolder">Nombre:</label>
				<div class="col-lg-7">
					<input type="text" class="form-control" name="desc" value="<?php echo $datos[0]->moneda_descripcion ?>">
				</div>
			</div>

			<div class="form-group">
				<label for="" class="control-label col-lg-3 bolder">Símbolo:</label>
				<div class="col-lg-7">
					<input type="text" class="form-control" name="sim" value="<?php echo $datos[0]->moneda_simbolo ?>">
				</div>
			</div>

			<!--<div class="form-group">
				<label for="" class="control-label col-lg-3 bolder">Operación:</label>
				<div class="col-lg-8">
					<label style="margin-right: 10px;">
						<input class="ace" type="radio" name="operacion" value="%" checked="checked">
						<span class="lbl">Dividir</span>
					</label>
					<label>
						<input class="ace" type="radio" name="operacion" value="*">
						<span class="lbl">Multiplicar</span>
					</label>
				</div>
			</div>-->
			
			<div class="form-group">
				<label for="" class="control-label col-sm-12 col-lg-3 bolder">Tasa de cambio:</label>
				<div class="col-lg-7 col-sm-12 input-group">
					<input type="hidden" class="form-control text-center" name="tasa_prin" id="tasa_prin">
					<input <?php echo $desactiva ?> type="text" class="form-control text-center" name="val_camb" id="val_camb" value="<?php echo number_format($datos[0]->moneda_valorconv,3,'.','') ?>">
					<span class="input-group-addon " id="cambiarval" title="Presiona para alternar el valor cambiario">
						<i class="icon-exchange"></i>
					</span>
					<span class="input-group-addon " id="tasacamb" title="Indica el valor de la moneda principal con respecto a la moneda que se esta agregando.">
						<i class="icon-question"></i>
					</span>
				</div>
				<div class="clearfix"></div>
				<?php if ($datos[0]->moneda_principal == 0): ?>
					<p class="red center"> Ejemplo: 1 USD = 3200 COP<b> / </b>1 COP = 0.0003125 USD</p>
				<?php endif ?>
			</div>
		</div>

		<input type="hidden" name="ide" value="<?php echo $datos[0]->moneda_ide ?>">

		<div class="clearfix"></div>
	<?php echo $fun->modalFooter('Guardar','btn-update') ?>
</form>

<script>

	$('#monprin').tooltip();
	$('#tasacamb').tooltip();
	$('#cambiarval').tooltip();
	
	$('.select_prin').chosen({
		no_result_tex: 'No hay resultado',
		width:'100%'
	}).change(function() {
		if ($(this).val() == '1') {
			$('#val_camb').val(1).attr('readonly',true);
		}else{
			$('#val_camb').val('').removeAttr('readonly');
		}
	});

	$(document).ready(function() {
		data = <?php echo json_encode($mon_prin); ?>;
		if (data.length > 0) {
			$('#tasa_prin').val(data[0].moneda_valorconv)
		}

		$('#cambiarval').click(function(){
			valor = $('#val_camb').val();
			valor_prin = $('#tasa_prin').val();
			// console.log('luego de quitar punto='+valor);
			valor = valor.split(',');
			valor = valor.join('.');

			// console.log('valor final='+valor+' - valor_prin='+valor_prin);
			if (valor != '' && valor_prin != '') {
				tot = valor_prin / valor;
				$('#val_camb').val(tot);
				// console.log('final final='+tot)
			}else{
				alerta('.mensaje','danger','Debe ingresar la tasa de cambio');
			}
		})
	});

	$('.btn-update').click(function(){
		$('.update-moneda').submit();
	})

	var formulario = '.update-moneda';
	$(formulario).validate({
		errorElement: 'div',
		errorClass: 'help-block',
		focusInvalid: true,
		rules: {
			desc: {
				required: true,
			},
			sim: {
				required: true,
			},
			val_camb: {
				required: true,
			}
		},

		messages: {
			desc: {
				required: 'Obligatorio',
			},
			sim: {
				required: 'Obligatorio',
			},
			val_camb: {
				required: 'Obligatorio',
			}
		},

		invalidHandler: function (event, validator) { //display error alert on form submit   
			$('.alert-danger', $(formulario)).show();
		},

		highlight: function (e) {
			$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
		},

		success: function (e) {
			$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
			$(e).remove();
		},

		submitHandler: function (form) {
			principal = $('.select_prin').val();
			if (principal != '') {
				$.post('app/moneda/procesos/p.moneda.update.php',$(formulario).serialize(),function(data){
					if(!isNaN(data)) {
						load('app/moneda/vistas/moneda.lista.php','','.lista');
						alerta('.mensaje','success','Registro Agregado correctamente');
						cerrarmodal()
					} else {
						alerta('error','Error!',data);
					}
				})				
			}else{
				alerta('.mensaje','danger','Seleccione si es principal o no');
			}
		},
		invalidHandler: function (form) {
		}
	});

</script>