<?php 
	require '../../../cfg/base.php';
	$monedas = $mmoneda->getAll();
?>
<div class="contenido">
	<?php if (count($monedas) > 0): ?>
		<div class="table-responsive">
			<table class="table table-striped table-bordered table-hover">
				<thead>
					<tr>
						<th>Nombre</th>
						<th>Símbolo</th>
						<th>Tasa de Cambio</th>
						<th>Principal?</th>
						<th>Opciones</th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ($monedas as $moneda): ?>
						<?php $color = ($moneda->moneda_principal == 1) ? '#abbac37d' : '' ; ?>
						<tr style="background-color: <?php echo $color ?> !important">
							<td><?php echo $moneda->moneda_descripcion ?></td>
							<td><?php echo $moneda->moneda_simbolo ?></td>
							<td><?php echo number_format($moneda->moneda_valorconv,3,',','.') ?></td>
							<td><?php echo $prin = ($moneda->moneda_principal == 1) ? 'SI' : 'NO'; ?></td>
							<td>
								<?php 
									if (count($monedas) == 1) {
										$onclick = "onclick=".'"borrar('.$moneda->moneda_ide.')"'."";
									} elseif ($moneda->moneda_principal == 1) {
										$onclick = '';
									} else {
										$onclick = "onclick=".'"borrar('.$moneda->moneda_ide.')"'."";
									}
								?>
								<div class="visible-md visible-lg hidden-sm hidden-xs action-buttons">
									<a class="green" href="#" title="Actualizar" onclick="actualizar(<?php echo $moneda->moneda_ide ?>)">
										<i class="icon-pencil bigger-130"></i>
									</a>
									<a <?php echo $onclick ?> class="red" href="#" title="Borrar">
										<i class="icon-trash bigger-130"></i>
									</a>
								</div>
							</td>
						</tr>
					<?php endforeach ?>
				</tbody>
			</table>
		</div>		
	<?php else: ?>
		<div class="alert alert-info">
			<strong>No se encontraron registros.</strong>
		</div>
	<?php endif ?>
</div>

<script>
	$('.table').dataTable();
	
	function actualizar(ide){
		modal('app/moneda/vistas/moneda.update.php','ide='+ide);
	}

	function borrar(ide){
		if (confirm('Desea borrar el registro seleccinado?')) {
			$.post('app/moneda/procesos/p.moneda.delete.php','ide='+ide,function(data){
				if (!isNaN(data)) {
					alerta('.msj','success','Registro borrado correctamente');
					load('app/moneda/vistas/moneda.lista.php','','.lista');
				}else{
					alerta('.msj','danger',data);
				}
			})
		}
	}
</script>