<?php 
	$mon_prin = $mmoneda->monedaPrincipal();
	if (count($mon_prin) > 0) {
		$disabled = 'disabled';
		$selected = 'selected';
		$input = '<input type="hidden" name="prin" id="prin" value="0">';
		$tooltip = '<span class="input-group-addon btn-info" id="monprin" title="Ya existe una moneda principal"><i class="icon-question"></i></span>';
	} else {
		$disabled = '';
		$selected = '';
		$input = '';
		$tooltip = '';
	}
?>
<div id="breadcrumbs" class="breadcrumbs">
	<script type="text/javascript">
	try{ace.settings.check('breadcrumbs' , 'fixed')}catch(e){}
	</script>
	<ul class="breadcrumb">
		<li><i class="icon-home home-icon"></i> <a href="">Inicio</a></li>
		<li class="active"><i class="fa fa-cogs"></i> <a href="">Configuración</a></li>
		<li class="active"> Moneda</li>
	</ul>
</div>
<div class="cleafix"></div>
<div class="space-10"></div>
<div class="col-xs-12 col-md-4 col-sm-4 well">
	<div class="msj"></div>
	<form action="" class="guardar form-horizontal" role="form">

		<div class="form-group">
			<label for="" class="control-label col-sm-12 col-lg-3 bolder">Pincipal:</label>
			<div class="col-lg-7 col-sm-12 input-group">
				<select <?php echo $disabled ?> name="prin" id="prin" class="select_prin" data-place-holder="Seleccione">
					<option value=""></option>
					<option value="1">SI</option>
					<option <?php echo $selected ?> value="0">NO</option>
				</select>
				<?php echo $tooltip ?>
			</div>
			<?php echo $input ?>
		</div>

		<div class="form-group">
			<label for="" class="control-label col-sm-12 col-lg-3 bolder">Nombre:</label>
			<div class="col-lg-7 col-sm-12">
				<input type="text" class="form-control" name="desc" id="desc">
			</div>
		</div>

		<div class="form-group">
			<label for="" class="control-label col-sm-12 col-lg-3 bolder">Símbolo:</label>
			<div class="col-lg-7 col-sm-12">
				<input type="text" class="form-control" name="sim" id="sim">
			</div>
		</div>

		<!--<div class="form-group">
			<label for="" class="control-label col-lg-3 bolder">Operación:</label>
			<div class="col-lg-8">
				<label style="margin-right: 10px;">
					<input class="ace" type="radio" name="operacion" value="%" checked="checked">
					<span class="lbl">Dividir</span>
				</label>
				<label>
					<input class="ace" type="radio" name="operacion" value="*">
					<span class="lbl">Multiplicar</span>
				</label>
			</div>
		</div>-->

		<div class="form-group">
			<label for="" class="control-label col-sm-12 col-lg-3 bolder">Tasa de cambio:</label>
			<div class="col-lg-7 col-sm-12 input-group">
				<input type="hidden" class="form-control text-center" name="tasa_prin" id="tasa_prin">
				<input type="text" class="form-control text-center" name="val_camb" id="val_camb">
				<span class="input-group-addon " id="cambiarval" title="Presiona para alternar el valor cambiario">
					<i class="icon-exchange"></i>
				</span>
				<span class="input-group-addon " id="tasacamb" title="Indica el valor de la moneda principal con respecto a la moneda que se esta agregando.">
					<i class="icon-question"></i>
				</span>
			</div>
			<div class="clearfix"></div>
			<p class="red center"> Ejemplo: 1 USD = 3200 COP<b> / </b>1 COP = 0.0003125 USD</p>
		</div>

		<div class="clearfix"></div>

		<div class=" clearfix form-actions">
			<div class="col-xs-12">
				<button class="btn btn-primary btn-block"><i class="icon-ok bigger-110"></i> Guardar Cambios</button>
			</div>
		</div>

	</form>
</div>
<div class="col-xs-12 col-md-8 col-sm-8 lista">
	
</div>
<div class="clearfix"></div>

<script>

	load('app/moneda/vistas/moneda.lista.php','','.lista');
	$('#monprin').tooltip();
	$('#tasacamb').tooltip();
	$('#cambiarval').tooltip();

	$('.select_prin').chosen({
		no_result_tex: 'No hay resultado',
		width:'100%'
	}).change(function() {
		if ($(this).val() == '1') {
			$('#val_camb').val(1).attr('readonly',true);
		}else{
			$('#val_camb').val('').removeAttr('readonly');
		}
	});

	$(document).ready(function() {
		data = <?php echo json_encode($mon_prin); ?>;
		if (data.length > 0) {
			$('#tasa_prin').val(data[0].moneda_valorconv)
		}

		$('#cambiarval').click(function(){
			valor = $('#val_camb').val();
			valor_prin = $('#tasa_prin').val();
			if (valor != '' && valor_prin != '') {
				tot = valor_prin / valor;
				$('#val_camb').val(tot);
			}else{
				alerta('.msj','danger','Debe ingresar la tasa de cambio');
			}
		})
	});

	$(function(){
		$('.guardar').submit(function(e){
			e.preventDefault();
			desc = $('#desc').val();
			sim = $('#sim').val();
			val_camb = $('#val_camb').val();
			principal = $('#prin').val();
			if (desc != '' && sim != '' && val_camb != '') {
				if (principal != '') {
					$.post('app/moneda/procesos/p.moneda.insert.php',$(this).serialize(),function(data){
						if(!isNaN(data)) {
							alerta('.msj','success','Registro guardado correctamente');
							load('app/moneda/vistas/moneda.lista.php','','.lista');
							$('.guardar').each(function(){
								this.reset();
								$(".select_prin").trigger("chosen:updated");
							})
						} else {
							alerta('.msj','danger',data);
						}
					})
				}else{
					alerta('.msj','danger','Indique si es moneda principal o no');
				}
			}else{
				alerta('.msj','danger','Complete todos los campos');
			}
		})
	})
</script>