<?php 
class mmedicamento {

	protected $dbh,$con,$msj;

	function __clone() {

	} #clone

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	} #construct

	function getAll() {
		$sql = "SELECT * FROM vw_medicamento ORDER BY medicamento_descrip ASC";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function medicamentosAll(){
		$sql = "SELECT * FROM vw_medicamento ORDER BY medicamento_descrip ASC";
		$res = $this->con->prepare($sql);
		$res->execute();
		$rt = $res->fetchAll(PDO::FETCH_OBJ);
		return json_encode($rt);
	}

	public function medicamentoInsert() {
		$sql = "SELECT fn_medicamento (null,?,?,?,1,?) as medicamento";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->medicamento);
		$res->bindParam(2,$this->cantidad);
		$res->bindParam(3,$this->unidmed);
		$res->bindParam(4,$_SESSION['ced']);
		$res->execute();
		$result = $res->fetchAll(PDO::FETCH_OBJ);
		if ($result[0]->medicamento == 1) {
			$rt = 1;
		}else{
			$rt = $result[0]->medicamento;
		}
		return $rt;
	}

	function medicamentoSelectIde($ide) {
		$sql = "SELECT * FROM vw_medicamento where medicamento_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function medicamentoUpdate() {
		$sql = "SELECT fn_medicamento (?,?,?,?,2,?) as medicamento";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$res->bindParam(2,$this->medicamento);
		$res->bindParam(3,$this->cantidad);
		$res->bindParam(4,$this->unidmed);
		$res->bindParam(5,$_SESSION['ced']);
		$res->execute();
		$result = $res->fetchAll(PDO::FETCH_OBJ);
		if ($result[0]->medicamento == 1) {
			$rt = 1;
		}else{
			$rt = $result[0]->medicamento;
		}
		return $rt;
	}

	function medicamentoDelete() {
		$sql = "SELECT fn_medicamento (?,0,0,0,3,?) as medicamento";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$res->bindParam(2,$_SESSION['ced']);
		$res->execute();
		$result = $res->fetchAll(PDO::FETCH_OBJ);
		if ($result[0]->medicamento == 1) {
			$rt = 1;
		}else{
			$rt = $result[0]->medicamento;
		}
		return $rt;
	}
	public function medicamentoPorNombre()
	{
		$sql= "SELECT medicamento_descrip
				FROM tbl_medicamento
				WHERE medicamento_descrip = ?";
			if (isset($this->ide) && !empty($this->ide)) {
				$sql.=" AND medicamento_ide != ?";
			}
			$sql.=" LIMIT 1";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->medicamento);
		if (isset($this->ide) && !empty($this->ide)) {
			$res->bindParam(2,$this->ide);
		}
		$res->execute();
		if ($res->execute()==true) {
			$resu = $res->fetchAll(PDO::FETCH_OBJ);
			$result = (!empty($resu)) ? $resu[0] : '';
		}else{
			$result = print_r($res->errorInfo());
		}
		return $result;
	}
}