<?php  
require '../../../cfg/base.php';
$rows = $mimpuesto->impuestoSelectIde($ide);
?>
<?php echo $fun->modalHeader('Editar Registro') ?>
<?php echo $fun->modalWidth(40) ?>
<div class="modal-body">
	<div class="bootbox-body">
		<div class="col-sm-12">
			<div class="mensaje1"></div>
			<?php foreach($rows as $r) { ?>
				<form action="" class="actualizar-impuesto" role="form">
					<div class="form-group">
						<label for="" class="control-label col-xs-12 bolder">Porcentaje o Tasa de Impuesto</label>
						<input type="number" min="0" name="porc" id="porc" class="col-sm-12" value="<?php echo $r->impuesto_porcent ?>">
					</div>
					<div class="clearfix"></div>

					<input type="hidden" name="ide" value="<?php echo $r->impuesto_ide ?>">
				</form>
			<?php } ?>
		</div>
	</div>
</div>
<div class="clearfix"></div>
<div id="impuesto"></div>
<?php echo $fun->modalFooter('Guardar Cambios','btn-modificar-impuesto') ?>

<script>

	$('.actualizar-impuesto').validate({
			errorElement: 'div',
			errorClass: 'help-inline',
			focusInvalid: true,
			rules: {
				porc: {
					required: true,
					number:true
				}
			},
			messages: {
				porc: {
					required: "Indique un valor",
					number:"Ingrese solo números"
				}
			},
			invalidHandler: function (event, validator) { 
				$('.mensaje1', $('.actualizar-impuesto')).show();
			},			
			highlight: function (e) {
				$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
			},
			success: function (e) {
				$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
				$(e).remove();
			},
			submitHandler: function (form) {
				$.post('app/impuesto/procesos/p.impuesto.update.php',$('.actualizar-impuesto').serialize(),function(data){
					if(data==1) {
						alerta('.mensaje1','success','Registro actualizado correctamente');
						load('app/impuesto/vistas/impuesto.lista.php','','.lista-impuesto')
					} else {
						alerta('.mensaje1','danger',data);
					}
			})
				
			},
			invalidHandler: function (form) {
				$('#impuesto').fadeOut(1);
			}
		 
	});

	$('.btn-modificar-impuesto').click(function(){
		$('.actualizar-impuesto').submit();
	});

</script>