<!-- HTML ################################## -->
<div class="space-10"></div>
<div class="col-xs-4 well">
	<div class="mensaje"></div>
	<form action="" class="guardar-impuesto" role="form">

		<div class="form-group">
			<label for="" class="control-label col-xs-12 bolder">Porcentaje o Tasa de Impuesto</label>
			<input type="number" min="0" name="porc" id="porc" class="col-sm-12">
		</div>
		<div class="clearfix"></div>
		<div class=" clearfix form-actions">
			<div class="col-xs-12">
				<button class="btn btn-primary btn-block"><i class="icon-ok bigger-110"></i> Guardar Cambios</button>
			</div>
		</div>
	</form>
</div>
<div class="col-xs-8 lista-impuesto">
</div>
<div class="clearfix"></div>
<div id="impuesto"></div>

<script>
	try{ace.settings.check('breadcrumbs' , 'fixed')}catch(e){}
</script>
<script>
	load('app/impuesto/vistas/impuesto.lista.php','','.lista-impuesto')

	$('.guardar-impuesto').validate({
			errorElement: 'div',
			errorClass: 'help-inline',
			focusInvalid: true,
			rules: {
				porc: {
					required: true,
					number:true
				}
			},
			messages: {
				porc: {
					required: "Indique un valor",
					number:"Ingrese solo números"
				}
			},
			invalidHandler: function (event, validator) { 
				$('.mensaje', $('.guardar-impuesto')).show();
			},			
			highlight: function (e) {
				$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
			},
			success: function (e) {
				$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
				$(e).remove();
			},
			submitHandler: function (form) {
				$.post('app/impuesto/procesos/p.impuesto.insert.php',$('.guardar-impuesto').serialize(),function(data){
					if(data==1) {
						alerta('.mensaje','success','Registro guardado correctamente');
						load('app/impuesto/vistas/impuesto.lista.php','','.lista-impuesto')
						$('.guardar-impuesto').each(function(){
							this.reset();
						})
					} else {
						alerta('.mensaje','danger',data);
					}
			})
				
			},
			invalidHandler: function (form) {
				$('#impuesto').fadeOut(1);
			}
		});

</script>