<?php 
	require'../../../cfg/base.php';
?>
<div id="calendar"></div>
<script>
	
		$(function() {

		$('#calendar').fullCalendar({
			locale: 'es', // lenguaje espa#nol
			timeFormat:'h:mm A', // FORMATO DE HORA QUE SE VE EN EL CINTILLO DE EVENTO
			slotLabelFormat: 'h:mm A', // FORMATO DE HORA PARA EL INTERVALO DE HORA
			slotLabelInterval : '00:30:00', // FRECUENCIA CON LA QUE SE IMPRIME EL TEXTO DE INTERVALO DE HORAS
			defaultView: 'agendaWeek', // vista por defecto, semana
			firstDay : 0, // Primer dia que se muestra "0" domingo
			allDaySlot : false, // Ocultar - mostar espacio de "todo el dia"
			eventLimit: true, // colocar el (mas..) cuando hay muchos eventos
			selectable: true, // 
			selectHelper: true, // Al arrastrar, se dibuja un marcador de posicion en la agenda
			navLinks: true, // deja seleccionar el dia (cambia la vista al dia selecccionado)
			weekNumbers: true, // numero de semana que se visualiza actualmente (se visualiza en la esquina superior izquierda de la agenda)
			weekNumberTitle:'Semana ', // Titulo de la semana en curso, si se muestra el numero de la semana este aparece
			nowIndicator: true, // resalta el momento actual con una linea roja (fecha y hora actual)
			header: {
				// EXACTAMENTE LA MISMA CONFIGURACION DEL FOOTER SI SE DESEA
				left: 'prev,next today',
				center: 'title',
				right: 'month,agendaWeek,agendaDay,listYear'
			},
			footer: {
				// configuracion de footer, se puede cambiar donde se quiera mostrar cada cosa
				left: 'prev,next today', // lo que aparece a la izquierda (anterior,siguiente, hoy)
				center: 'title', // centro, SE MOSTRARA titulo de la agenda, por defecto rango de fecha visualizada, se puede cambiar
				// titleFormat:'MMM D YYYY'   [TITULO]', RESULTADO SERIA ->('Sep 13 2009 TITULO')
				// titleFormat:'[TITULO]', RESULTADO SERIA ->(TITULO)
				right: 'month,agendaWeek,agendaDay,listYear' // a la derecha se muestra (mes, semana, dia)
			},
			columnHeaderHtml: function(mom) {
				// FORMATO QUE SE MUESTRA EN EL DIA DE LA AGENDA
				return '<b>' + mom.format('ddd D MMM') + '</b>';
			},
		    // Mostrar pequena descripcion del evento al colocar el cursor sobre el evento
		    eventRender: function(eventObj, $el) {
		      $el.popover({
		        title: eventObj.title,
		        content: eventObj.description,
		        trigger: 'hover',
		        placement: 'top',
		        container: 'body'
		      });
		    },
			businessHours: {
				dow: [0,6], // resaltar todos los dias menos sabado y domingo, puede funcionar para desactivar dias ocupado
				start: '00:00', // desde
				end: '23:00', // hasta
			},
			// CARGAR EVENTOS A TRAVES DE FUNCION AJAX
			events: function(start, end, timezone, callback) {
					$.ajax({
						method:'POST',
						cache: false,
						url: 'app/horario/procesos/p.horario.mostrar.php',
						dataType: 'json',
						data: {odonto:'<?php echo $odonto ?>'},
						success: function(data) {
							// console.log(data);
							var events = [];
							$.each(data,function(i, index) {
								hora1 = data[i].horario_hora_ini.split('.');
								hora_ini = hora1[0];
								hora2 = data[i].horario_hora_fin.split('.');
								hora_fin = hora2[0];
								// console.log(hora_ini+' -- '+hora_fin);

								events.push({
									title: data[i].clinica_descripcion,
									start: hora_ini,
									end : hora_fin,
									dow: [data[i].horario_dia_ini],
									allDay: false,
									editable: true,
									startEditable:false,
									overlap:true,
								});
							});
							callback(events);
						},
						error: function(xhr){

						}
					},'json');
			},
			// CARGAR EVENTOS A TRAVES DE ARREGLO
			events: [
				// puedo completar los campos directamente con jquery? o necesariamente con php?
				// visitar https://fullcalendar.io/docs/v3/events-function
				// 
				// PARA BLOQUEAR CAMPOS OCUPADOS, SE PUEDE UDAR LO SIGUIENTE
				// visitar https://fullcalendar.io/docs/v3/eventConstraint
				// COLOCAL COLOR DISTINTO A LOS CAMPOS BLOQUEADOS
				// visitar https://fullcalendar.io/docs/v3/background-events
			    /* {
					ide :1,
			    	title  : 'evento1',
			    	description: 'descripcion del evento 1',
			    	start  : '12:30:00', // si se coloca la fecha, el evento seria solo para ese dia
			    	end    : '13:00:00',// si se coloca la fecha, el evento seria solo para ese dia
			    	dow: [2,4], // evento recursivo, que se repite los dias indicados, siendo 1 el lunes
			    	allDay : false, // boolean - Tomar en cuenta todo el dia
			    	editable: true, // boolean - para que sea editable
					startEditable:true, // boolean - las horas de inicio de los eventos se puedan editar arrastrando
					// className:['label-success'], // string/array. Opcional. Una clase CSS (o conjunto de clases) que se adjuntará al elemento de este evento.
					color:'black', // cambiar el color de los eventos, se puede colocar por separado o general
					textColor: 'white', // cambia el color de la letra, se puede colocar por separado o general
					// overlap:false, // (FALSE) SI NO SE DESEA QUE ARRASTRE EVENTOS DENTRO DE ESPACIOS OCUPADOS Y QUE ESTE EVENTO NO SE REDIMENSIONE A EVENTOS YA CREADOS, SE PUEDE COLOCAR COMO CARACTERISTICA PRINCIPAL, NO EXTRICTAMENTE ACA
			    } */
		  	],
		    select: function(startDate, endDate, jsEvent) {
		    	// CREANDO UN NUEVO EVENTO
		    	// validar si se selecciona el dia completo
		    	var allDay = !startDate.hasTime() && !endDate.hasTime();
		    	datos = 'odonto=<?php echo $odonto ?>&clinica=<?php echo $clinica ?>&inicio='+startDate.format('YYYY-MM-DD HH:mm:ss A')+'&fin='+endDate.format('YYYY-MM-DD HH:mm:ss A')+'&allDay='+allDay;
	    		// if (<?php //echo $clinica ?> != '') {
			    	if (<?php echo $odonto ?> != '') {
				    	modal('app/horario/vistas/horarioInsert.php',datos);
		    		}else{
			    		alerta('.msjerror','danger','Seleccione el Odontologo');
		    		}
		    	// }else{
	    		// 	alerta('.msjerror','danger','Seleccione la Clinica');
		    	// }
		    	
		    	// mostrar la fecha y hora de inicio y de fin sobre el campo seleccionado
		    	// console.log('selected ' + startDate.format() + ' to ' + endDate.format());
		    	// $('#calendar').fullCalendar('refetchEvents')
		    },
		    eventClick: function(event, element,calEvent,jsEvent,view) {
		    	// CLICKEAR SOBRE UN EVENTO YA DEFINIDO
		    	// console.log('Clickeado ' + event.start.format());
		    	// event.title = "titulo de evento cambiado"; // valor del evento a cambiar
		    	// $('#calendar').fullCalendar('updateEvent', event); // recargando el evento clickeado, para recargar todos los eventos ('updateEvents', events)
		    	// 
		    	// $('#calendar').fullCalendar('refetchEvents'); // REFRESCAR TODOS LOS EVENTOS DEL CALENDARIO
		    	
		    	// remover el evento clickeado
		    	// $('#calendar').fullCalendar('removeEvents', calEvent._id);  // _id ES EL OBJETO DEL EVENTO, PUEDE CAMBIAR COLOCANDO LOS OBJETOS ASOCIADOS AL EVENTO
		    	// console.log(calEvent._id);
		    },
		    eventDrop: function( event, delta, revertFunc, jsEvent, ui, view) {
		    	// FUNCIONA AL MOVER EL EVENTO DE LUGAR
				// alert(event.title + " was dropped on " + event.start.format());
				// if (!confirm("Are you sure about this change?")) {
				// 	revertFunc(); // REVIERTE EL CAMBIO, VUELVE EL EVENTO AL LUGAR ORGINAL
				// }
			},
			dayClick: function(date, jsEvent, view) {
		    	// mostrar la fecha y hora en seleccion de un dia
		    	// console.log('clicked ' + date.format());
		    	// console.log('Coordinates: ' + jsEvent.pageX + ',' + jsEvent.pageY);
			    // console.log('Current view: ' + view.name);

			    // cambiar el color de todo el dia, solo para prueba
			    // $(this).css('background-color', 'red');
			},

		});

	});

</script>