<?php 
	require'../../../cfg/base.php';
?>
<div id="calendar"></div>
<script>
var calendarEl = document.getElementById('calendar');

var calendar = new FullCalendar.Calendar(calendarEl, {
	height: 'auto',
	contentHeight: 'auto',
	locale: 'es',
	//timeFormat:'h:mm A', // FORMATO DE HORA QUE SE VE EN EL CINTILLO DE EVENTO
	// FORMATO DE HORA PARA EL INTERVALO DE HORA
	slotLabelFormat: {
		hour:'2-digit',
		minute: '2-digit',
	  	meridiem: 'short',
	  	hour12: true,
	},
	slotLabelInterval : '01:00', // FRECUENCIA CON LA QUE SE IMPRIME EL TEXTO DE INTERVALO DE HORAS
	//allDaySlot : false, // Ocultar - mostar espacio de "todo el dia"
	eventLimit: true, // colocar el (mas..) cuando hay muchos eventos
	navLinks: true, // deja seleccionar el dia (cambia la vista al dia selecccionado)
	selectable: true, // Permite al usuario resaltar varios días o intervalos de tiempo haciendo clic y arrastrando.
	selectMirror: true, // Resaltar mientras el usuario arrastra o selecciona
	selectHelper: true, // Al arrastrar, se dibuja un marcador de posicion en la agenda
	selectOverlap: false, // Impide seleccionar lapso de tiempo donde ya hay un evento creado
	nowIndicator: true, // resalta el momento actual con una linea roja (fecha y hora actual)
	views: {
	    week: {
		    titleFormat: { month: 'long', year: 'numeric', day:'numeric'},
	    },
	    day: {
	      	titleFormat: { weekday: 'long', year: 'numeric', day:'numeric'} 
	    }
	},
	plugins: [ 'dayGrid', 'timeGrid', 'interaction','momentPlugin','timeGridWeek' ],
	defaultView: 'timeGridWeek',
	header: {
	  left: 'prev,next',
	  center: 'title',
	  right: 'dayGridMonth,timeGridWeek,timeGridDay'
	},
	minTime: '05:00',
	maxTime: '22:00',
	businessHours: {
		daysOfWeek: [0,6], // resaltar todos los dias menos sabado y domingo, puede funcionar para desactivar dias ocupados?
		startTime: '05:00', // desde
		endTime: '22:00', // hasta
	},
	columnHeaderHtml: function(date) {		
		// LOS HAGO 1 POR 1 YA QUE ESTA VERSION NO HACE LA TRADUCCION AL COLOCAR EL FORMATO
		if (date.getUTCDay() === 0) {
	      return '<b>Dom</b>';
	    } else if (date.getUTCDay() === 1){
	      return '<b>Lun</b>';
	    } else if (date.getUTCDay() === 2){
	      return '<b>Mar</b>';
	    } else if (date.getUTCDay() === 3){
	      return '<b>Mié</b>';
	    } else if (date.getUTCDay() === 4){
	      return '<b>Jue</b>';
	    } else if (date.getUTCDay() === 5){
	      return '<b>Vie</b>';
	    } else if (date.getUTCDay() === 6){
	      return '<b>Sáb</b>';
	    }
	},

	events: function(info, successCallback, failureCallback)  {
		$.ajax({
			method:'POST',
			cache: false,
			url: 'app/horario/procesos/p.horario.mostrar.php',
			dataType: 'json',
			data: {odonto:'<?php echo $odonto ?>'},
			success: function(data) {
				// console.log(data);
				var events = [];
				$.each(data,function(i, index) {
					hora1 = data[i].horario_hora_ini.split('.');
					hora_ini = hora1[0];
					hora2 = data[i].horario_hora_fin.split('.');
					hora_fin = hora2[0];

					events.push({
						ide : data[i].horario_ide,
						title: data[i].clinica_descripcion,
						description: data[i].clinica_descripcion,
						startTime: hora_ini,
						endTime : hora_fin,
						daysOfWeek: [data[i].horario_dia_ini],
						allDay: false,
						editable: true,
						startEditable:true,
						overlap:false,
					});
				});
				successCallback(events);
			},
			error: function(xhr){
				failureCallback(xhr);
			}
		},'json');
	},
	select: function(info) {
		inicio = moment(info.startStr).format('YYYY-MM-DD HH:mm:ss A d');
		fin = moment(info.endStr).format('YYYY-MM-DD HH:mm:ss A d');
		datos = 'odonto=<?php echo $odonto ?>&inicio='+inicio+'&fin='+fin+'&allDay='+info.allDay;
    	if (<?php echo $odonto ?> != '') {
	    	modal('app/horario/vistas/horarioInsert.php',datos);
		}else{
    		alerta('.msjerror','danger','Seleccione el Odontólogo');
		}
	},
	eventDrop: function(info) {
		inicio = moment(info.event.start).format('YYYY-MM-DD HH:mm:ss A d');
		fin = moment(info.event.end).format('YYYY-MM-DD HH:mm:ss A d');
		horario_ide = info.event._def.extendedProps.ide;

		datos = 'odonto=<?php echo $odonto ?>&inicio='+inicio+'&fin='+fin+'&allDay='+info.event.allDay+'&horario_ide='+horario_ide;
		
		if (confirm("Desea modificar el evento seleccionado?")) {
			// ACTUALIZAR EL HORARIO
			modal('app/horario/vistas/horarioUpdate.php',datos);
		}else{
			info.revert(); // REVIERTE EL CAMBIO, VUELVE EL EVENTO AL LUGAR ORGINAL			
		}
	},
	eventResize:  function(info) {
		// console.log(info.event);
		inicio = moment(info.event.start).format('YYYY-MM-DD HH:mm:ss A d');
		fin = moment(info.event.end).format('YYYY-MM-DD HH:mm:ss A d');
		horario_ide = info.event._def.extendedProps.ide;

		datos = 'odonto=<?php echo $odonto ?>&inicio='+inicio+'&fin='+fin+'&allDay='+info.event.allDay+'&horario_ide='+horario_ide;
		
		if (confirm("Desea cambiar este evento de hora?")) {
			// ACTUALIZAR EL HORARIO
			modal('app/horario/vistas/horarioUpdate.php',datos);
		}else{
			info.revert();// REVIERTE EL CAMBIO, VUELVE EL EVENTO AL LUGAR ORGINAL		
		}
	},
	eventClick: function(info) {
		inicio = moment(info.event.start).format('YYYY-MM-DD HH:mm:ss A d');
		fin = moment(info.event.end).format('YYYY-MM-DD HH:mm:ss A d');
		horario_ide = info.event._def.extendedProps.ide;

		datos = 'odonto=<?php echo $odonto ?>&inicio='+inicio+'&fin='+fin+'&allDay='+info.event.allDay+'&horario_ide='+horario_ide;
		modal('app/horario/vistas/horarioDelete.php',datos);
	}
    
});
calendar.render();
</script>