<?php 
require_once './cfg/base.php';
$result = $mgraficas->getTotalPorDias();
$days = [
    'Lunes',
    'Martes',
    'Miercoles',
    'Jueves',
    'Viernes',
    'Sábado',
    'Domingo'
];
$chartData = [];
array_walk($days, function($day, $index) use(&$chartData, $result) {
    $filter = array_values(array_filter($result, function($arr) use($index) {
        return $arr->dia == $index;
    }));
    array_push($chartData, (empty($filter)) ? 0 : $filter[0]->total );
});
?>

<div class="col-sm-6">
    <div class="box box-primary">
    <div class="box-header with-border">
        <h3 class="box-title">Venta Semanal</h3>
        <div class="box-tools pull-right">
        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
        </button>
        </div>
    </div>
    <div class="box-body">
        <div class="chart">
        <canvas id="areaChart" style="height:250px"></canvas>
        </div>
    </div>
    </div>
</div>

<script>
var days = <?php echo json_encode($days); ?>;
var data = <?php echo json_encode($chartData); ?>;
areaChart(days, 'Venta semanal', data);
</script>