<?php 
require_once './cfg/base.php';
$result = $mgraficas->getTotalPorMes();
$months = [
    'Enero',
    'Febrero',
    'Marzo',
    'Abril',
    'Mayo',
    'Junio',
    'Julio',
    'Agosto',
    'Septiembre',
    'Octubre',
    'Noviembre',
    'Diciembre'
];
$chartData = [];
array_walk($months, function($month, $index) use(&$chartData, $result) {
    $filter = array_values(array_filter($result, function($arr) use($index) {
        return $arr->mes == $index+1;
    }));
    array_push($chartData, (empty($filter)) ? 0 : $filter[0]->total );
});
?>

<div class="col-sm-6">
    <div class="box box-info">
    <div class="box-header with-border">
        <h3 class="box-title">Venta Mensual</h3>
        <div class="box-tools pull-right">
        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
        </button>
        </div>
    </div>
    <div class="box-body">
        <div class="chart">
        <canvas id="lineChart" style="height:250px"></canvas>
        </div>
    </div>
    </div>
</div>

<script>
var months = <?php echo json_encode($months); ?>;
var data = <?php echo json_encode($chartData); ?>;
lineChart(months, 'Venta Mensual', data);
</script>