<?php
class mGraficas
{
    protected $dbh,$con,$msj;

    public function __construct() {
        $this->dbh = new Conexion();
        $this->con = $this->dbh->pgsql();
        $this->msj = array();
        if(isset($_POST)) {
            foreach($_POST as $indice=>$valor) {
                if(!is_array($valor)) {
                    $this->$indice = strtoupper($valor);
                }
            }
        }
    }

    public function getTratamientosRealizados()
    {
        $sql = "SELECT count(trat_ide) AS cantidad FROM tbl_tratamiento WHERE trat_est = 4";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
    }
    public function getMontoTratamientosRealizados()
    {
        $sql = "SELECT SUM(proced_prec*proced_cantidad) AS total FROM tbl_tratamiento WHERE trat_est = 4";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
    }
    public function getPacientes()
    {
        $sql = "SELECT count(pacien_cedrif) AS num_pacientes FROM tbl_pacien";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
    }
    public function getPacientesAtendidos()
    {
        $sql = "SELECT
                tt.trat_paciente
            FROM
                tbl_tratamiento AS tt
            INNER JOIN tbl_pacien AS pc ON tt.trat_paciente = pc.pacien_cedrif 
            WHERE
                tt.trat_est IN ( 3, 4 ) 
            GROUP BY
                tt.trat_paciente";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
    }
    public function getTotalPorDias()
    {
        $date = date('Y-m-d');
        $sql = "SELECT
                SUM( pago_tot ) AS total,
                WEEKDAY( pago_hor ) AS dia
            FROM
                tbl_pagos 
            WHERE
                DATE_FORMAT( '$date' , '%Y' ) = DATE_FORMAT( pago_hor, '%Y' )
                AND WEEK( '$date' ) = WEEK( pago_hor )
            GROUP BY
                dia";
        $res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
    }
    public function getTotalPorMes()
    {
        $date = date('Y-m-d');
        $sql = "SELECT
                MONTH( pago_hor ) AS mes,
                SUM( pago_tot ) AS total 
            FROM
                tbl_pagos 
            WHERE
                DATE_FORMAT( pago_hor, '%Y' ) = DATE_FORMAT( '$date', '%Y' ) 
            GROUP BY
                mes";
        $res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
    }
    public function getTotalPorAnio()
    {
        $sql = "SELECT
                DATE_FORMAT( pago_hor, '%Y' ) AS anio,
                SUM( pago_tot ) AS total 
            FROM
                tbl_pagos
            GROUP BY anio
            ORDER BY anio DESC
            LIMIT 3";
        $res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
    }
    public function getTratamientosMasRealizados()
    {
        $sql = "SELECT
                prc.proced_des AS tratamiento,
                COUNT( trt.proced_ide ) AS cantidad 
            FROM
                tbl_tratamiento AS trt
                INNER JOIN tbl_proced AS prc ON trt.proced_ide = prc.proced_ide 
            WHERE
                trt.trat_est = 4 
            GROUP BY
                trt.proced_ide 
            ORDER BY
                cantidad DESC 
                LIMIT 5";
        $res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
    }
}