<?php 
class mEvolgene {
	protected $dbh,$con,$msj;

	function __clone() {

	} #clone

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	}
	
	function getEvolgeneId($cedrif) {
		$sql = "SELECT
					evg.evolgeneral_ide,
					evg.evolgeneral_fecha,
					evg.evolgeneral_espe,
					evg.evolgeneral_proced,
					evg.evolgeneral_num_diente,
					evg.evolgeneral_descrip,
					doc.pacien_nomraz AS especialista,
					esp.espec_descrip 
				FROM
					tbl_evolucion_general AS evg
				INNER JOIN tbl_pacien AS doc ON evg.evolgeneral_especialista_id = doc.pacien_cedrif
				INNER JOIN tbl_especialidad AS esp ON evg.evolgeneral_espe = esp.espec_ide
				WHERE
					evg.evolgeneral_paciente_ide = ?
				AND evolgeneral_borrado=0
				ORDER BY evolgeneral_fecha ASC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchALl(PDO::FETCH_OBJ);
	}
	function getEvolgenelistaID($ide) {
		$sql = "SELECT
							evolgeneral_ide,
							evolgeneral_fecha,
							evolgeneral_espe,
							evolgeneral_proced,
							evolgeneral_num_diente,
							evolgeneral_descrip,
							evolgeneral_paciente_ide,
							evolgeneral_especialista_id
					FROM
						tbl_evolucion_general
					WHERE
						evolgeneral_ide = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchALl(PDO::FETCH_OBJ);
	}

	function EvolgeneSelectProced($id) {
		$sql = "SELECT a.evolgeneralproced_ide,a.evolgeneralproced_proced,a.evolgeneralproced_evolide,c.proced_des FROM tbl_evolucion_general_proced AS a INNER JOIN tbl_evolucion_general AS b ON a.evolgeneralproced_evolide = b.evolgeneral_ide INNER JOIN tbl_proced AS c ON a.evolgeneralproced_proced = c.proced_ide";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$id);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
	function EvolgeneSelectProcedLista($id) {
		$sql = "SELECT a.evolgeneralproced_ide,a.evolgeneralproced_proced,a.evolgeneralproced_evolide,c.proced_des FROM tbl_evolucion_general_proced AS a INNER JOIN tbl_evolucion_general AS b ON a.evolgeneralproced_evolide = b.evolgeneral_ide INNER JOIN tbl_proced AS c ON a.evolgeneralproced_proced = c.proced_ide WHERE a.evolgeneralproced_evolide = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$id);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function procedDiagno($espec) {
		$sql = "SELECT * FROM tbl_proced WHERE proced_espe=? and proced_sta=1 ORDER BY proced_des ASC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$espec);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function insertEvolgene() {
		$fcha= date('Y-m-d', strtotime($_POST['fechaDatos']));
		$sql = "INSERT INTO tbl_evolucion_general(evolgeneral_paciente_ide, evolgeneral_fecha, evolgeneral_espe, evolgeneral_num_diente, evolgeneral_descrip, evolgeneral_especialista_id) VALUES (?,?,?,?,?,?)";
		$res = $this->con->prepare($sql);		
		$res->bindParam(1,$this->cedrif);
		$res->bindParam(2,$fcha);
		$res->bindParam(3,$this->espec);
		$res->bindParam(4,$this->numdiente);
		$res->bindParam(5,$this->evolgeneral);
		$res->bindParam(6,$this->especialista);

		if ($res->execute()) {
			$ultimo=$this->con->lastInsertId();
			if(isset($_POST['diagproced']) and count($_POST['diagproced'])>0) {			
				$sql = "INSERT INTO tbl_evolucion_general_proced (evolgeneralproced_proced,evolgeneralproced_evolide) VALUES (?,?) ";
				$res = $this->con->prepare($sql);
				foreach($_POST['diagproced'] as $r) {
					$res->bindParam(1,$r);
					$res->bindParam(2,$ultimo);
					$e = ($res->execute()==1) ? 1 : $this->msj[] = print_r($res->errorInfo());
				}	
			} else {
				$e = 1;
			}
			return $e;
		} else {
			return print_r($res->errorInfo());
		}
	}

	function UpdateEvolgene() {
		$fcha= date('Y-m-d', strtotime($_POST['fechaDatos']));
		$sql = "SELECT fn_evolgeneral(?,?,?,?,?,?,?,?,2)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$res->bindParam(2,$this->cedrif);
		$res->bindParam(3,$fcha);
		$res->bindParam(4,$this->espec);
		$res->bindParam(5,$this->numdiente);
		$res->bindParam(6,$this->evolgeneral);
		$res->bindParam(7,$this->especialista);
		$res->bindParam(8,$_SESSION['ced']);
		$exe_1=($res->execute());		
		/*return ($res->execute());*/
		if ($exe_1==1) {

			$sql = "DELETE FROM tbl_evolucion_general_proced WHERE evolgeneralproced_evolide=?";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->ide);
			$res->execute();

			if(isset($_POST['diagproced']) and count($_POST['diagproced'])>0) {			
			$sql = "INSERT INTO tbl_evolucion_general_proced (evolgeneralproced_proced,evolgeneralproced_evolide) VALUES (?,?) ";
			$res = $this->con->prepare($sql);
			foreach($_POST['diagproced'] as $r) {
				$res->bindParam(1,$r);
				$res->bindParam(2,$this->ide);
				$e = ($res->execute()==1) ? 1 : $this->msj[] = print_r($res->errorInfo());
			}
			$rt=1;	
		} else {
			$e = 1;
		}
	}
	return $rt;
	}

	function DeleteEvolgene() {
		$date = date('Y-m-d');
		$sql = "SELECT fn_evolgeneral(?,0,?,0,0,0,0,?,3)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$res->bindParam(2,$date);
		$res->bindParam(3,$_SESSION['ced']);
		return $res->execute() ? 3 : print_r($res->errorInfo());
	}
}