<?php 
class mEspecialista {

	protected $dbh,$con,$msj;

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	}
  public function especialistas()
  {
    $sql = "SELECT spl.especialista_id, spl.nombre, spc.espec_descrip AS especialidad
        FROM
          tbl_especialistas AS spl
        INNER JOIN tbl_especialidad AS spc ON spl.especialidad_id = spc.espec_ide
        WHERE
        spl.estado=1
        ORDER BY spl.nombre ASC";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
  }
  public function buscarEspecialista()
	{
    $id = isset($this->id) ? $this->id : '';
		$sql = "SELECT count(especialista_id) AS cantidad FROM tbl_especialistas where nombre=? AND estado=1";
		if (!empty($id)) {
			$sql.=" AND especialista_id != $id";
		}
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->especialista);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
  public function agregarEspecialista()
  {
		$sql = "INSERT INTO tbl_especialistas VALUES (null,?,2,?,1)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->especialista);
		$res->bindParam(2,$this->espec);
		if ($res->execute()) {
			$id=$this->con->lastInsertId();
			$response = 1;
			$this->agregarAuditorias(1,$id);
		} else {
			$response = $res->errorInfo();
		}
		return $response;
  }
  public function agregarAuditorias($operacion, $id)
	{
		$this->dbh->sp_auditoria($_SESSION['ced'],$operacion,'tbl_especialistas',$id);
	}
  public function especialistaPorId($id)
	{
		$sql = "SELECT nombre, especialidad_id FROM tbl_especialistas WHERE especialista_id = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$id);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
  public function editarEspecialista()
	{
		$sql = "UPDATE tbl_especialistas SET nombre = ?, especialidad_id = ? WHERE especialista_id = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->especialista);
		$res->bindParam(2,$this->espec);
		$res->bindParam(3,$this->id);
		if ($res->execute()) {
			$response = 1;
			$this->agregarAuditorias(2,$this->id);
		} else {
			$response = $res->errorInfo();
		}
		return $response;
	}
  public function eliminarEspecialista()
	{
		$sql = "UPDATE tbl_especialistas SET estado = 0 WHERE especialista_id = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->id);
		$rt = ($res->execute()) ? 1 : print_r($res->errorInfo());
		return $rt;
	}
}