<?php 
class mEspecialidad {

	protected $dbh,$con,$msj;

	function __clone() {

	} #clone

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	} #construct


	function especInsert() {
		$exist = $this->buscarEspecialidad($this->espec, '');
		if (!empty($exist[0]->cantidad)) {
			return ['Especialidad ya registrada'];
		}
		$sql = "INSERT INTO tbl_especialidad VALUES (null,?,0)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->espec);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		$id=$this->con->lastInsertId();
		$this->dbh->sp_auditoria($_SESSION['ced'],1,'tbl_especialidad',$id); 
		return $exe_1;
	}

	function especSelect() {
		$sql = "SELECT * FROM tbl_especialidad WHERE espec_borrado=0 ORDER BY espec_ide ASC";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function especSelectIde($ide) {
		$sql = "SELECT * FROM tbl_especialidad where espec_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function especUpdate() {
		$this->con->beginTransaction(); 
		$exist = $this->buscarEspecialidad($this->espec, $this->ide);
		if (!empty($exist[0]->cantidad)) {
			return ['Especialidad ya registrada'];
		}
		$sql = "UPDATE tbl_especialidad SET espec_descrip=?  where espec_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->espec);
		$res->bindParam(2,$this->ide);
		$uno=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
	   	if ($uno==1) {
	   		$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_especialidad',$this->ide); 
			$this->con->commit();
			$rt = 1;
		} else {
			$this->con->rollBack();
			$rt = $this->msj;
		}
		return $rt;
	}

	function especDelete() {
		$this->con->beginTransaction(); 
		$sql = "UPDATE tbl_especialidad SET espec_borrado=1 where espec_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$uno=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
	   	if ($uno==1) {
	   		$this->dbh->sp_auditoria($_SESSION['ced'],3,'tbl_especialidad',$this->ide);
			$this->con->commit();
			$rt = 1;
		} else {
			$this->con->rollBack();
			$rt = $this->msj;
		}
		return $rt;
	}
	public function buscarEspecialidad($especialidad, $id)
	{
		$sql = "SELECT count(espec_ide) AS cantidad FROM tbl_especialidad where espec_descrip=? AND espec_borrado=0";
		if (!empty($id)) {
			$sql.=" AND espec_ide != $id";
		}
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$especialidad);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
}