<?php 
class mEndo {

	protected $dbh,$con,$msj;

	function __clone() {

	} #clone

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	} #construct
    
    function endoSelect($ced) {
		$sql = "SELECT * FROM tbl_endodoncia where pacien_cedrif=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ced);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

    function endoInsert() {
		$fecha=date('Y-m-d');
		$sql = "INSERT INTO tbl_endodoncia(pacien_cedrif,endo_ning,endo_espon, endo_prov,endo_loca, endo_difu, endo_cdura, endo_ldura ,endo_diente,endo_sino,endo_obser,endo_fecha) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->cedrif);
		$res->bindParam(2,$this->ninguno);
		$res->bindParam(3,$this->espontaneo);
		$res->bindParam(4,$this->provocado);
		$res->bindParam(5,$this->localizado);
		$res->bindParam(6,$this->difuso);
		$res->bindParam(7,$this->cduracion);
		$res->bindParam(8,$this->lduracion);
		$res->bindParam(9,$this->diente);
		$res->bindParam(10,$this->radioval);
		$res->bindParam(11,$this->obser);
		$res->bindParam(12,$fecha);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo());
		$id=$this->con->lastInsertId();
		$this->dbh->sp_auditoria($_SESSION['ced'],1,'tbl_endodoncia',$id); 
		return $exe_1; 
	}	

	function endoSelectIde($ide) {
		$sql = "SELECT * FROM tbl_endodoncia where endo_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	 function endoUpdate() {
		$fecha=date('Y-m-d');
		$sql = "UPDATE tbl_endodoncia SET pacien_cedrif=?, endo_ning=?,endo_espon=?, endo_prov=?,endo_loca=?, endo_difu=?, endo_cdura=?, endo_ldura=? ,endo_diente=?,endo_sino=?,endo_obser=?,endo_fecha=? WHERE endo_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->cedrif);
		$res->bindParam(2,$this->ninguno);
		$res->bindParam(3,$this->espontaneo);
		$res->bindParam(4,$this->provocado);
		$res->bindParam(5,$this->localizado);
		$res->bindParam(6,$this->difuso);
		$res->bindParam(7,$this->cduracion);
		$res->bindParam(8,$this->lduracion);
		$res->bindParam(9,$this->diente);
		$res->bindParam(10,$this->radioval);
		$res->bindParam(11,$this->obser);
		$res->bindParam(12,$fecha);
		$res->bindParam(13,$this->endo_ide);		
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo());
		$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_endodoncia',$this->endo_ide);
		return $exe_1;
	}	

	function endoDelete() {
		$sql = "DELETE FROM tbl_endodoncia where endo_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		$this->dbh->sp_auditoria($_SESSION['ced'],3,'tbl_endodoncia',$this->ide);
		return $exe_1;

	}

	function endoSelectSensib($ced) {
		$sql = "SELECT * FROM tbl_endo_sensi where pacien_cedrif=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ced);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

    function endoInsertSensib() {
		$fecha=date('Y-m-d');
		$sql = "INSERT INTO tbl_endo_sensi(pacien_cedrif,endosen_ning,endosen_frio,endosen_calor,endosen_percu, endosen_palpa,endosen_presi,endosen_movil,endosen_diente,endosen_sino,endosen_obser,endosen_fecha) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->cedrifsen);
		$res->bindParam(2,$this->ningunos);
		$res->bindParam(3,$this->frio);
		$res->bindParam(4,$this->calor);
		$res->bindParam(5,$this->percusion);
		$res->bindParam(6,$this->palpacion);
		$res->bindParam(7,$this->presion);
		$res->bindParam(8,$this->movilidad);
		$res->bindParam(9,$this->dientesen);
		$res->bindParam(10,$this->radiovalsen);
		$res->bindParam(11,$this->obsersen);
		$res->bindParam(12,$fecha);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		$id=$this->con->lastInsertId();
		$this->dbh->sp_auditoria($_SESSION['ced'],1,'tbl_endo_sensi',$id); 
		return $exe_1; 
	}	

	function endoSelectSensibIde($ide) {
		$sql = "SELECT * FROM tbl_endo_sensi where endosen_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function endoUpdateSensib() {
		$fecha=date('Y-m-d');
		$sql = "UPDATE tbl_endo_sensi SET pacien_cedrif=?, endosen_ning=? ,endosen_frio=? ,endosen_calor=? ,endosen_percu=?, endosen_palpa=?, endosen_presi=? ,endosen_movil=? ,endosen_diente=? ,endosen_sino=? ,endosen_obser=? ,endosen_fecha=? WHERE endosen_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->cedrifsen);
		$res->bindParam(2,$this->ningunos);
		$res->bindParam(3,$this->frio);
		$res->bindParam(4,$this->calor);
		$res->bindParam(5,$this->percusion);
		$res->bindParam(6,$this->palpacion);
		$res->bindParam(7,$this->presion);
		$res->bindParam(8,$this->movilidad);
		$res->bindParam(9,$this->dientesen);
		$res->bindParam(10,$this->radiovalsen);
		$res->bindParam(11,$this->obsersen);
		$res->bindParam(12,$fecha);
		$res->bindParam(13,$this->endosen_ide);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_endo_sensi',$this->endosen_ide); 
		return $exe_1; 
	}

	function endoDeleteSensib() {
		$sql = "DELETE FROM tbl_endo_sensi where endosen_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		$this->dbh->sp_auditoria($_SESSION['ced'],3,'tbl_endo_sensi',$this->ide);
		return $exe_1; 
	}

	function endoSelectHalla($ced) {
		$sql = "SELECT * FROM tbl_endo_hallaradio where pacien_cedrif=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ced);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}	

	function endoInsertHalla() {
		$fecha=date('Y-m-d');
		$sql = "INSERT INTO tbl_endo_hallaradio(pacien_cedrif,endohalla_radio,endohalla_inflama,endohalla_fistula,endohalla_diag,endohalla_trata,endohalla_pronos,endohalla_fecha) VALUES (?,?,?,?,?,?,?,?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->cedrifhalla);
		$res->bindParam(2,$this->hallaradio);
		$res->bindParam(3,$this->inflama);
		$res->bindParam(4,$this->fistula);
		$res->bindParam(5,$this->diagnos);
		$res->bindParam(6,$this->trata);
		$res->bindParam(7,$this->pronos);
		$res->bindParam(8,$fecha);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		$id=$this->con->lastInsertId();
		$this->dbh->sp_auditoria($_SESSION['ced'],1,'tbl_endo_hallaradio',$id); 
		return $exe_1; 
	}

	function endoSelectHallaIde($ide) {
		$sql = "SELECT * FROM tbl_endo_hallaradio where endohalla_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}	


	function endoUpdateHalla() {
		$fecha=date('Y-m-d');
		$sql = "UPDATE tbl_endo_hallaradio SET endohalla_radio=?,endohalla_inflama=?,endohalla_fistula=?,endohalla_diag=?,endohalla_trata=?,endohalla_pronos=?,endohalla_fecha=? WHERE endohalla_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->hallaradio);
		$res->bindParam(2,$this->inflama);
		$res->bindParam(3,$this->fistula);
		$res->bindParam(4,$this->diagnos);
		$res->bindParam(5,$this->trata);
		$res->bindParam(6,$this->pronos);
		$res->bindParam(7,$fecha);
		$res->bindParam(8,$this->endohalla_ide);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_endo_hallaradio',$this->endohalla_ide); 
		return $exe_1; 
	}

	function endoDeleteHalla() {
		$sql = "DELETE FROM tbl_endo_hallaradio where endohalla_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		$this->dbh->sp_auditoria($_SESSION['ced'],3,'tbl_endo_hallaradio',$this->ide); 
		return $exe_1;
	}

	function endoSelectConduc($ced) {
		$sql = "SELECT * FROM tbl_endo_conducto where pacien_cedrif=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ced);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function endoInsertConduc() {
		$fcha=explode('-',$this->fechainic);
    	$dia=$fcha[0];
    	$mes=$fcha[1];
    	$ano=$fcha[2];
    	$fchaf= $ano.'-'.$mes.'-'.$dia;

		$sql = "INSERT INTO tbl_endo_conducto(endocondu_fecha,pacien_cedrif,endocondu_diente,endocondu_conducto,endocondu_referencia,endocondu_lima,endocondu_mm,endocondu_obtura,endocondu_desob,endocondu_obser) VALUES (?,?,?,?,?,?,?,?,?,?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$fchaf);
		$res->bindParam(2,$this->cedrifconduc);
		$res->bindParam(3,$this->diente);
		$res->bindParam(4,$this->conducto);
		$res->bindParam(5,$this->referencia);
		$res->bindParam(6,$this->lima);
		$res->bindParam(7,$this->mm);
		$res->bindParam(8,$this->obturacion);
		$res->bindParam(9,$this->desobturacion);
		$res->bindParam(10,$this->obsercon);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		$id=$this->con->lastInsertId();
		$this->dbh->sp_auditoria($_SESSION['ced'],1,'tbl_endo_conducto',$id); 
		return $exe_1; 
	}

	function endoSelectConducIde($ide) {
		$sql = "SELECT * FROM tbl_endo_conducto where endocondu_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function endoUpdateConduc() {
		$fcha=explode('-',$this->fechainic);
    	$dia=$fcha[0];
    	$mes=$fcha[1];
    	$ano=$fcha[2];
    	$fchaf= $ano.'-'.$mes.'-'.$dia;

		$sql = "UPDATE tbl_endo_conducto SET endocondu_fecha=?,endocondu_diente=?,endocondu_conducto=?,endocondu_referencia=?,endocondu_lima=?,endocondu_mm=?,endocondu_obtura=?,endocondu_desob=?,endocondu_obser=? WHERE endocondu_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$fchaf);
		$res->bindParam(2,$this->diente);
		$res->bindParam(3,$this->conducto);
		$res->bindParam(4,$this->referencia);
		$res->bindParam(5,$this->lima);
		$res->bindParam(6,$this->mm);
		$res->bindParam(7,$this->obturacion);
		$res->bindParam(8,$this->desobturacion);
		$res->bindParam(9,$this->obsercon);
		$res->bindParam(10,$this->endocondu_ide);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_endo_conducto',$this->endocondu_ide); 
		return $exe_1; 
	}


	function endoDeleteConduc() {
		$sql = "DELETE FROM tbl_endo_conducto where endocondu_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
		$this->dbh->sp_auditoria($_SESSION['ced'],3,'tbl_endo_conducto',$this->ide); 
		return $exe_1;	
	}	
} #class
?>