<?php 
class mDolar {

	protected $dbh,$con,$msj;

	function __clone() {

	} #clone

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	} #construct


	function dolarInsert() { 
		$sql = "INSERT INTO tbl_dolar VALUES (null,?,now(),0)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->dolar);
		$this->actualizarPrecios($this->dolar);
		$exe_1 = ($res->execute()==1) ? 1 : print_r($res->errorInfo());
		$id=$this->con->lastInsertId(); 
		$this->dbh->sp_auditoria($_SESSION['ced'],1,'tbl_dolar',$id);
		return $exe_1;
	}

	function actualizarPrecios($dolar) {
		$sql = "SELECT fn_actualizarprecios(?) as precios";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$dolar);
		$res->execute();
		$result = $res->fetchAll(PDO::FETCH_OBJ);
		$rt = $result[0]->precios;
		return $rt;
    }

	function dolarSelectLast() {
		$sql = "SELECT * FROM tbl_dolar WHERE dolar_borrado=0 ORDER BY dolar_ide DESC LIMIT 1";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function dolarSelect() {
		$sql = "SELECT * FROM tbl_dolar WHERE dolar_borrado=0 ORDER BY dolar_ide DESC LIMIT 3";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function dolarSelectIde($ide) {
		$sql = "SELECT * FROM tbl_dolar where dolar_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function dolarUpdate() {
		$this->con->beginTransaction(); 
		$sql = "UPDATE tbl_dolar SET dolar_valor=?, dolar_fechahora=now()  where dolar_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->dolar);
		$res->bindParam(2,$this->ide);
		$uno=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
	   	if ($uno==1) {
	   		$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_dolar',$this->ide);
			$this->con->commit();
			$rt = 1;
		} else {
			$this->con->rollBack();
			$rt = $this->msj;
		}
		return $rt;
	}

	function dolarDelete() {
		$this->con->beginTransaction(); 
		$sql = "UPDATE tbl_dolar SET dolar_borrado=1 where dolar_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$uno=($res->execute()==1) ? 1 : print_r($res->errorInfo()); 
	   	if ($uno==1) {
	   		$this->dbh->sp_auditoria($_SESSION['ced'],3,'tbl_dolar',$this->ide);
			$this->con->commit();
			$rt = 1;
		} else {
			$this->con->rollBack();
			$rt = $this->msj;
		}
		return $rt;
	}


} #class
?>