<?php 
require '../../../cfg/base.php';
$documentos = $mdocumento->obtenerDocumentos();

if(!empty($documentos)) { ?>
	<div class="table-responsive">
		<table class="table table-hover table-bordered documents">
			<thead>
				<tr>
					<th>Código</th>
					<th>Nombre</th>
					<th>Estado</th>
					<th width="10%">Opciones</th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ($documentos as $documento) { ?>
					<tr>
						<td><?php echo $documento->codigo; ?></td>
						<td><?php echo $documento->nombre; ?></td>
						<td><?php echo $documento->estado; ?></td>
						<td align="center">
							<div class="visible-md visible-lg visible-sm visible-xs action-buttons">
								<a class="secundary" href="#" title="Documento" onclick="modal('app/documentos/vistas/vista.previa.documento.php','documento=<?php echo $documento->archivo; ?>')">
									<i class="icon-eye-open bigger-130"></i>
								</a>
								<a class="green" href="#" title="Editar" onclick="modal('app/documentos/vistas/documento.insert.php','id=<?php echo $documento->documento_id; ?>')">
									<i class="icon-pencil bigger-130"></i>
								</a>
								<a class="red" href="#" title="Eliminar" onclick="modal('app/documentos/vistas/documento.delete.php','id=<?php echo $documento->documento_id; ?>')">
									<i class="icon-trash bigger-130"></i>
								</a>
							</div>
						</td>
					</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
<?php } else { ?>
	<div class="alert alert-info">
		<strong>No se encontraron registros.</strong>
	</div>
<?php } ?>

<script type="text/javascript">	
	$(function(){
		$('.documents').dataTable();
	});
</script>