<?php 
require '../../../cfg/base.php';
$codigo = '';
$nombre = '';
$descripcion = '';
$archivo = '';
$tipoPlantillaId = '';
$tiposPlantillas = $mdocumento->obtenerTiposPlantillas();
if (isset($id)) {
	$documento = $mdocumento->obtenerDocumentoPorId($id);
	$codigo = $documento[0]->codigo;
	$nombre = $documento[0]->nombre;
	$descripcion = $documento[0]->descripcion;
	$archivo = $documento[0]->archivo;
	$tipoPlantillaId = $documento[0]->tipo_plantilla_id;
}
echo $fun->modalHeader('Agregar Documento');
echo $fun->modalWidth(70); ?>
<div class="modal-body">
	<div class="bootbox-body">
		<div class="col-sm-12">
			<div class="mensaje1"></div>
			<form action="" role="form" class="document-insert">
				<div class="msj1"></div>
				<div class="col-lg-12">
					<div class="col-sm-6">
						<div class="form-group">
							<label for="" class="control-label bolder col-sm-12">Código</label>
							<div class="col-sm-12">
								<input type="text" class="form-control" name="codigo" id="codigo" value="<?php echo $codigo; ?>">
							</div>
						</div>	
					</div>
					<div class="col-sm-6">
						<div class="form-group">
							<label for="" class="control-label bolder col-sm-12">Nombre</label>
							<div class="col-sm-12">
								<input type="text" class="form-control" name="nombre" id="nombre" value="<?php echo $nombre; ?>">
							</div>
						</div>	
					</div>
				</div>

				<div class="col-lg-12">
          <div class="col-sm-6">
						<div class="form-group">
							<label for="" class="control-label bolder col-sm-12">Tipo de Plantilla</label>
							<div class="col-sm-12">
								<select name="tipo_plantilla" id="tipo_plantilla" class="form-control">
									<option value="">Seleccionar</option>
									<?php if (!empty($tiposPlantillas)) {
										foreach ($tiposPlantillas as $tipoPlantilla) {
											$selected = ($tipoPlantilla->tipo_plantilla_id == $tipoPlantillaId) ? 'selected' : '';
										?>
											<option
												value="<?php echo $tipoPlantilla->tipo_plantilla_id; ?>"
												data-variable="<?php echo htmlspecialchars($tipoPlantilla->variables, ENT_QUOTES); ?>"
												<?php echo $selected; ?>
											><?php echo $tipoPlantilla->descripcion; ?></option>
										<?php }
									} ?>
								</select>
							</div>
						</div>	
					</div>
					<div class="col-sm-6">
							<div class="form-group">
									<label for="" class="control-label bolder col-sm-12">Variables Usadas</label>
									<div class="col-sm-12">
										<textarea class="form-control variables" disabled></textarea>
									</div>
							</div>	
					</div>
				</div>

        <div class="col-lg-12">
          <div class="col-sm-6">
						<div class="form-group">
							<label for="" class="control-label bolder col-sm-12">Descripción</label>
							<div class="col-sm-12">
                <textarea name="descripcion" id="descripcion" class="form-control col-sm-12"><?php echo $descripcion; ?></textarea>
							</div>
						</div>	
					</div>
					<div class="col-sm-6">
							<div class="form-group">
									<label for="" class="control-label bolder col-sm-12">Documento</label>
									<div class="col-sm-12">
										<input name="documento" type="file" accept=".doc,.docx" />
										<input name="nombre_archivo" type="hidden" id="nombre_archivo" value="<?php echo $archivo; ?>" />
									</div>
							</div>	
					</div>
				</div>
				<input type="hidden" name="id" value="<?php echo isset($id) ? $id : ''; ?>">
			</form>
		</div>
	</div>
</div>
<div class="clearfix"></div>
<?php echo $fun->modalFooter('Guardar Cambios','btn-agregar') ?>

<script>
$(function(){
	$('.btn-agregar').click(function() {
		$('.document-insert').submit();
	});
	$('#tipo_plantilla').on('change', function () {
		$('.variables').text($(this).find('option:selected').data('variable'));
	});
	$('#tipo_plantilla').trigger('change');

	$('.document-insert').validate({
		errorElement: 'div',
		errorClass: 'help-inline',
		focusInvalid: true,
		rules: {
			codigo: {
				required: true
			},
			nombre: {
				required: true,
			},
			descripcion: {
				required: true
			}
		},
		messages: {
			codigo: {
				required: 'Obligatorio',
			},
			nombre: {
				required: 'Obligatorio'
			},
			descripcion: {
				required: 'Obligatorio'
			}
		},
		invalidHandler: function (event, validator) { 
			$('.alert-danger', $('.document-insert')).show();
		},			
		highlight: function (e) {
			$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
		},
		success: function (e) {
			$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
			$(e).remove();
		},
		submitHandler: function (form) {
			var formData = new FormData(form);

			$.ajax({
				url: 'app/documentos/procesos/p.documento.insert.php',
				type: 'POST',
				data: formData,
				cache: false,
				contentType: false,
				processData: false,
				dataType: 'json',
				success: function (data) {
					if(data.status == 'success') {
						alert(data.message);
						load('app/documentos/vistas/documento.lista.php','','#lista-documentos');
						cerrarmodal();
					} else {
						alerta('.msj1','danger',data.message);
					}
				}
			});
		},
		invalidHandler: function (form) {
		}
	})
});
</script>