<?php
require_once "../../../vendor/autoload.php";

use PhpOffice\PhpWord\TemplateProcessor;
use PhpOffice\PhpWord\IOFactory;
use PhpOffice\PhpWord\Settings;

$pathReplace = str_replace('\\','/',__DIR__);
$paths = explode('app/', $pathReplace);
$pathDoc = $paths[0].'doc';
$width = 250;
$height = 200;

$templateProcessor = new TemplateProcessor($file);
if (isset($consentimiento)) {
  $width = 150;
  $height = 27;
}

if (array_key_exists('FIRMA_DOCTOR', $informacionDocumento) && !empty($informacionDocumento['FIRMA_DOCTOR'])) {
  $templateProcessor->setImageValue('FIRMA_DOCTOR', array('path' => $informacionDocumento['FIRMA_DOCTOR'], 'width' => $width, 'height' => $height));
  unset($informacionDocumento['FIRMA_DOCTOR']);
}

if (array_key_exists('FIRMA_PACIENTE', $informacionDocumento) && !empty($informacionDocumento['FIRMA_PACIENTE'])) {
  $templateProcessor->setImageValue('FIRMA_PACIENTE', array('path' => $informacionDocumento['FIRMA_PACIENTE'], 'width' => $width, 'height' => $height), 3);
  unset($informacionDocumento['FIRMA_PACIENTE']);
}

if (array_key_exists('FIRMA_REPRESENTANTE', $informacionDocumento) && !empty($informacionDocumento['FIRMA_REPRESENTANTE'])) {
  $templateProcessor->setImageValue('FIRMA_REPRESENTANTE', array('path' => $informacionDocumento['FIRMA_REPRESENTANTE'], 'width' => $width, 'height' => $height), 3);
  unset($informacionDocumento['FIRMA_REPRESENTANTE']);
}

$templateProcessor->setValues($informacionDocumento);

$fileName = uniqid();
$pathDocx = $pathDoc.'/'.$fileName.'.docx';
$templateProcessor->saveAs($pathDocx);
$fileNameDocx = $fileName.'.docx';