<?php 
class mDocumento {

	protected $dbh,$con,$msj;

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	}

	public function obtenerDocumentos()
	{
		$sql = "SELECT
			documento_id,
			codigo,
			nombre,
			descripcion,
			archivo,
			estado 
		FROM
			tbl_documento 
		WHERE
			estado = 1 
		ORDER BY
			nombre ASC";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	public function buscarCodigoDocumento()
	{
		$id = isset($this->id) ? $this->id : '';
		$sql = "SELECT codigo FROM tbl_documento WHERE estado = 1 AND codigo = ?";
		if (!empty($id)) {
			$sql .= " AND documento_id != $id";
		}
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->codigo);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	public function buscarNombreDocumento()
	{
		$id = isset($this->id) ? $this->id : '';
		$sql = "SELECT descripcion FROM tbl_documento WHERE estado = 1 AND descripcion = ?";
		if (!empty($id)) {
			$sql .= " AND documento_id != $id";
		}
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->descripcion);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	public function agregarDocumento($nombreArchivo)
	{
		$response = [];
		$sql = "INSERT INTO tbl_documento VALUES (null,?,?,?,?,?,1)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->codigo);
		$res->bindParam(2,$this->nombre);
		$res->bindParam(3,$this->descripcion);
		$res->bindParam(4,$nombreArchivo);
		$res->bindParam(5,$this->tipo_plantilla);
		if ($res->execute()) {
			$id=$this->con->lastInsertId();
			$response = ['status' => 'success', 'message' => 'Registro agregado con exito'];
			$this->agregarAuditorias(1,$id);
		} else {
			$response = ['status' => 'error', 'message' => $res->errorInfo()];
		}
		return $response;
	}

	public function agregarAuditorias($operacion, $id)
	{
		$this->dbh->sp_auditoria($_SESSION['ced'],$operacion,'tbl_documento',$id);
	}

	public function obtenerDocumentoPorId($id)
	{
		$sql = "SELECT codigo, nombre, descripcion, archivo, tipo_plantilla_id FROM tbl_documento WHERE documento_id = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$id);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	public function editarDocumento()
	{
		$sql = "UPDATE tbl_documento SET codigo = ?, nombre = ?, descripcion = ?, tipo_plantilla_id = ? WHERE documento_id = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->codigo);
		$res->bindParam(2,$this->nombre);
		$res->bindParam(3,$this->descripcion);
		$res->bindParam(4,$this->tipo_plantilla);
		$res->bindParam(5,$this->id);
		if ($res->execute()) {
			$response = ['status' => 'success', 'message' => 'Registro editado con exito'];
			$this->agregarAuditorias(2,$this->id);
		} else {
			$response = ['status' => 'error', 'message' => $res->errorInfo()];
		}
		return $response;
	}
	public function eliminarDocumento()
	{
		$sql = "UPDATE tbl_documento SET estado = 0 WHERE documento_id = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->id);
		$rt = ($res->execute()) ? 1 : print_r($res->errorInfo());
		return $rt;
	}
	public function obtenerTiposPlantillas()
	{
		$sql = "SELECT tipo_plantilla_id, descripcion, variables FROM tbl_tipo_plantilla WHERE estado = 1";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
	public function obtenerArchivoPlantilla($documentoId)
	{
		$sql = "SELECT
					archivo
				FROM
					 tbl_documento
				WHERE documento_id = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$documentoId);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
	public function plantillasPorTipo($tipoPlantilla)
	{
		$sql = "SELECT
					documento_id,
					nombre
				FROM
					tbl_documento
				WHERE tipo_plantilla_id = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$tipoPlantilla);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
}